/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.items.weapons;

import com.bytemaniak.mcquake3.entity.projectile.Shell;
import com.bytemaniak.mcquake3.items.weapons.Weapon;
import com.bytemaniak.mcquake3.registry.Q3StatusEffects;
import com.bytemaniak.mcquake3.registry.Sounds;
import com.bytemaniak.mcquake3.registry.Weapons;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;

public class Shotgun
extends Weapon {
    private static final long SHOTGUN_REFIRE_RATE = 20L;
    private static final float SHOTGUN_RANGE = 20.0f;
    private static final float SHOTGUN_VERTICAL_SPAWN_OFFSET = 0.5f;
    private static final float SHOTGUN_HORIZONTAL_SPAWN_OFFSET = -0.2f;
    private static final float SHOTGUN_FORWARD_SPAWN_OFFSET = 0.5f;
    private static final float SHOTGUN_PROJECTILE_SPEED = 4.25f;

    public Shotgun() {
        super(class_2960.method_60654((String)"mcquake3:shotgun"), 20L, 20L, true, Sounds.SHOTGUN_FIRE, false, Weapons.SHELL, 10, 10, 2);
    }

    private void fireProjectile(class_1937 world, class_1309 user, class_243 upVec, class_243 rightVec, class_243 destDir, class_243 weaponPos, int maxPitchSpread, int maxYawSpread) {
        class_243 spread = destDir;
        if (maxYawSpread > 0) {
            int yawSpread = ThreadLocalRandom.current().nextInt(-maxYawSpread, maxYawSpread);
            spread = spread.method_1019(rightVec.method_1021((double)((float)yawSpread / (float)maxYawSpread / 4.0f)));
        }
        if (maxPitchSpread > 0) {
            int pitchSpread = ThreadLocalRandom.current().nextInt(-maxPitchSpread, maxPitchSpread);
            spread = spread.method_1019(upVec.method_1021((double)((float)pitchSpread / (float)maxPitchSpread / 6.0f)));
        }
        Shell shell = new Shell(world);
        shell.method_7432((class_1297)user);
        shell.method_33574(weaponPos);
        shell.method_7485(spread.field_1352, spread.field_1351, spread.field_1350, 4.25f, 0.0f);
        if (user.method_6059(class_7923.field_41174.method_47983((Object)Q3StatusEffects.QUAD_DAMAGE))) {
            shell.setQuadDamage();
        }
        world.method_8649((class_1297)shell);
    }

    @Override
    protected void onWeaponRefire(class_1937 world, class_1309 user, class_1799 stack, class_243 lookDir, class_243 weaponPos) {
        if (!world.field_9236) {
            int i;
            class_243 upVec = class_243.method_1030((float)(user.method_36455() + 90.0f), (float)user.method_36454()).method_1029();
            class_243 rightVec = lookDir.method_1036(upVec).method_1029();
            class_243 offsetWeaponPos = weaponPos.method_1019(upVec.method_1021(0.5)).method_1019(rightVec.method_1021((double)-0.2f)).method_1019(lookDir.method_1021(0.5));
            class_243 destPos = user.method_33571().method_1019(lookDir.method_1021(20.0));
            class_243 destDir = destPos.method_1020(offsetWeaponPos).method_1029();
            this.fireProjectile(world, user, upVec, rightVec, destDir, offsetWeaponPos, 0, 0);
            for (i = 0; i < 3; ++i) {
                this.fireProjectile(world, user, upVec, rightVec, destDir, offsetWeaponPos, 7, 7);
            }
            for (i = 0; i < 6; ++i) {
                this.fireProjectile(world, user, upVec, rightVec, destDir, offsetWeaponPos, 12, 15);
            }
            this.triggerAnim((class_1297)user, GeoItem.getOrAssignId((class_1799)user.method_6030(), (class_3218)((class_3218)world)), "controller", "shoot");
        }
    }

    @Override
    public PlayState handle(AnimationState<Weapon> state) {
        return null;
    }
}

