/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.items.weapons;

import com.bytemaniak.mcquake3.interfaces.QuakePlayer;
import com.bytemaniak.mcquake3.items.weapons.WeaponRenderer;
import com.bytemaniak.mcquake3.registry.Sounds;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_756;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class Weapon
extends class_1792
implements GeoItem,
FabricItem,
AnimationController.AnimationStateHandler<Weapon> {
    public static final int MAX_AMMO = 198;
    private static final float HITSCAN_HORIZONTAL_OFFSET = 0.2f;
    protected static final float PROJECTILE_VERTICAL_SPAWN_OFFSET = 0.6f;
    protected static final float PROJECTILE_HORIZONTAL_SPAWN_OFFSET = -0.1f;
    protected static final float PROJECTILE_FORWARD_SPAWN_OFFSET = 0.5f;
    protected static final float PROJECTILE_DIRECTION_RANGE = 200.0f;
    private final class_2960 weaponIdentifier;
    protected long refireRateQ3;
    protected long refireRateQL;
    private final boolean hasRepeatedFiringSound;
    private final class_3414 firingSound;
    public final boolean hasActiveLoopSound;
    public final class_1792 ammoType;
    public final int startingAmmo;
    public final int ammoBoxCount;
    public final int slot;
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final SerializableDataTicket<Double> SPEED = SerializableDataTicket.ofDouble((class_2960)class_2960.method_60654((String)"mcquake3:firing_speed"));

    protected Weapon(class_2960 id, long refireRateQ3InTicks, long refireRateQLInTicks, boolean hasRepeatedFiringSound, class_3414 firingSound, boolean hasActiveLoopSound, class_1792 ammoType, int startingAmmo, int ammoBoxCount, int slot) {
        super(new class_1792.class_1793().method_7889(1));
        this.ammoType = ammoType;
        this.startingAmmo = startingAmmo;
        this.ammoBoxCount = ammoBoxCount;
        this.slot = slot;
        this.weaponIdentifier = id;
        this.refireRateQ3 = refireRateQ3InTicks;
        this.refireRateQL = refireRateQLInTicks;
        this.hasRepeatedFiringSound = hasRepeatedFiringSound;
        this.firingSound = firingSound;
        this.hasActiveLoopSound = hasActiveLoopSound;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        return class_1271.method_22430((Object)user.method_5998(hand));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 1000000;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!user.method_5805()) {
            return;
        }
        long currentTick = world.method_8510();
        QuakePlayer player = (QuakePlayer)user;
        long refireRate = player.mcquake3$hasQLRefireRate() ? this.refireRateQL : this.refireRateQ3;
        class_1293 playerHaste = user.method_6112(class_1294.field_5917);
        float refireModifier = 1.0f;
        if (playerHaste != null) {
            float f = refireModifier = playerHaste.method_5578() > 3 ? 0.7f : 1.0f - (float)playerHaste.method_5578() * 0.1f;
        }
        if (currentTick - player.mcquake3$getWeaponTick(this.slot) >= (long)((float)refireRate * refireModifier)) {
            class_1657 p = (class_1657)user;
            boolean hasAmmo = false;
            if (p.method_7337() || this.ammoType == null) {
                hasAmmo = true;
            } else {
                for (int i = 0; i < p.method_31548().method_5439(); ++i) {
                    class_1799 itemStack = p.method_31548().method_5438(i);
                    if (!itemStack.method_31574(this.ammoType)) continue;
                    hasAmmo = true;
                    itemStack.method_7934(1);
                    if (!itemStack.method_7960()) break;
                    p.method_31548().method_7378(itemStack);
                    break;
                }
            }
            if (hasAmmo) {
                class_243 lookDir = class_243.method_1030((float)user.method_36455(), (float)user.method_36454());
                class_243 upDir = class_243.method_1030((float)(user.method_36455() + 90.0f), (float)user.method_36454());
                class_243 rightDir = lookDir.method_1036(upDir).method_1029().method_1021((double)0.2f);
                class_243 weaponPos = user.method_33571().method_1020(rightDir);
                this.onWeaponRefire(world, user, stack, lookDir, weaponPos);
                if (this.hasRepeatedFiringSound) {
                    world.method_43129(null, (class_1297)user, this.firingSound, class_3419.field_15248, 1.0f, 1.0f);
                }
            } else {
                if (world.field_9236 && player.mcquake3$inQuakeArena()) {
                    player.mcquake3$scrollToNextSuitableSlot();
                }
                world.method_43129(null, (class_1297)user, Sounds.NO_AMMO, class_3419.field_15248, 1.0f, 1.0f);
            }
            player.mcquake3$setWeaponTick(this.slot, currentTick);
        }
    }

    protected abstract void onWeaponRefire(class_1937 var1, class_1309 var2, class_1799 var3, class_243 var4, class_243 var5);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Object getRenderProvider() {
        return this.cache.getRenderProvider();
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private final GeoItemRenderer<?> renderer;
            {
                this.renderer = new WeaponRenderer((GeoModel<Weapon>)new DefaultedItemGeoModel(Weapon.this.weaponIdentifier));
            }

            @Nullable
            public class_756 getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }

    public PlayState handle(AnimationState<Weapon> state) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", this::handle).triggerableAnim("shoot", DefaultAnimations.ATTACK_SHOOT).triggerableAnim("idle", DefaultAnimations.IDLE));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        QuakePlayer player;
        stack.method_57379(class_9334.field_49641, (Object)(entity instanceof QuakePlayer && (player = (QuakePlayer)entity).mcquake3$hasQuadDamage() ? 1 : 0));
        super.method_7888(stack, world, entity, slot, selected);
    }
}

