/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.mixin;

import com.bytemaniak.mcquake3.MCQuake3;
import com.bytemaniak.mcquake3.entity.PortalEntity;
import com.bytemaniak.mcquake3.interfaces.QuakePlayer;
import com.bytemaniak.mcquake3.items.weapons.Gauntlet;
import com.bytemaniak.mcquake3.items.weapons.Weapon;
import com.bytemaniak.mcquake3.registry.Components;
import com.bytemaniak.mcquake3.registry.Sounds;
import com.bytemaniak.mcquake3.registry.WorldKeys;
import com.bytemaniak.mcquake3.util.MiscUtils;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_8111;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309
implements QuakePlayer {
    @Unique
    private static final float FALL_THRESHOLD = 10.0f;
    @Unique
    private static final float FALL_DAMAGE_REDUCED = 30.0f;
    @Unique
    private static final class_2940<Integer> QUAKE_ARMOR_COLOR = class_2945.method_12791(PlayerMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> QUAKE_ARMOR_TRIM_COLOR = class_2945.method_12791(PlayerMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer>[] QUAKE_ARMOR_TRIM_TYPES = new class_2940[]{class_2945.method_12791(PlayerMixin.class, (class_2941)class_2943.field_13327), class_2945.method_12791(PlayerMixin.class, (class_2941)class_2943.field_13327), class_2945.method_12791(PlayerMixin.class, (class_2941)class_2943.field_13327), class_2945.method_12791(PlayerMixin.class, (class_2941)class_2943.field_13327)};
    @Unique
    private static final class_2940<String> QUAKE_PLAYER_SOUNDS = class_2945.method_12791(PlayerMixin.class, (class_2941)class_2943.field_13326);
    @Unique
    private static final class_2940<Integer> QUAKE_ARMOR = class_2945.method_12791(PlayerMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Boolean> HAS_QL_REFIRE_RATE = class_2945.method_12791(PlayerMixin.class, (class_2941)class_2943.field_13323);
    @Unique
    private final long[] weaponTicks = new long[9];
    @Unique
    private int portalToLink = -1;
    @Unique
    private static final long TIME_BETWEEN_HURTS = 9L;
    @Unique
    private long lastHurtTick = 0L;
    @Unique
    private String currentlyEditingArena = "";
    @Unique
    private class_2487 lastSampledData = new class_2487();
    @Unique
    private class_2487 saveSampledData = new class_2487();

    @Shadow
    public abstract class_1661 method_31548();

    @Shadow
    public abstract void method_7353(class_2561 var1, boolean var2);

    @Shadow
    public abstract boolean method_7337();

    @Shadow
    public abstract boolean method_7325();

    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    private void writeQuakeNbtData(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("quake_armor_color", ((Integer)this.field_6011.method_12789(QUAKE_ARMOR_COLOR)).intValue());
        nbt.method_10569("quake_armor_trim_color", ((Integer)this.field_6011.method_12789(QUAKE_ARMOR_TRIM_COLOR)).intValue());
        nbt.method_10569("quake_armor_trim_type1", ((Integer)this.field_6011.method_12789(QUAKE_ARMOR_TRIM_TYPES[0])).intValue());
        nbt.method_10569("quake_armor_trim_type2", ((Integer)this.field_6011.method_12789(QUAKE_ARMOR_TRIM_TYPES[1])).intValue());
        nbt.method_10569("quake_armor_trim_type3", ((Integer)this.field_6011.method_12789(QUAKE_ARMOR_TRIM_TYPES[2])).intValue());
        nbt.method_10569("quake_armor_trim_type4", ((Integer)this.field_6011.method_12789(QUAKE_ARMOR_TRIM_TYPES[3])).intValue());
        nbt.method_10582("quake_player_sounds", this.mcquake3$getPlayerVoice());
        nbt.method_10569("quake_energy_shield", this.mcquake3$getEnergyShield());
        nbt.method_10556("has_ql_refire_rate", this.mcquake3$hasQLRefireRate());
        if (!this.saveSampledData.method_33133()) {
            nbt.method_10566("q3_last_data", (class_2520)this.saveSampledData);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    private void readQuakeNbtData(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("q3_last_data")) {
            this.lastSampledData = nbt.method_10562("q3_last_data");
        }
        this.field_6011.method_12778(QUAKE_ARMOR_COLOR, (Object)nbt.method_10550("quake_armor_color"));
        this.field_6011.method_12778(QUAKE_ARMOR_TRIM_COLOR, (Object)nbt.method_10550("quake_armor_trim_color"));
        this.field_6011.method_12778(QUAKE_ARMOR_TRIM_TYPES[0], (Object)nbt.method_10550("quake_armor_trim_type1"));
        this.field_6011.method_12778(QUAKE_ARMOR_TRIM_TYPES[1], (Object)nbt.method_10550("quake_armor_trim_type2"));
        this.field_6011.method_12778(QUAKE_ARMOR_TRIM_TYPES[2], (Object)nbt.method_10550("quake_armor_trim_type3"));
        this.field_6011.method_12778(QUAKE_ARMOR_TRIM_TYPES[3], (Object)nbt.method_10550("quake_armor_trim_type4"));
        this.field_6011.method_12778(QUAKE_ARMOR, (Object)nbt.method_10550("quake_energy_shield"));
        this.field_6011.method_12778(HAS_QL_REFIRE_RATE, (Object)nbt.method_10577("has_ql_refire_rate"));
        String quakePlayerSounds = nbt.method_10558("quake_player_sounds");
        this.mcquake3$setPlayerVoice(quakePlayerSounds);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    public void initQuakeDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(QUAKE_ARMOR_COLOR, (Object)10840891);
        builder.method_56912(QUAKE_ARMOR_TRIM_COLOR, (Object)9);
        builder.method_56912(QUAKE_ARMOR_TRIM_TYPES[0], (Object)11);
        builder.method_56912(QUAKE_ARMOR_TRIM_TYPES[1], (Object)11);
        builder.method_56912(QUAKE_ARMOR_TRIM_TYPES[2], (Object)11);
        builder.method_56912(QUAKE_ARMOR_TRIM_TYPES[3], (Object)5);
        builder.method_56912(QUAKE_PLAYER_SOUNDS, (Object)"Vanilla");
        builder.method_56912(QUAKE_ARMOR, (Object)0);
        builder.method_56912(HAS_QL_REFIRE_RATE, (Object)false);
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;resetLastAttackedTicks()V")})
    public void playWeaponSwitchSound(class_1657 playerEntity, Operation<Void> original) {
        if (!this.method_37908().field_9236 && playerEntity.method_6047().method_7909() instanceof Weapon) {
            this.method_37908().method_43129(null, (class_1297)this, Sounds.WEAPON_CHANGE, class_3419.field_15254, 1.0f, 1.0f);
        }
        original.call(new Object[]{playerEntity});
    }

    @WrapOperation(method={"addExhaustion"}, at={@At(value="FIELD", target="Lnet/minecraft/world/World;isClient:Z")})
    private boolean cancelExhaustionInQuakeArena(class_1937 world, Operation<Boolean> original) {
        if (world.method_40134().method_40225(WorldKeys.Q3_DIMENSION_TYPE)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{world});
    }

    @WrapOperation(method={"handleFallDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;handleFallDamage(FFLnet/minecraft/entity/damage/DamageSource;)Z")})
    public boolean reduceFallDistanceInQuakeArena(class_1657 player, float fallDistance, float damageMultiplier, class_1282 damageSource, Operation<Boolean> original) {
        if (this.mcquake3$inQuakeArena()) {
            if (fallDistance < 10.0f) {
                fallDistance = 0.0f;
            } else if (fallDistance < 30.0f) {
                fallDistance /= 4.0f;
            }
        }
        return (Boolean)original.call(new Object[]{player, Float.valueOf(fallDistance), Float.valueOf(damageMultiplier), damageSource});
    }

    @WrapOperation(method={"interact"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;interact(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;")})
    private class_1269 cancelMobInteract(class_1297 instance, class_1657 player, class_1268 hand, Operation<class_1269> original) {
        if (this.method_6047().method_7909() instanceof Weapon) {
            return class_1269.field_5814;
        }
        return (class_1269)original.call(new Object[]{instance, player, hand});
    }

    @WrapOperation(method={"jump"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;jump()V")})
    private void playQuakeJumpSound(class_1657 player, Operation<Void> original) {
        if (this.mcquake3$quakePlayerSoundsEnabled()) {
            Sounds.PlayerSounds playerSounds = new Sounds.PlayerSounds(this.mcquake3$getPlayerVoice());
            this.method_37908().method_43129(null, (class_1297)this, class_3414.method_47908((class_2960)playerSounds.JUMP), class_3419.field_15248, 1.0f, 1.0f);
        }
        original.call(new Object[]{player});
    }

    @WrapOperation(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$Key;)Z")})
    private boolean noDropInventoryInQuakeArena(class_1928 rules, class_1928.class_4313<class_1928.class_4310> rule, Operation<Boolean> original) {
        if (this.mcquake3$inQuakeArena()) {
            return true;
        }
        return (Boolean)original.call(new Object[]{rules, rule});
    }

    @WrapOperation(method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z")})
    private boolean stopWeaponAnimation(class_1799 stack, Operation<Boolean> original) {
        if (stack.method_7909() instanceof Weapon) {
            stack.method_57379(Components.FIRING_SPEED, (Object)0.0);
        }
        return (Boolean)original.call(new Object[]{stack});
    }

    @WrapOperation(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/damage/DamageSource;isScaledWithDifficulty()Z")})
    private boolean normalizeDamageInQuakeArena(class_1282 source, Operation<Boolean> original) {
        if (this.mcquake3$inQuakeArena()) {
            return false;
        }
        return (Boolean)original.call(new Object[]{source});
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;update(Lnet/minecraft/entity/player/PlayerEntity;)V")})
    private void cancelHungerUpdateInArena(class_1702 instance, class_1657 player, Operation<Void> original) {
        if (this.mcquake3$inQuakeArena()) {
            return;
        }
        original.call(new Object[]{instance, player});
    }

    @WrapOperation(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z")})
    private boolean absorbDamageToEnergyShieldInQuakeArena(class_1657 player, class_1282 source, float amount, Operation<Boolean> original) {
        if (this.mcquake3$inQuakeArena()) {
            float damage;
            int energyShield = this.mcquake3$getEnergyShield();
            if ((float)energyShield > (damage = MiscUtils.fromMCDamage(amount)) * 0.66f) {
                energyShield -= (int)(damage * 0.66f);
                damage *= 0.33f;
            } else {
                damage -= (float)energyShield;
                energyShield = 0;
            }
            if (!this.method_37908().field_9236) {
                this.mcquake3$setEnergyShield(energyShield);
            }
            amount = MiscUtils.toMCDamage(damage);
        }
        return (Boolean)original.call(new Object[]{player, source, Float.valueOf(amount)});
    }

    @Override
    public boolean mcquake3$inQuakeArena() {
        return this.method_37908().method_40134().method_40225(WorldKeys.Q3_DIMENSION_TYPE) && !this.method_7337() && !this.method_7325();
    }

    @Override
    public long mcquake3$getWeaponTick(int id) {
        return this.weaponTicks[id];
    }

    @Override
    public void mcquake3$setWeaponTick(int id, long tick) {
        this.weaponTicks[id] = tick;
    }

    @Override
    public boolean mcquake3$hasQLRefireRate() {
        return (Boolean)this.field_6011.method_12789(HAS_QL_REFIRE_RATE);
    }

    @Override
    public void mcquake3$setQLRefireRate(boolean hasQLRefire) {
        this.field_6011.method_12778(HAS_QL_REFIRE_RATE, (Object)hasQLRefire);
    }

    @Override
    public void mcquake3$scrollToNextSuitableSlot() {
        int slot;
        class_1661 inv = this.method_31548();
        int nextSlot = slot = inv.field_7545;
        block0: do {
            inv.method_7373(-1.0);
            nextSlot = (nextSlot + 1) % 9;
            class_1799 stack = inv.method_7391();
            class_1792 item = stack.method_7909();
            if (stack.method_31574(class_1802.field_8162)) continue;
            if (!(item instanceof Weapon) || item instanceof Gauntlet) break;
            for (int i = class_1661.method_7368(); i < inv.method_5439(); ++i) {
                class_1799 itemStack = inv.method_5438(i);
                if (itemStack.method_31574(((Weapon)item).ammoType)) break block0;
            }
        } while (nextSlot != slot);
    }

    @Override
    public int mcquake3$getCurrentQuakeWeaponId() {
        class_1792 class_17922 = this.method_6047().method_7909();
        if (class_17922 instanceof Weapon) {
            Weapon weapon = (Weapon)class_17922;
            return weapon.slot;
        }
        return -1;
    }

    @Override
    public int mcquake3$getEnergyShield() {
        return (Integer)this.field_6011.method_12789(QUAKE_ARMOR);
    }

    @Override
    public void mcquake3$setEnergyShield(int amount) {
        this.field_6011.method_12778(QUAKE_ARMOR, (Object)amount);
    }

    @Override
    public void mcquake3$addEnergyShield(int amount) {
        int currentShield = (Integer)this.field_6011.method_12789(QUAKE_ARMOR);
        if ((currentShield += amount) > 200) {
            currentShield = 200;
        }
        this.field_6011.method_12778(QUAKE_ARMOR, (Object)currentShield);
    }

    @Override
    public boolean mcquake3$quakePlayerSoundsEnabled() {
        return !((String)this.field_6011.method_12789(QUAKE_PLAYER_SOUNDS)).equals("Vanilla");
    }

    @Override
    public String mcquake3$getPlayerVoice() {
        return (String)this.field_6011.method_12789(QUAKE_PLAYER_SOUNDS);
    }

    @Override
    public void mcquake3$setPlayerVoice(String soundsSet) {
        this.field_6011.method_12778(QUAKE_PLAYER_SOUNDS, (Object)soundsSet);
    }

    @Override
    public class_3414 mcquake3$getPlayerHurtSound(class_1282 source) {
        Sounds.PlayerSounds playerSounds = new Sounds.PlayerSounds(this.mcquake3$getPlayerVoice());
        if (source.method_49708(class_8111.field_42345)) {
            return class_3414.method_47908((class_2960)playerSounds.FALL);
        }
        if (source.method_49708(class_8111.field_42342)) {
            return class_3414.method_47908((class_2960)playerSounds.DROWN);
        }
        long currentTick = this.method_37908().method_8510();
        if (currentTick - this.lastHurtTick >= 9L) {
            this.lastHurtTick = currentTick;
            if (this.method_5777(class_3486.field_15517)) {
                return class_3414.method_47908((class_2960)playerSounds.DROWN);
            }
            if (this.method_6032() >= 15.0f) {
                return class_3414.method_47908((class_2960)playerSounds.HURT100);
            }
            if (this.method_6032() >= 10.0f) {
                return class_3414.method_47908((class_2960)playerSounds.HURT75);
            }
            if (this.method_6032() >= 5.0f) {
                return class_3414.method_47908((class_2960)playerSounds.HURT50);
            }
            return class_3414.method_47908((class_2960)playerSounds.HURT25);
        }
        return null;
    }

    @Override
    public class_3414 mcquake3$getPlayerDeathSound() {
        Sounds.PlayerSounds playerSounds = new Sounds.PlayerSounds(this.mcquake3$getPlayerVoice());
        return class_3414.method_47908((class_2960)playerSounds.DEATH);
    }

    @Override
    public void mcquake3$taunt() {
        if (this.mcquake3$quakePlayerSoundsEnabled()) {
            Sounds.PlayerSounds playerSounds = new Sounds.PlayerSounds(this.mcquake3$getPlayerVoice());
            this.method_37908().method_43129(null, (class_1297)this, class_3414.method_47908((class_2960)playerSounds.TAUNT), class_3419.field_15254, 1.0f, 1.0f);
        }
    }

    @Override
    public void mcquake3$setPortalToLink(PortalEntity entity) {
        int x = entity.method_31477();
        int y = entity.method_31478();
        int z = entity.method_31479();
        this.method_7353(class_2561.method_30163((String)("Portal [" + x + ", " + y + ", " + z + "] link started")), true);
        this.portalToLink = entity.method_5628();
    }

    @Override
    public void mcquake3$setLinkedPortalCoords() {
        if (this.portalToLink == -1) {
            return;
        }
        class_1297 entity = this.method_37908().method_8469(this.portalToLink);
        if (entity instanceof PortalEntity) {
            PortalEntity portalEntity = (PortalEntity)entity;
            int px = portalEntity.method_31477();
            int py = portalEntity.method_31478();
            int pz = portalEntity.method_31479();
            int x = this.method_31477();
            int y = this.method_31478();
            int z = this.method_31479();
            portalEntity.setActive(true);
            portalEntity.setTeleportCoords(x, y, z);
            portalEntity.setTeleportFacing(this.method_5735());
            this.method_7353(class_2561.method_30163((String)("Portal [" + px + ", " + py + ", " + pz + "] linked to [" + x + ", " + y + ", " + z + "], facing " + this.method_5735().method_15434())), true);
            this.portalToLink = -1;
        }
    }

    @Override
    public void mcquake3$setCurrentlyEditingArena(String arenaName) {
        this.currentlyEditingArena = arenaName;
    }

    @Override
    public String mcquake3$getCurrentlyEditingArena() {
        return this.currentlyEditingArena;
    }

    @Override
    public void mcquake3$sampleLastVanillaData() {
        if (this.lastSampledData.method_33133()) {
            this.method_5647(this.lastSampledData);
            this.lastSampledData.method_10548("q3_prev_max_health", this.method_6063());
            this.saveSampledData = this.lastSampledData.method_10553();
        }
    }

    @Override
    public void mcquake3$restoreLastVanillaData() {
        int quakeArmorColor = this.mcquake3$getQuakeArmorColor();
        int quakeArmorTrimColor = this.mcquake3$getQuakeArmorTrimColor();
        List<Integer> quakeArmorTrimTypes = List.of(Integer.valueOf(this.mcquake3$getQuakeArmorTrimType(0)), Integer.valueOf(this.mcquake3$getQuakeArmorTrimType(1)), Integer.valueOf(this.mcquake3$getQuakeArmorTrimType(2)), Integer.valueOf(this.mcquake3$getQuakeArmorTrimType(3)));
        if (!this.lastSampledData.method_33133()) {
            this.method_5651(this.lastSampledData);
            this.method_5996(class_5134.field_23716).method_6192((double)this.lastSampledData.method_10583("q3_prev_max_health"));
            this.method_6008();
            ((class_3222)this).method_7336(class_1934.method_8384((int)this.lastSampledData.method_10550("playerGameType")));
            this.saveSampledData = new class_2487();
            this.lastSampledData = new class_2487();
        }
        this.mcquake3$setQuakeArmorColor(quakeArmorColor);
        this.mcquake3$setQuakeArmorTrimColor(quakeArmorTrimColor);
        for (int i = 0; i < 4; ++i) {
            this.mcquake3$setQuakeArmorTrimType(i, quakeArmorTrimTypes.get(i));
        }
    }

    @Override
    public class_2487 mcquake3$getLastVanillaData() {
        return this.lastSampledData;
    }

    @Override
    public void mcquake3$setLastVanillaData(class_2487 nbt) {
        this.lastSampledData = nbt;
    }

    @Override
    public class_3218 mcquake3$getLastVanillaWorld() {
        class_5321 dimension = class_2874.method_28521((Dynamic)new Dynamic((DynamicOps)class_2509.field_11560, (Object)this.lastSampledData.method_10580("Dimension"))).resultOrPartial(arg_0 -> ((Logger)MCQuake3.LOGGER).error(arg_0)).orElse(class_1937.field_25179);
        return this.method_5682().method_3847(dimension);
    }

    @Override
    public int mcquake3$getQuakeArmorColor() {
        return (Integer)this.field_6011.method_12789(QUAKE_ARMOR_COLOR);
    }

    @Override
    public void mcquake3$setQuakeArmorColor(int color) {
        this.field_6011.method_12778(QUAKE_ARMOR_COLOR, (Object)color);
    }

    @Override
    public int mcquake3$getQuakeArmorTrimColor() {
        return (Integer)this.field_6011.method_12789(QUAKE_ARMOR_TRIM_COLOR);
    }

    @Override
    public void mcquake3$setQuakeArmorTrimColor(int color) {
        this.field_6011.method_12778(QUAKE_ARMOR_TRIM_COLOR, (Object)color);
    }

    @Override
    public int mcquake3$getQuakeArmorTrimType(int slot) {
        return (Integer)this.field_6011.method_12789(QUAKE_ARMOR_TRIM_TYPES[slot]);
    }

    @Override
    public void mcquake3$setQuakeArmorTrimType(int slot, int type) {
        this.field_6011.method_12778(QUAKE_ARMOR_TRIM_TYPES[slot], (Object)type);
    }
}

