/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.mixin.misc;

import com.bytemaniak.mcquake3.entity.ItemEntityGotoNonHotbar;
import com.bytemaniak.mcquake3.interfaces.QuakePlayer;
import com.bytemaniak.mcquake3.items.weapons.Weapon;
import com.bytemaniak.mcquake3.network.s2c.PlayerAmmoUpdateTrailFixS2CPacket;
import com.bytemaniak.mcquake3.registry.Q3StatusEffects;
import com.bytemaniak.mcquake3.registry.ServerEvents;
import com.bytemaniak.mcquake3.registry.Weapons;
import com.bytemaniak.mcquake3.registry.WorldKeys;
import com.bytemaniak.mcquake3.util.MiscUtils;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements QuakePlayer {
    @Unique
    private static final class_2940<Boolean> QUAD_DAMAGE_VISIBLE = class_2945.method_12791(LivingEntityMixin.class, (class_2941)class_2943.field_13323);

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract float method_6032();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @WrapOperation(method={"onDamaged"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/LivingEntity;hurtTime:I", opcode=181)})
    private void cancelHurtTilt(class_1309 entity, int value, Operation<Void> original) {
        class_1282 lastDamageSource = entity.method_6081();
        if (lastDamageSource != null && entity instanceof class_1657 && lastDamageSource.method_5525().contains("mcquake3")) {
            entity.field_6235 = 0;
        } else {
            original.call(new Object[]{entity, value});
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;sendEquipmentChanges()V")})
    private void sendAmmoUpdatesWeaponTrailFix(class_1309 entity, Operation<Void> original) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PlayerAmmoUpdateTrailFixS2CPacket buf = new PlayerAmmoUpdateTrailFixS2CPacket(player.method_5667(), player.method_31548().method_7395(new class_1799((class_1935)Weapons.LIGHTNING_CELL)) > -1, player.method_31548().method_7395(new class_1799((class_1935)Weapons.RAILGUN_ROUND)) > -1);
            for (class_3222 plr : PlayerLookup.tracking((class_1297)player)) {
                ServerPlayNetworking.send((class_3222)plr, (class_8710)buf);
            }
        }
        original.call(new Object[]{entity});
    }

    @WrapOperation(method={"tickStatusEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;updatePotionVisibility()V")})
    private void updateQuadDamageVisibility(class_1309 entity, Operation<Void> original) {
        this.field_6011.method_12778(QUAD_DAMAGE_VISIBLE, (Object)this.method_6059((class_6880<class_1291>)class_7923.field_41174.method_47983((Object)Q3StatusEffects.QUAD_DAMAGE)));
        original.call(new Object[]{entity});
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;shouldUpdatePostDeath(Lnet/minecraft/entity/Entity;)Z")})
    private boolean cancelPlayerRemovalInArena(class_1937 world, class_1297 entity, Operation<Boolean> original) {
        class_3222 player;
        if (entity instanceof class_3222 && ((QuakePlayer)(player = (class_3222)entity)).mcquake3$inQuakeArena()) {
            return false;
        }
        return (Boolean)original.call(new Object[]{world, entity});
    }

    @WrapOperation(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;onDeath(Lnet/minecraft/entity/damage/DamageSource;)V")})
    private void onArenaDeath(class_1309 entity, class_1282 damageSource, Operation<Void> original) {
        class_3222 player;
        if (entity instanceof class_3222 && ((QuakePlayer)(player = (class_3222)entity)).mcquake3$inQuakeArena()) {
            class_1792 class_17922 = player.method_6047().method_7909();
            if (class_17922 instanceof Weapon) {
                Weapon weapon = (Weapon)class_17922;
                class_3218 world = player.method_51469();
                for (int i = class_1661.method_7368(); i < player.method_31548().method_5439(); ++i) {
                    class_1799 itemStack = player.method_31548().method_5438(i);
                    if (!itemStack.method_31574(weapon.ammoType)) continue;
                    int countLeft = 198 - MiscUtils.getCountOfItemType(player.method_31548(), weapon.ammoType);
                    int count = Math.min(weapon.ammoBoxCount / 2, countLeft);
                    class_1799 ammoDrop = new class_1799((class_1935)weapon.ammoType, count);
                    ItemEntityGotoNonHotbar ammoEntity = new ItemEntityGotoNonHotbar(world, player.method_23317(), player.method_23318(), player.method_23321(), ammoDrop, 198);
                    ammoEntity.method_6982(20);
                    world.method_8649((class_1297)ammoEntity);
                    break;
                }
            }
            ServerEvents.QUAKE_MATCH_STATE.recordDeath(player, damageSource);
        }
        original.call(new Object[]{entity, damageSource});
    }

    @WrapOperation(method={"playHurtSound"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getHurtSound(Lnet/minecraft/entity/damage/DamageSource;)Lnet/minecraft/sound/SoundEvent;")})
    private class_3414 playQuakePlayerHurtSound(class_1309 entity, class_1282 source, Operation<class_3414> original) {
        class_1657 player;
        if (entity instanceof class_1657 && ((QuakePlayer)(player = (class_1657)entity)).mcquake3$quakePlayerSoundsEnabled()) {
            return ((QuakePlayer)player).mcquake3$getPlayerHurtSound(source);
        }
        return (class_3414)original.call(new Object[]{entity, source});
    }

    @WrapOperation(method={"onDamaged"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getHurtSound(Lnet/minecraft/entity/damage/DamageSource;)Lnet/minecraft/sound/SoundEvent;")})
    private class_3414 playQuakePlayerHurtSound2(class_1309 entity, class_1282 source, Operation<class_3414> original) {
        class_1657 player;
        if (entity instanceof class_1657 && ((QuakePlayer)(player = (class_1657)entity)).mcquake3$quakePlayerSoundsEnabled()) {
            return ((QuakePlayer)player).mcquake3$getPlayerHurtSound(source);
        }
        return (class_3414)original.call(new Object[]{entity, source});
    }

    @WrapOperation(method={"handleStatus"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getDeathSound()Lnet/minecraft/sound/SoundEvent;")})
    private class_3414 playQuakePlayerDeathSound(class_1309 entity, Operation<class_3414> original) {
        class_1657 player;
        if (entity instanceof class_1657 && ((QuakePlayer)(player = (class_1657)entity)).mcquake3$quakePlayerSoundsEnabled()) {
            return ((QuakePlayer)player).mcquake3$getPlayerDeathSound();
        }
        return (class_3414)original.call(new Object[]{entity});
    }

    @WrapOperation(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getDeathSound()Lnet/minecraft/sound/SoundEvent;")})
    private class_3414 playQuakePlayerDeathSound2(class_1309 entity, Operation<class_3414> original) {
        class_1657 player;
        if (entity instanceof class_1657 && ((QuakePlayer)(player = (class_1657)entity)).mcquake3$quakePlayerSoundsEnabled()) {
            return ((QuakePlayer)player).mcquake3$getPlayerDeathSound();
        }
        return (class_3414)original.call(new Object[]{entity});
    }

    @WrapOperation(method={"getArmor"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getAttributeValue(Lnet/minecraft/registry/entry/RegistryEntry;)D")})
    private double cancelArmorInQuakeArena(class_1309 entity, class_6880<class_1320> attribute, Operation<Double> original) {
        if (entity instanceof class_1657 && entity.method_5770().method_40134().method_40225(WorldKeys.Q3_DIMENSION_TYPE)) {
            return 0.0;
        }
        return (Double)original.call(new Object[]{entity, attribute});
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void initQuadDamageTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(QUAD_DAMAGE_VISIBLE, (Object)false);
    }

    @Override
    public boolean mcquake3$hasQuadDamage() {
        return (Boolean)this.field_6011.method_12789(QUAD_DAMAGE_VISIBLE);
    }
}

