/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.mixin.misc;

import com.bytemaniak.mcquake3.interfaces.QuakePlayer;
import com.bytemaniak.mcquake3.items.weapons.Weapon;
import com.bytemaniak.mcquake3.registry.Sounds;
import com.bytemaniak.mcquake3.registry.Weapons;
import com.bytemaniak.mcquake3.sound.LightningActive;
import com.bytemaniak.mcquake3.sound.WeaponActive;
import com.bytemaniak.mcquake3.sound.WeaponHum;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_1657.class})
public abstract class WeaponSoundsMixin
extends class_1309
implements QuakePlayer {
    @Unique
    private boolean isHoldingGauntlet = false;
    @Unique
    private boolean isHoldingLightning = false;
    @Unique
    private boolean isHoldingRailgun = false;
    @Unique
    private boolean playingHumSound = false;
    @Unique
    private boolean playingAttackSound = false;

    protected WeaponSoundsMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tick()V")})
    private void handleLoopingWeaponSounds(class_1657 player, Operation<Void> original) {
        original.call(new Object[]{player});
        if (player.method_37908().field_9236) {
            class_1799 handStack = player.method_6047();
            class_1792 class_17922 = handStack.method_7909();
            if (class_17922 instanceof Weapon) {
                Weapon weapon = (Weapon)class_17922;
                if (handStack.method_31574((class_1792)Weapons.GAUNTLET)) {
                    if (!this.isHoldingGauntlet) {
                        this.isHoldingGauntlet = true;
                        this.playHum(player, weapon.slot);
                        this.isHoldingLightning = false;
                        this.isHoldingRailgun = false;
                    }
                } else if (handStack.method_31574((class_1792)Weapons.LIGHTNING_GUN)) {
                    if (!this.isHoldingLightning) {
                        this.isHoldingLightning = true;
                        this.playHum(player, weapon.slot);
                        this.isHoldingGauntlet = false;
                        this.isHoldingRailgun = false;
                    }
                } else if (handStack.method_31574((class_1792)Weapons.RAILGUN)) {
                    if (!this.isHoldingRailgun) {
                        this.isHoldingRailgun = true;
                        this.playHum(player, weapon.slot);
                        this.isHoldingGauntlet = false;
                        this.isHoldingLightning = false;
                    }
                } else {
                    this.isHoldingGauntlet = false;
                    this.isHoldingRailgun = false;
                    this.isHoldingLightning = false;
                    this.stopSounds();
                }
                if (weapon.hasActiveLoopSound) {
                    if (!player.method_6115() && this.playingAttackSound) {
                        this.playHum(player, weapon.slot);
                    } else if (player.method_6115() && !this.playingAttackSound) {
                        this.playAttackSound(player, weapon.slot);
                    }
                }
            } else if (this.playingHumSound || this.playingAttackSound) {
                this.isHoldingGauntlet = false;
                this.isHoldingRailgun = false;
                this.isHoldingLightning = false;
                this.stopSounds();
            }
        }
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    public void playHum(class_1657 player, int id) {
        this.stopSounds();
        class_1144 manager = class_310.method_1551().method_1483();
        WeaponHum humSound = null;
        if (id == Weapons.GAUNTLET.slot) {
            humSound = new WeaponHum((class_1297)player, Sounds.GAUNTLET_HUM, id);
        } else if (id == Weapons.RAILGUN.slot) {
            humSound = new WeaponHum((class_1297)player, Sounds.RAILGUN_HUM, id);
        }
        if (humSound != null) {
            manager.method_4873((class_1113)humSound);
            this.playingHumSound = true;
        }
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    public void stopHum() {
        this.playingHumSound = false;
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    public void playAttackSound(class_1657 player, int id) {
        this.stopSounds();
        class_1144 manager = class_310.method_1551().method_1483();
        WeaponActive attackSound = null;
        if (id == Weapons.GAUNTLET.slot) {
            attackSound = new WeaponActive((class_1297)player, Sounds.GAUNTLET_ACTIVE, id);
        } else if (id == Weapons.LIGHTNING_GUN.slot) {
            attackSound = new LightningActive((class_1297)player, id);
        }
        if (attackSound != null) {
            manager.method_4873((class_1113)attackSound);
            this.playingAttackSound = true;
        }
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    public void stopAttackSound() {
        this.playingAttackSound = false;
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    private void stopSounds() {
        this.stopHum();
        this.stopAttackSound();
    }

    @Override
    @Unique
    @Environment(value=EnvType.CLIENT)
    public boolean mcquake3$isPlayingHum() {
        return this.playingHumSound;
    }

    @Override
    @Unique
    @Environment(value=EnvType.CLIENT)
    public boolean mcquake3$isPlayingAttack() {
        return this.playingAttackSound;
    }
}

