/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.network.events;

import com.bytemaniak.mcquake3.data.QuakeArenasParameters;
import com.bytemaniak.mcquake3.entity.ItemEntityGotoNonHotbar;
import com.bytemaniak.mcquake3.entity.projectile.SimpleProjectile;
import com.bytemaniak.mcquake3.interfaces.QuakePlayer;
import com.bytemaniak.mcquake3.network.s2c.PlayAnnouncerSoundS2CPacket;
import com.bytemaniak.mcquake3.registry.Sounds;
import com.bytemaniak.mcquake3.registry.Statistics;
import com.bytemaniak.mcquake3.registry.WorldKeys;
import com.bytemaniak.mcquake3.util.MatchUtils;
import com.bytemaniak.mcquake3.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_269;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_8710;
import net.minecraft.class_9014;
import net.minecraft.class_9015;

public class QuakeMatchState
implements ServerTickEvents.StartWorldTick {
    public static final int FRAG_LIMIT = 30;
    public QuakeArenasParameters.ArenaData arena = null;
    private MatchState matchState = MatchState.WARMUP_STATE;
    private int highestFrags = 0;
    private String winner;
    private int ticksLeft;
    private List<class_3222> quakePlayers;
    private final List<String> presentPlayers = new ArrayList<String>();

    private List<class_3222> getQuakePlayers(class_3218 world) {
        return world.method_18766(player -> ((QuakePlayer)player).mcquake3$inQuakeArena());
    }

    public void recordDeath(class_3222 player, class_1282 damageSource) {
        if (this.matchState == MatchState.IN_PROGRESS_STATE) {
            class_3222 attackerPlayer;
            class_269 scoreboard = player.method_7327();
            class_1297 class_12972 = damageSource.method_5529();
            if (class_12972 instanceof class_3222 && (attackerPlayer = (class_3222)class_12972) != player) {
                scoreboard.method_1162(Statistics.Q3_MATCH_FRAGS_CRITERIA, (class_9015)attackerPlayer, class_9014::method_55413);
                attackerPlayer.method_7281(Statistics.Q3_MATCH_FRAGS_IDENT);
                int frags = scoreboard.method_55430((class_9015)attackerPlayer, scoreboard.method_1170("q3_match_frags")).method_55397();
                if (frags > this.highestFrags) {
                    int fragsLeft = 30 - frags;
                    switch (fragsLeft) {
                        case 3: {
                            this.sendGlobalSound(Sounds.THREE_FRAGS);
                            break;
                        }
                        case 2: {
                            this.sendGlobalSound(Sounds.TWO_FRAGS);
                            break;
                        }
                        case 1: {
                            this.sendGlobalSound(Sounds.ONE_FRAG);
                            break;
                        }
                        case 0: {
                            this.winner = attackerPlayer.method_5477().getString();
                        }
                    }
                    this.highestFrags = frags;
                }
            } else {
                scoreboard.method_1162(Statistics.Q3_MATCH_FRAGS_CRITERIA, (class_9015)player, score -> score.method_55410(score.method_55409() - 1));
                int newHighestFrags = Integer.MIN_VALUE;
                for (String playerName : this.presentPlayers) {
                    int playerScore = scoreboard.method_55430((class_9015)player.field_13995.method_3760().method_14566(playerName), scoreboard.method_1170("q3_match_frags")).method_55397();
                    if (playerScore <= newHighestFrags) continue;
                    newHighestFrags = playerScore;
                }
                this.highestFrags = newHighestFrags;
            }
        }
    }

    public void spawnQuakePlayer(class_3222 player) {
        if (player.method_5805() && !player.method_14208()) {
            player.field_6017 = 0.0f;
            QuakeArenasParameters.ArenaData.Spawnpoint spawnpoint = this.arena.spawnpoints.get(ThreadLocalRandom.current().nextInt(this.arena.spawnpoints.size()));
            class_243 position = spawnpoint.position().method_61082();
            player.field_13987.method_14363(position.field_1352, position.field_1351, position.field_1350, spawnpoint.yaw(), 0.0f);
            MatchUtils.onPlayerRespawn(player);
        }
    }

    private void updatePlayerList(class_3218 world) {
        this.quakePlayers = this.getQuakePlayers(world).stream().toList();
        List<String> playerNames = this.quakePlayers.stream().map(plr -> plr.method_5477().getString()).toList();
        for (String name : playerNames) {
            if (this.presentPlayers.contains(name)) continue;
            this.sendGlobalMessage(class_2561.method_30163((String)(name + " has joined the arena")), false);
            this.presentPlayers.add(name);
        }
        this.presentPlayers.removeIf(plr -> {
            boolean remove = playerNames.stream().noneMatch(name -> name.equals(plr));
            if (remove) {
                this.sendGlobalMessage(class_2561.method_30163((String)(plr + " has left the arena")), false);
            }
            return remove;
        });
        if (this.quakePlayers.isEmpty()) {
            this.highestFrags = 0;
            this.matchState = MatchState.WARMUP_STATE;
        }
    }

    private void sendSound(class_3222 player, class_3414 sound) {
        PlayAnnouncerSoundS2CPacket buf = new PlayAnnouncerSoundS2CPacket(sound.method_14833());
        ServerPlayNetworking.send((class_3222)player, (class_8710)buf);
    }

    private void sendGlobalSound(class_3414 sound) {
        for (class_3222 player : this.quakePlayers) {
            this.sendSound(player, sound);
        }
    }

    private void sendGlobalMessage(class_2561 message, boolean overlay) {
        for (class_3222 player : this.quakePlayers) {
            player.method_7353(message, overlay);
        }
    }

    private void sendGlobalMessageWithSound(String message, class_3414 sound) {
        this.sendGlobalMessage(class_2561.method_30163((String)message), true);
        this.sendGlobalSound(sound);
    }

    private void reset(class_3218 world) {
        world.method_27909().forEach(entity -> {
            if (entity instanceof SimpleProjectile || entity instanceof ItemEntityGotoNonHotbar) {
                entity.method_5768();
            }
        });
        for (class_3222 player : this.getQuakePlayers(world)) {
            this.spawnQuakePlayer(player);
        }
    }

    public void onStartTick(class_3218 world) {
        Object state;
        if (!world.method_40134().method_40225(WorldKeys.Q3_DIMENSION_TYPE)) {
            return;
        }
        this.updatePlayerList(world.method_8503().method_3847(WorldKeys.Q3_DIMENSION));
        if (this.arena == null) {
            state = QuakeArenasParameters.getServerState(world.method_8503());
            QuakeArenasParameters.ArenaData newArena = state.getRandomArena(null);
            if (newArena == null || newArena.spawnpoints.isEmpty()) {
                return;
            }
            this.arena = newArena;
            this.matchState = MatchState.WARMUP_STATE;
        }
        if (this.quakePlayers.size() < 2) {
            this.sendGlobalMessage(class_2561.method_30163((String)"Waiting for more players..."), true);
            this.matchState = MatchState.WARMUP_STATE;
            return;
        }
        switch (this.matchState.ordinal()) {
            case 0: {
                for (class_3222 player : this.getQuakePlayers(world)) {
                    player.method_7327().method_1162(Statistics.Q3_MATCH_FRAGS_CRITERIA, (class_9015)player, class_9014::method_55415);
                }
                this.ticksLeft = MiscUtils.toTicks(11.0f);
                this.matchState = MatchState.READY_STATE;
                break;
            }
            case 1: {
                if (this.ticksLeft % MiscUtils.toTicks(1.0f) != 0) break;
                switch (this.ticksLeft / MiscUtils.toTicks(1.0f)) {
                    case 10: {
                        this.sendGlobalMessageWithSound("Prepare to fight", Sounds.PREPARE);
                        break;
                    }
                    case 3: {
                        this.sendGlobalMessageWithSound("3", Sounds.THREE);
                        break;
                    }
                    case 2: {
                        this.sendGlobalMessageWithSound("2", Sounds.TWO);
                        break;
                    }
                    case 1: {
                        this.sendGlobalMessageWithSound("1", Sounds.ONE);
                        break;
                    }
                    case 0: {
                        this.sendGlobalMessageWithSound("Fight", Sounds.FIGHT);
                        this.reset(world);
                        this.ticksLeft = MiscUtils.toTicks(1200.0f);
                        this.matchState = MatchState.IN_PROGRESS_STATE;
                    }
                }
                break;
            }
            case 2: {
                if (this.highestFrags < 30 && this.ticksLeft != 0) break;
                for (class_3222 player : this.getQuakePlayers(world)) {
                    if (player.method_5477().getString().equals(this.winner)) {
                        this.sendSound(player, Sounds.MATCH_WIN);
                        player.method_7281(Statistics.Q3_MATCHES_WON_IDENT);
                        continue;
                    }
                    this.sendSound(player, Sounds.MATCH_LOSS);
                    player.method_7281(Statistics.Q3_MATCHES_LOST_IDENT);
                }
                this.ticksLeft = MiscUtils.toTicks(10.0f);
                this.matchState = MatchState.ENDMATCH_STATE;
                break;
            }
            case 3: {
                if (this.ticksLeft != 0) break;
                state = QuakeArenasParameters.getServerState(world.method_8503());
                this.arena = state.getRandomArena(this.arena.arenaName);
                this.reset(world);
                this.matchState = MatchState.WARMUP_STATE;
                this.highestFrags = 0;
                this.winner = "";
            }
        }
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
        }
    }

    private static enum MatchState {
        WARMUP_STATE,
        READY_STATE,
        IN_PROGRESS_STATE,
        ENDMATCH_STATE;

    }
}

