/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.registry.client;

import com.bytemaniak.mcquake3.blocks.render.PickupRenderer;
import com.bytemaniak.mcquake3.blocks.render.SpawnpointRenderer;
import com.bytemaniak.mcquake3.entity.ForwardJumppadRenderer;
import com.bytemaniak.mcquake3.entity.JumppadRenderer;
import com.bytemaniak.mcquake3.entity.PortalRenderer;
import com.bytemaniak.mcquake3.entity.projectile.render.BFG10KProjectileRenderer;
import com.bytemaniak.mcquake3.entity.projectile.render.GrenadeRenderer;
import com.bytemaniak.mcquake3.entity.projectile.render.PlasmaBallRenderer;
import com.bytemaniak.mcquake3.entity.projectile.render.RocketRenderer;
import com.bytemaniak.mcquake3.entity.projectile.render.ShellRenderer;
import com.bytemaniak.mcquake3.gui.FeedbackManager;
import com.bytemaniak.mcquake3.gui.MCQuake3GuiRenderer;
import com.bytemaniak.mcquake3.particle.PlasmaSparkParticleFactory;
import com.bytemaniak.mcquake3.particle.RocketTrailParticleFactory;
import com.bytemaniak.mcquake3.registry.Blocks;
import com.bytemaniak.mcquake3.registry.Entities;
import com.bytemaniak.mcquake3.registry.Particles;
import com.bytemaniak.mcquake3.render.QuadDamageGlintRenderer;
import com.bytemaniak.mcquake3.render.TrailRenderer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1007;
import net.minecraft.class_1921;
import net.minecraft.class_2396;
import net.minecraft.class_5616;
import net.minecraft.class_5786;

public class Renderers {
    public static final MCQuake3GuiRenderer hudRenderer = new MCQuake3GuiRenderer();
    public static final FeedbackManager feedbacks = new FeedbackManager();
    public static final TrailRenderer trailRenderer = new TrailRenderer();

    private static void registerEntityRenderers() {
        EntityRendererRegistry.register(Entities.PLASMA_BALL, PlasmaBallRenderer::new);
        EntityRendererRegistry.register(Entities.SHELL, ShellRenderer::new);
        EntityRendererRegistry.register(Entities.GRENADE, GrenadeRenderer::new);
        EntityRendererRegistry.register(Entities.ROCKET, RocketRenderer::new);
        EntityRendererRegistry.register(Entities.BFG10K_PROJECTILE, BFG10KProjectileRenderer::new);
        EntityRendererRegistry.register(Blocks.JUMPPAD_ENTITY, JumppadRenderer::new);
        EntityRendererRegistry.register(Blocks.FORWARD_JUMPPAD_ENTITY, ForwardJumppadRenderer::new);
        EntityRendererRegistry.register(Blocks.PORTAL_ENTITY, PortalRenderer::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.PLASMA_SPARK, PlasmaSparkParticleFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.ROCKET_TRAIL, RocketTrailParticleFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.BFG_PLASMA, class_5786.class_5957::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.PLASMA, class_5786.class_5957::new);
    }

    private static void registerBlockRenderers() {
        class_5616.method_32144(Blocks.SPAWNPOINT_BLOCK_ENTITY, context -> new SpawnpointRenderer());
        class_5616.method_32144(Blocks.MACHINEGUN_AMMO_BOX_ENTITY, context -> new PickupRenderer(Blocks.MACHINEGUN_AMMO_BOX));
        class_5616.method_32144(Blocks.SHOTGUN_AMMO_BOX_ENTITY, context -> new PickupRenderer(Blocks.SHOTGUN_AMMO_BOX));
        class_5616.method_32144(Blocks.GRENADE_AMMO_BOX_ENTITY, context -> new PickupRenderer(Blocks.GRENADE_AMMO_BOX));
        class_5616.method_32144(Blocks.ROCKET_AMMO_BOX_ENTITY, context -> new PickupRenderer(Blocks.ROCKET_AMMO_BOX));
        class_5616.method_32144(Blocks.LIGHTNING_AMMO_BOX_ENTITY, context -> new PickupRenderer(Blocks.LIGHTNING_AMMO_BOX));
        class_5616.method_32144(Blocks.RAILGUN_AMMO_BOX_ENTITY, context -> new PickupRenderer(Blocks.RAILGUN_AMMO_BOX));
        class_5616.method_32144(Blocks.PLASMAGUN_AMMO_BOX_ENTITY, context -> new PickupRenderer(Blocks.PLASMAGUN_AMMO_BOX));
        class_5616.method_32144(Blocks.BFG_AMMO_BOX_ENTITY, context -> new PickupRenderer(Blocks.BFG_AMMO_BOX));
        class_5616.method_32144(Blocks.HASTE_ENTITY, context -> new PickupRenderer(Blocks.HASTE));
        class_5616.method_32144(Blocks.INVISIBILITY_ENTITY, context -> new PickupRenderer(Blocks.INVISIBILITY));
        class_5616.method_32144(Blocks.QUAD_DAMAGE_ENTITY, context -> new PickupRenderer(Blocks.QUAD_DAMAGE));
        class_5616.method_32144(Blocks.HEALTH5_ENTITY, context -> new PickupRenderer(Blocks.HEALTH5));
        class_5616.method_32144(Blocks.HEALTH25_ENTITY, context -> new PickupRenderer(Blocks.HEALTH25));
        class_5616.method_32144(Blocks.HEALTH50_ENTITY, context -> new PickupRenderer(Blocks.HEALTH50));
        class_5616.method_32144(Blocks.MEGAHEALTH_ENTITY, context -> new PickupRenderer(Blocks.MEGAHEALTH));
        class_5616.method_32144(Blocks.SHIELD_CELL_ENTITY, context -> new PickupRenderer(Blocks.SHIELD_CELL));
        class_5616.method_32144(Blocks.LIGHT_ENERGY_SHIELD_ENTITY, context -> new PickupRenderer(Blocks.LIGHT_ENERGY_SHIELD));
        class_5616.method_32144(Blocks.HEAVY_ENERGY_SHIELD_ENTITY, context -> new PickupRenderer(Blocks.HEAVY_ENERGY_SHIELD));
        class_5616.method_32144(Blocks.SHOTGUN_ENTITY, context -> new PickupRenderer(Blocks.SHOTGUN));
        class_5616.method_32144(Blocks.GRENADE_ENTITY, context -> new PickupRenderer(Blocks.GRENADE));
        class_5616.method_32144(Blocks.ROCKET_ENTITY, context -> new PickupRenderer(Blocks.ROCKET));
        class_5616.method_32144(Blocks.LIGHTNING_ENTITY, context -> new PickupRenderer(Blocks.LIGHTNING));
        class_5616.method_32144(Blocks.RAILGUN_ENTITY, context -> new PickupRenderer(Blocks.RAILGUN));
        class_5616.method_32144(Blocks.PLASMAGUN_ENTITY, context -> new PickupRenderer(Blocks.PLASMAGUN));
        class_5616.method_32144(Blocks.BFG_ENTITY, context -> new PickupRenderer(Blocks.BFG));
        BlockRenderLayerMap.INSTANCE.putBlock(Blocks.HEALTH5_BLOCK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(Blocks.HEALTH25_BLOCK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(Blocks.HEALTH50_BLOCK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(Blocks.MEGAHEALTH_BLOCK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(Blocks.SHIELD_CELL_BLOCK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(Blocks.INVISIBILITY_BLOCK, class_1921.method_23583());
    }

    private static void registerFeatureRenderers() {
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityRenderer instanceof class_1007) {
                class_1007 playerEntityRenderer = (class_1007)entityRenderer;
                registrationHelper.register(new QuadDamageGlintRenderer(playerEntityRenderer, context.method_32170()));
            }
        });
    }

    public static void registerRenderers() {
        Renderers.registerEntityRenderers();
        Renderers.registerBlockRenderers();
        Renderers.registerFeatureRenderers();
        HudRenderCallback.EVENT.register((Object)hudRenderer);
        HudRenderCallback.EVENT.register((Object)feedbacks);
        WorldRenderEvents.END.register((Object)trailRenderer);
    }
}

