/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.render;

import com.bytemaniak.mcquake3.registry.Weapons;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_9799;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class TrailRenderer
implements WorldRenderEvents.End {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/misc/white.png");
    private static final class_1921 LAYER = class_1921.method_42600((class_2960)TEXTURE);
    private static final class_4597.class_4598 vertexConsumerProvider = class_4597.method_22991((class_9799)new class_9799(64));
    private static final long RAILGUN_TRAIL_LIFETIME = 20L;
    private static final long LIGHTNING_GUN_TRAIL_LIFETIME = 3L;
    private static final class_243 RAILGUN_TRAIL_COLOR = new class_243((double)0.35f, 1.0, 0.0);
    private static final class_243 LIGHTNING_GUN_TRAIL_COLOR = new class_243(0.5, 0.85, 1.0);
    private final CopyOnWriteArrayList<TrailData> trailList = new CopyOnWriteArrayList();

    private void genVertex(class_4588 vertexConsumer, Matrix4f positionMatrix, class_243 camera, class_243 vec, class_243 col, float alpha) {
        float x = (float)(vec.field_1352 - camera.field_1352);
        float y = (float)(vec.field_1351 - camera.field_1351);
        float z = (float)(vec.field_1350 - camera.field_1350);
        vertexConsumer.method_22918(positionMatrix, x, y, z).method_22915((float)col.field_1352, (float)col.field_1351, (float)col.field_1350, 1.0f - alpha).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(1).method_22914(0.0f, 1.0f, 0.0f);
    }

    private void genQuad(class_4588 vertexConsumer, Matrix4f positionMatrix, class_243 camera, class_243 v1, class_243 v2, class_243 v3, class_243 v4, class_243 color, float alpha) {
        this.genVertex(vertexConsumer, positionMatrix, camera, v1, color, alpha);
        this.genVertex(vertexConsumer, positionMatrix, camera, v2, color, alpha);
        this.genVertex(vertexConsumer, positionMatrix, camera, v3, color, alpha);
        this.genVertex(vertexConsumer, positionMatrix, camera, v4, color, alpha);
    }

    public void onEnd(WorldRenderContext context) {
        long worldTime = context.world().method_8510();
        this.trailList.removeIf(trail -> worldTime - trail.startTick > trail.lifetime);
        if (this.trailList.isEmpty()) {
            return;
        }
        Matrix4f positionMatrix = context.positionMatrix();
        class_243 cameraPos = context.camera().method_19326();
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(LAYER);
        for (TrailData trail2 : this.trailList) {
            long currentTick = worldTime - trail2.startTick;
            float alpha = (float)currentTick / (float)trail2.lifetime;
            trail2.v1 = trail2.v1.method_35590(trail2._v1, (double)alpha);
            trail2.v2 = trail2.v2.method_35590(trail2._v2, (double)alpha);
            trail2.v3 = trail2.v3.method_35590(trail2._v3, (double)alpha);
            trail2.v4 = trail2.v4.method_35590(trail2._v4, (double)alpha);
            trail2.v5 = trail2.v5.method_35590(trail2._v5, (double)alpha);
            trail2.v6 = trail2.v6.method_35590(trail2._v6, (double)alpha);
            trail2.v7 = trail2.v7.method_35590(trail2._v7, (double)alpha);
            trail2.v8 = trail2.v8.method_35590(trail2._v8, (double)alpha);
            this.genQuad(vertexConsumer, positionMatrix, cameraPos, trail2.v1, trail2.v2, trail2.v3, trail2.v4, trail2.color, alpha);
            this.genQuad(vertexConsumer, positionMatrix, cameraPos, trail2.v5, trail2.v6, trail2.v7, trail2.v8, trail2.color, alpha);
            this.genQuad(vertexConsumer, positionMatrix, cameraPos, trail2.v1, trail2.v2, trail2.v6, trail2.v5, trail2.color, alpha);
            this.genQuad(vertexConsumer, positionMatrix, cameraPos, trail2.v2, trail2.v3, trail2.v7, trail2.v6, trail2.color, alpha);
            this.genQuad(vertexConsumer, positionMatrix, cameraPos, trail2.v3, trail2.v4, trail2.v8, trail2.v7, trail2.color, alpha);
            this.genQuad(vertexConsumer, positionMatrix, cameraPos, trail2.v4, trail2.v1, trail2.v5, trail2.v8, trail2.color, alpha);
        }
        vertexConsumerProvider.method_22993();
    }

    public void addTrail(class_243 v1, class_243 v2, class_243 upVec, UUID playerId, int type) {
        if (type == Weapons.RAILGUN.slot) {
            this.addRailgunTrail(v1, v2, upVec);
        } else {
            this.addLightningGunTrail(v1, v2, upVec, playerId);
        }
    }

    private void addRailgunTrail(class_243 v1, class_243 v2, class_243 upVec) {
        this.trailList.add(new TrailData(v1, v2, upVec, class_310.method_1551().field_1687.method_8510(), 20L, RAILGUN_TRAIL_COLOR, UUID.fromString("00000000-0000-0000-0000-000000000000")));
    }

    private void addLightningGunTrail(class_243 v1, class_243 v2, class_243 upVec, UUID playerId) {
        Optional<TrailData> trail = this.trailList.stream().filter(t -> t.owner.equals(playerId)).findFirst();
        if (trail.isEmpty()) {
            this.trailList.add(new TrailData(v1, v2, upVec, class_310.method_1551().field_1687.method_8510(), 3L, LIGHTNING_GUN_TRAIL_COLOR, playerId));
        } else {
            TrailData trailData = trail.get();
            TrailData.updateTrailData(trailData, v1, v2, upVec, class_310.method_1551().field_1687.method_8510());
        }
    }

    private static class TrailData {
        public class_243 v1;
        public class_243 v2;
        public class_243 v3;
        public class_243 v4;
        public class_243 v5;
        public class_243 v6;
        public class_243 v7;
        public class_243 v8;
        public class_243 _v1;
        public class_243 _v2;
        public class_243 _v3;
        public class_243 _v4;
        public class_243 _v5;
        public class_243 _v6;
        public class_243 _v7;
        public class_243 _v8;
        public long startTick;
        public final long lifetime;
        public final class_243 color;
        public final UUID owner;

        public static void updateTrailData(TrailData trailData, class_243 v1, class_243 v2, class_243 upVec, long startTick) {
            upVec = upVec.method_1021((double)0.075f);
            class_243 diffVec = v2.method_1020(v1);
            class_243 dirVec = diffVec.method_1029();
            class_243 leftVec = dirVec.method_1036(upVec);
            trailData._v1 = v1.method_1019(leftVec).method_1019(upVec);
            trailData._v2 = v1.method_1019(leftVec).method_1019(upVec.method_22882());
            trailData._v3 = v1.method_1019(leftVec.method_22882()).method_1019(upVec.method_22882());
            trailData._v4 = v1.method_1019(leftVec.method_22882()).method_1019(upVec);
            trailData._v5 = trailData._v1.method_1019(diffVec);
            trailData._v6 = trailData._v2.method_1019(diffVec);
            trailData._v7 = trailData._v3.method_1019(diffVec);
            trailData._v8 = trailData._v4.method_1019(diffVec);
            trailData.startTick = startTick;
        }

        public TrailData(class_243 v1, class_243 v2, class_243 upVec, long startTick, long lifetime, class_243 color, UUID owner) {
            TrailData.updateTrailData(this, v1, v2, upVec, startTick);
            this.v1 = this._v1;
            this.v2 = this._v2;
            this.v3 = this._v3;
            this.v4 = this._v4;
            this.v5 = this._v5;
            this.v6 = this._v6;
            this.v7 = this._v7;
            this.v8 = this._v8;
            this.lifetime = lifetime;
            this.color = color;
            this.owner = owner;
        }
    }
}

