/*
 * Decompiled with CFR 0.152.
 */
package winlyps.everythingIsTotem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0019"}, d2={"Lwinlyps/everythingIsTotem/EverythingIsTotem;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onEnable", "", "onDisable", "onEntityResurrect", "event", "Lorg/bukkit/event/entity/EntityResurrectEvent;", "onEntityDamage", "Lorg/bukkit/event/entity/EntityDamageEvent;", "hasTotemInHands", "", "player", "Lorg/bukkit/entity/Player;", "findTotemReplacement", "Lorg/bukkit/inventory/ItemStack;", "isWeaponToolOrArmor", "material", "Lorg/bukkit/Material;", "consumeItem", "item", "applyTotemEffects", "EverythingIsTotem"})
public final class EverythingIsTotem
extends JavaPlugin
implements Listener {
    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("EverythingIsTotem has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("EverythingIsTotem has been disabled!");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onEntityResurrect(@NotNull EntityResurrectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)livingEntity;
        if (event.isCancelled()) {
            return;
        }
        if (this.hasTotemInHands(player)) {
            return;
        }
        ItemStack totemItem = this.findTotemReplacement(player);
        if (totemItem != null) {
            event.setCancelled(false);
            this.consumeItem(player, totemItem);
            this.applyTotemEffects(player);
            this.getServer().getScheduler().runTask((Plugin)this, () -> EverythingIsTotem.onEntityResurrect$lambda$0(player));
            this.getLogger().info("Player " + player.getName() + " was saved by " + totemItem.getType().name());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onEntityDamage(@NotNull EntityDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)entity;
        if (player.getHealth() - event.getFinalDamage() > 0.0) {
            return;
        }
        if (this.hasTotemInHands(player)) {
            return;
        }
        ItemStack totemItem = this.findTotemReplacement(player);
        if (totemItem != null) {
            event.setCancelled(true);
            this.consumeItem(player, totemItem);
            this.applyTotemEffects(player);
            player.setHealth(2.0);
            this.getLogger().info("Player " + player.getName() + " was saved by " + totemItem.getType().name());
        }
    }

    private final boolean hasTotemInHands(Player player) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        ItemStack mainHand = itemStack;
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemInOffHand(...)");
        ItemStack offHand = itemStack2;
        return mainHand.getType() == Material.TOTEM_OF_UNDYING || offHand.getType() == Material.TOTEM_OF_UNDYING;
    }

    private final ItemStack findTotemReplacement(Player player) {
        PlayerInventory playerInventory = player.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)playerInventory, (String)"getInventory(...)");
        PlayerInventory inventory = playerInventory;
        List eligibleItems = new ArrayList();
        int n = inventory.getSize();
        for (int i = 0; i < n; ++i) {
            ItemStack item;
            if (inventory.getItem(i) == null || item.getType() == Material.AIR || item.getType() == Material.TOTEM_OF_UNDYING) continue;
            Material material = item.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            if (this.isWeaponToolOrArmor(material)) continue;
            eligibleItems.add(item);
        }
        return !((Collection)eligibleItems).isEmpty() ? (ItemStack)CollectionsKt.random((Collection)eligibleItems, (Random)((Random)Random.Default)) : null;
    }

    private final boolean isWeaponToolOrArmor(Material material) {
        String name = material.name();
        if (StringsKt.endsWith$default((String)name, (String)"_SWORD", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_AXE", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_BOW", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"TRIDENT", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"CROSSBOW", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.endsWith$default((String)name, (String)"_PICKAXE", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_SHOVEL", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_HOE", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_SHEARS", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"FISHING_ROD", (boolean)false, (int)2, null)) {
            return true;
        }
        return StringsKt.endsWith$default((String)name, (String)"_HELMET", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_CHESTPLATE", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_LEGGINGS", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_BOOTS", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"SHIELD", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"ELYTRA", (boolean)false, (int)2, null);
    }

    private final void consumeItem(Player player, ItemStack item) {
        PlayerInventory playerInventory = player.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)playerInventory, (String)"getInventory(...)");
        PlayerInventory inventory = playerInventory;
        int n = inventory.getSize();
        for (int i = 0; i < n; ++i) {
            ItemStack slotItem;
            if (inventory.getItem(i) == null || slotItem.getType() != item.getType()) continue;
            inventory.setItem(i, null);
        }
    }

    private final void applyTotemEffects(Player player) {
        player.playEffect(EntityEffect.TOTEM_RESURRECT);
    }

    private static final void onEntityResurrect$lambda$0(Player $player) {
        $player.setHealth(2.0);
    }
}

