/*
 * Decompiled with CFR 0.152.
 */
package net.marshlaw.complicatedbundles.init;

import java.util.Map;
import net.marshlaw.complicatedbundles.init.ComplicatedBundlesModScreens;
import net.marshlaw.complicatedbundles.network.MenuStateUpdateMessage;
import net.marshlaw.complicatedbundles.world.inventory.BackpackGUIMenu;
import net.marshlaw.complicatedbundles.world.inventory.DiamondBackpackGUIMenu;
import net.marshlaw.complicatedbundles.world.inventory.EmeraldBackpackGUIMenu;
import net.marshlaw.complicatedbundles.world.inventory.GoldBackpackGUIMenu;
import net.marshlaw.complicatedbundles.world.inventory.IronBackpackGUIMenu;
import net.marshlaw.complicatedbundles.world.inventory.NetheriteBackpackGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ComplicatedBundlesModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"complicated_bundles");
    public static final DeferredHolder<MenuType<?>, MenuType<BackpackGUIMenu>> BACKPACK_GUI = REGISTRY.register("backpack_gui", () -> IMenuTypeExtension.create(BackpackGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<IronBackpackGUIMenu>> IRON_BACKPACK_GUI = REGISTRY.register("iron_backpack_gui", () -> IMenuTypeExtension.create(IronBackpackGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<GoldBackpackGUIMenu>> GOLD_BACKPACK_GUI = REGISTRY.register("gold_backpack_gui", () -> IMenuTypeExtension.create(GoldBackpackGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<EmeraldBackpackGUIMenu>> EMERALD_BACKPACK_GUI = REGISTRY.register("emerald_backpack_gui", () -> IMenuTypeExtension.create(EmeraldBackpackGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<DiamondBackpackGUIMenu>> DIAMOND_BACKPACK_GUI = REGISTRY.register("diamond_backpack_gui", () -> IMenuTypeExtension.create(DiamondBackpackGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<NetheriteBackpackGUIMenu>> NETHERITE_BACKPACK_GUI = REGISTRY.register("netherite_backpack_gui", () -> IMenuTypeExtension.create(NetheriteBackpackGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (player.level().isClientSide) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof ComplicatedBundlesModScreens.ScreenAccessor) {
                    ComplicatedBundlesModScreens.ScreenAccessor accessor = (ComplicatedBundlesModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

