/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.biome.BiomeClimate;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.BiomeType;
import org.terraform.biome.beach.BadlandsBeachHandler;
import org.terraform.biome.beach.BlackOceanBeachHandler;
import org.terraform.biome.beach.BogBeachHandler;
import org.terraform.biome.beach.CherryGroveBeachHandler;
import org.terraform.biome.beach.DarkForestBeachHandler;
import org.terraform.biome.beach.IcyBeachHandler;
import org.terraform.biome.beach.MudflatsHandler;
import org.terraform.biome.beach.MushroomBeachHandler;
import org.terraform.biome.beach.RockBeachHandler;
import org.terraform.biome.beach.SandyBeachHandler;
import org.terraform.biome.beach.ScarletForestBeachHandler;
import org.terraform.biome.cavepopulators.AbstractCavePopulator;
import org.terraform.biome.cavepopulators.ForestedMountainsCavePopulator;
import org.terraform.biome.cavepopulators.FrozenCavePopulator;
import org.terraform.biome.cavepopulators.MossyCavePopulator;
import org.terraform.biome.flat.ArchedCliffsHandler;
import org.terraform.biome.flat.BadlandsHandler;
import org.terraform.biome.flat.BambooForestHandler;
import org.terraform.biome.flat.CherryGroveHandler;
import org.terraform.biome.flat.DarkForestHandler;
import org.terraform.biome.flat.DesertHandler;
import org.terraform.biome.flat.ElevatedPlainsHandler;
import org.terraform.biome.flat.ErodedPlainsHandler;
import org.terraform.biome.flat.FlowerForestHandler;
import org.terraform.biome.flat.ForestHandler;
import org.terraform.biome.flat.GorgeHandler;
import org.terraform.biome.flat.IceSpikesHandler;
import org.terraform.biome.flat.JungleHandler;
import org.terraform.biome.flat.MangroveHandler;
import org.terraform.biome.flat.MeadowHandler;
import org.terraform.biome.flat.MuddyBogHandler;
import org.terraform.biome.flat.PaleForestHandler;
import org.terraform.biome.flat.PetrifiedCliffsHandler;
import org.terraform.biome.flat.PlainsHandler;
import org.terraform.biome.flat.SavannaHandler;
import org.terraform.biome.flat.ScarletForestHandler;
import org.terraform.biome.flat.SnowyTaigaHandler;
import org.terraform.biome.flat.SnowyWastelandHandler;
import org.terraform.biome.flat.SparseJungleHandler;
import org.terraform.biome.flat.SwampHandler;
import org.terraform.biome.flat.TaigaHandler;
import org.terraform.biome.mountainous.BadlandsCanyonHandler;
import org.terraform.biome.mountainous.BirchMountainsHandler;
import org.terraform.biome.mountainous.DesertHillsHandler;
import org.terraform.biome.mountainous.ForestedMountainsHandler;
import org.terraform.biome.mountainous.JaggedPeaksHandler;
import org.terraform.biome.mountainous.PaintedHillsHandler;
import org.terraform.biome.mountainous.RockyMountainsHandler;
import org.terraform.biome.mountainous.ShatteredSavannaHandler;
import org.terraform.biome.mountainous.SnowyMountainsHandler;
import org.terraform.biome.ocean.BlackOceansHandler;
import org.terraform.biome.ocean.ColdOceansHandler;
import org.terraform.biome.ocean.CoralReefOceanHandler;
import org.terraform.biome.ocean.FrozenOceansHandler;
import org.terraform.biome.ocean.LukewarmOceansHandler;
import org.terraform.biome.ocean.MushroomIslandHandler;
import org.terraform.biome.ocean.OceansHandler;
import org.terraform.biome.ocean.WarmOceansHandler;
import org.terraform.biome.river.BadlandsRiverHandler;
import org.terraform.biome.river.BogRiverHandler;
import org.terraform.biome.river.CherryGroveRiverHandler;
import org.terraform.biome.river.DarkForestRiverHandler;
import org.terraform.biome.river.DesertRiverHandler;
import org.terraform.biome.river.FrozenRiverHandler;
import org.terraform.biome.river.JungleRiverHandler;
import org.terraform.biome.river.RiverHandler;
import org.terraform.biome.river.ScarletForestRiverHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.CoordPair;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.utils.datastructs.ConcurrentLRUCache;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.Version;

public enum BiomeBank {
    SNOWY_MOUNTAINS(new SnowyMountainsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.SNOWY, TConfig.c.BIOME_SNOWY_MOUNTAINS_WEIGHT, new FrozenCavePopulator()),
    BIRCH_MOUNTAINS((BiomeHandler)new BirchMountainsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.COLD, TConfig.c.BIOME_BIRCH_MOUNTAINS_WEIGHT),
    ROCKY_MOUNTAINS((BiomeHandler)new RockyMountainsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.TRANSITION, TConfig.c.BIOME_ROCKY_MOUNTAINS_WEIGHT),
    FORESTED_MOUNTAINS(new ForestedMountainsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_FORESTED_MOUNTAINS_WEIGHT, new ForestedMountainsCavePopulator()),
    SHATTERED_SAVANNA((BiomeHandler)new ShatteredSavannaHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.DRY_VEGETATION, TConfig.c.BIOME_SHATTERED_SAVANNA_WEIGHT),
    PAINTED_HILLS((BiomeHandler)new PaintedHillsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.DRY_VEGETATION, TConfig.c.BIOME_PAINTED_HILLS_WEIGHT),
    BADLANDS_CANYON((BiomeHandler)new BadlandsCanyonHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.HOT_BARREN, TConfig.c.BIOME_BADLANDS_MOUNTAINS_WEIGHT),
    DESERT_MOUNTAINS((BiomeHandler)new DesertHillsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.HOT_BARREN, TConfig.c.BIOME_DESERT_MOUNTAINS_WEIGHT),
    JAGGED_PEAKS(new JaggedPeaksHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.SNOWY, TConfig.c.BIOME_JAGGED_PEAKS_WEIGHT, new FrozenCavePopulator()),
    COLD_JAGGED_PEAKS(new JaggedPeaksHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.COLD, TConfig.c.BIOME_JAGGED_PEAKS_WEIGHT, new FrozenCavePopulator()),
    TRANSITION_JAGGED_PEAKS(new JaggedPeaksHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.TRANSITION, TConfig.c.BIOME_JAGGED_PEAKS_WEIGHT, new FrozenCavePopulator()),
    FORESTED_PEAKS(new ForestedMountainsHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_FORESTED_MOUNTAINS_WEIGHT, new ForestedMountainsCavePopulator()),
    SHATTERED_SAVANNA_PEAK((BiomeHandler)new ShatteredSavannaHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.DRY_VEGETATION, TConfig.c.BIOME_SHATTERED_SAVANNA_WEIGHT),
    BADLANDS_CANYON_PEAK((BiomeHandler)new BadlandsCanyonHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.HOT_BARREN, TConfig.c.BIOME_BADLANDS_MOUNTAINS_WEIGHT),
    OCEAN((BiomeHandler)new OceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.TRANSITION, TConfig.c.BIOME_OCEAN_WEIGHT),
    BLACK_OCEAN((BiomeHandler)new BlackOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.TRANSITION, TConfig.c.BIOME_BLACK_OCEAN_WEIGHT),
    COLD_OCEAN((BiomeHandler)new ColdOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.COLD, TConfig.c.BIOME_COLD_OCEAN_WEIGHT),
    FROZEN_OCEAN(new FrozenOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.SNOWY, TConfig.c.BIOME_FROZEN_OCEAN_WEIGHT, new FrozenCavePopulator()),
    WARM_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.HOT_BARREN, TConfig.c.BIOME_WARM_OCEAN_WEIGHT),
    HUMID_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_HUMID_OCEAN_WEIGHT),
    DRY_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.DRY_VEGETATION, TConfig.c.BIOME_DRY_OCEAN_WEIGHT),
    CORAL_REEF_OCEAN((BiomeHandler)new CoralReefOceanHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_CORALREEF_OCEAN_WEIGHT),
    RIVER(new RiverHandler(), BiomeType.RIVER, BiomeClimate.TRANSITION),
    BOG_RIVER(new BogRiverHandler(), BiomeType.RIVER, BiomeClimate.DRY_VEGETATION),
    CHERRY_GROVE_RIVER(new CherryGroveRiverHandler(), BiomeType.RIVER, BiomeClimate.COLD),
    SCARLET_FOREST_RIVER(new ScarletForestRiverHandler(), BiomeType.RIVER, BiomeClimate.COLD),
    JUNGLE_RIVER(new JungleRiverHandler(), BiomeType.RIVER, BiomeClimate.HUMID_VEGETATION),
    FROZEN_RIVER((BiomeHandler)new FrozenRiverHandler(), BiomeType.RIVER, BiomeClimate.SNOWY, new FrozenCavePopulator()),
    DARK_FOREST_RIVER((BiomeHandler)new DarkForestRiverHandler(), BiomeType.RIVER, BiomeClimate.HUMID_VEGETATION, new FrozenCavePopulator()),
    DESERT_RIVER(new DesertRiverHandler(), BiomeType.RIVER, BiomeClimate.HOT_BARREN),
    BADLANDS_RIVER(new BadlandsRiverHandler(), BiomeType.RIVER, BiomeClimate.HOT_BARREN),
    DEEP_OCEAN((BiomeHandler)new OceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.TRANSITION, TConfig.c.BIOME_DEEP_OCEAN_WEIGHT),
    DEEP_COLD_OCEAN((BiomeHandler)new ColdOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.COLD, TConfig.c.BIOME_DEEP_COLD_OCEAN_WEIGHT),
    DEEP_BLACK_OCEAN((BiomeHandler)new BlackOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.TRANSITION, TConfig.c.BIOME_DEEP_BLACK_OCEAN_WEIGHT),
    DEEP_FROZEN_OCEAN(new FrozenOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.SNOWY, TConfig.c.BIOME_DEEP_FROZEN_OCEAN_WEIGHT, new FrozenCavePopulator()),
    DEEP_WARM_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.HOT_BARREN, TConfig.c.BIOME_DEEP_WARM_OCEAN_WEIGHT),
    DEEP_HUMID_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_DEEP_HUMID_OCEAN_WEIGHT),
    DEEP_DRY_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.DRY_VEGETATION, TConfig.c.BIOME_DEEP_DRY_OCEAN_WEIGHT),
    DEEP_LUKEWARM_OCEAN((BiomeHandler)new LukewarmOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_DEEP_LUKEWARM_OCEAN_WEIGHT),
    MUSHROOM_ISLANDS((BiomeHandler)new MushroomIslandHandler(), BiomeType.DEEP_OCEANIC, BiomeClimate.TRANSITION, TConfig.c.BIOME_MUSHROOM_ISLAND_WEIGHT),
    PLAINS((BiomeHandler)new PlainsHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfig.c.BIOME_PLAINS_WEIGHT),
    MEADOW((BiomeHandler)new MeadowHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfig.c.BIOME_MEADOW_WEIGHT),
    ELEVATED_PLAINS((BiomeHandler)new ElevatedPlainsHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfig.c.BIOME_ELEVATED_PLAINS_WEIGHT),
    GORGE((BiomeHandler)new GorgeHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfig.c.BIOME_GORGE_WEIGHT),
    PETRIFIED_CLIFFS((BiomeHandler)new PetrifiedCliffsHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfig.c.BIOME_PETRIFIEDCLIFFS_WEIGHT),
    ARCHED_CLIFFS((BiomeHandler)new ArchedCliffsHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfig.c.BIOME_ARCHED_CLIFFS_WEIGHT),
    SAVANNA((BiomeHandler)new SavannaHandler(), BiomeType.FLAT, BiomeClimate.DRY_VEGETATION, TConfig.c.BIOME_SAVANNA_WEIGHT),
    MUDDY_BOG((BiomeHandler)new MuddyBogHandler(), BiomeType.FLAT, BiomeClimate.DRY_VEGETATION, TConfig.c.BIOME_MUDDYBOG_WEIGHT),
    FOREST((BiomeHandler)new ForestHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_FOREST_WEIGHT),
    FLOWER_FOREST((BiomeHandler)new FlowerForestHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_FLOWERFOREST_WEIGHT),
    JUNGLE((BiomeHandler)new JungleHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_JUNGLE_WEIGHT),
    SPARSE_JUNGLE((BiomeHandler)new SparseJungleHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_SPARSE_JUNGLE_WEIGHT),
    BAMBOO_FOREST((BiomeHandler)new BambooForestHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_BAMBOO_FOREST_WEIGHT),
    DESERT((BiomeHandler)new DesertHandler(), BiomeType.FLAT, BiomeClimate.HOT_BARREN, TConfig.c.BIOME_DESERT_WEIGHT),
    BADLANDS((BiomeHandler)new BadlandsHandler(), BiomeType.FLAT, BiomeClimate.HOT_BARREN, TConfig.c.BIOME_BADLANDS_WEIGHT),
    ERODED_PLAINS((BiomeHandler)new ErodedPlainsHandler(), BiomeType.FLAT, BiomeClimate.COLD, TConfig.c.BIOME_ERODED_PLAINS_WEIGHT),
    SCARLET_FOREST((BiomeHandler)new ScarletForestHandler(), BiomeType.FLAT, BiomeClimate.COLD, TConfig.c.BIOME_SCARLETFOREST_WEIGHT),
    CHERRY_GROVE((BiomeHandler)new CherryGroveHandler(), BiomeType.FLAT, BiomeClimate.COLD, TConfig.c.BIOME_CHERRYGROVE_WEIGHT),
    TAIGA((BiomeHandler)new TaigaHandler(), BiomeType.FLAT, BiomeClimate.COLD, TConfig.c.BIOME_TAIGA_WEIGHT),
    SNOWY_TAIGA(new SnowyTaigaHandler(), BiomeType.FLAT, BiomeClimate.SNOWY, TConfig.c.BIOME_SNOWY_TAIGA_WEIGHT, new FrozenCavePopulator()),
    SNOWY_WASTELAND(new SnowyWastelandHandler(), BiomeType.FLAT, BiomeClimate.SNOWY, TConfig.c.BIOME_SNOWY_WASTELAND_WEIGHT, new FrozenCavePopulator()),
    ICE_SPIKES(new IceSpikesHandler(), BiomeType.FLAT, BiomeClimate.SNOWY, TConfig.c.BIOME_ICE_SPIKES_WEIGHT, new FrozenCavePopulator()),
    DARK_FOREST((BiomeHandler)new DarkForestHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_DARK_FOREST_WEIGHT),
    PALE_FOREST((BiomeHandler)new PaleForestHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, Version.isAtLeast(21.4) ? TConfig.c.BIOME_PALE_FOREST_WEIGHT : 0),
    SWAMP((BiomeHandler)new SwampHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_SWAMP_WEIGHT),
    MANGROVE((BiomeHandler)new MangroveHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfig.c.BIOME_MANGROVE_WEIGHT),
    SANDY_BEACH(new SandyBeachHandler(), BiomeType.BEACH, BiomeClimate.TRANSITION),
    BOG_BEACH(new BogBeachHandler(), BiomeType.BEACH, BiomeClimate.DRY_VEGETATION),
    DARK_FOREST_BEACH(new DarkForestBeachHandler(), BiomeType.BEACH, BiomeClimate.HUMID_VEGETATION),
    BADLANDS_BEACH(new BadlandsBeachHandler(), BiomeType.BEACH, BiomeClimate.HOT_BARREN),
    MUSHROOM_BEACH(new MushroomBeachHandler(), BiomeType.BEACH, BiomeClimate.TRANSITION),
    BLACK_OCEAN_BEACH(new BlackOceanBeachHandler(), BiomeType.BEACH, BiomeClimate.COLD),
    ROCKY_BEACH(new RockBeachHandler(), BiomeType.BEACH, BiomeClimate.COLD),
    ICY_BEACH((BiomeHandler)new IcyBeachHandler(), BiomeType.BEACH, BiomeClimate.SNOWY, new FrozenCavePopulator()),
    MUDFLATS(new MudflatsHandler(), BiomeType.BEACH, BiomeClimate.HUMID_VEGETATION),
    CHERRY_GROVE_BEACH(new CherryGroveBeachHandler(), BiomeType.BEACH, BiomeClimate.COLD),
    SCARLET_FOREST_BEACH(new ScarletForestBeachHandler(), BiomeType.BEACH, BiomeClimate.COLD);

    private static final ConcurrentLRUCache<BiomeSection, BiomeSection> BIOMESECTION_CACHE;
    public static boolean debugPrint;
    @Nullable
    public static BiomeBank singleLand;
    @Nullable
    public static BiomeBank singleOcean;
    @Nullable
    public static BiomeBank singleDeepOcean;
    @Nullable
    public static BiomeBank singleMountain;
    @Nullable
    public static BiomeBank singleHighMountain;
    private final BiomeHandler handler;
    private final BiomeType type;
    private final AbstractCavePopulator cavePop;
    private final BiomeClimate climate;
    private final int biomeWeight;

    private BiomeBank(BiomeHandler handler, BiomeType type, BiomeClimate climate) {
        this.handler = handler;
        this.type = type;
        this.climate = climate;
        this.biomeWeight = 0;
        this.cavePop = new MossyCavePopulator();
    }

    private BiomeBank(BiomeHandler handler, BiomeType type, BiomeClimate climate, AbstractCavePopulator cavePop) {
        this.handler = handler;
        this.type = type;
        this.climate = climate;
        this.biomeWeight = 0;
        this.cavePop = cavePop;
    }

    private BiomeBank(BiomeHandler handler, BiomeType type, BiomeClimate climate, int biomeWeight) {
        this.handler = handler;
        this.type = type;
        this.climate = climate;
        this.biomeWeight = biomeWeight;
        this.cavePop = new MossyCavePopulator();
    }

    private BiomeBank(BiomeHandler handler, BiomeType type, BiomeClimate climate, int biomeWeight, AbstractCavePopulator cavePop) {
        this.handler = handler;
        this.type = type;
        this.climate = climate;
        this.cavePop = cavePop;
        this.biomeWeight = biomeWeight;
    }

    @NotNull
    public static BiomeSection getBiomeSectionFromBlockCoords(TerraformWorld tw, int x, int z) {
        BiomeSection sect = new BiomeSection(tw, x, z);
        sect = BIOMESECTION_CACHE.get(sect);
        return sect;
    }

    @NotNull
    public static BiomeSection getBiomeSectionFromChunk(TerraformWorld tw, int chunkX, int chunkZ) {
        BiomeSection sect = new BiomeSection(tw, chunkX << 4, chunkZ << 4);
        sect = BIOMESECTION_CACHE.get(sect);
        return sect;
    }

    @NotNull
    public static BiomeSection getBiomeSectionFromSectionCoords(TerraformWorld tw, int x, int z, boolean useSectionCoords) {
        BiomeSection sect = new BiomeSection(tw, x, z, useSectionCoords);
        sect = BIOMESECTION_CACHE.get(sect);
        return sect;
    }

    @NotNull
    public static BiomeBank calculateBiome(@NotNull TerraformWorld tw, int rawX, int height, int rawZ) {
        if (debugPrint) {
            TerraformGeneratorPlugin.logger.info("calculateBiome called with args: " + tw.getName() + "," + rawX + "," + height + "," + rawZ);
        }
        BiomeBank bank = BiomeBank.calculateHeightIndependentBiome(tw, rawX, rawZ);
        FastNoise beachNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_BEACH_HEIGHT, world -> {
            FastNoise n = new FastNoise((int)world.getSeed());
            n.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
            n.SetFrequency(0.01f);
            n.SetFractalOctaves(4);
            return n;
        });
        if (height < TerraformGenerator.seaLevel && (double)height + HeightMap.getRawRiverDepth(tw, rawX, rawZ) >= (double)TerraformGenerator.seaLevel) {
            bank = bank.getHandler().getRiverType();
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> River Detected");
            }
        } else if (height >= TerraformGenerator.seaLevel && (float)height <= (float)TerraformGenerator.seaLevel + 8.0f * Math.abs(beachNoise.GetNoise(rawX, rawZ))) {
            bank = bank.getHandler().getBeachType();
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> Beach calculated");
            }
        }
        if (bank != SWAMP && bank != MANGROVE && height < TerraformGenerator.seaLevel && bank.isDry()) {
            bank = bank.getHandler().getRiverType();
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> Biome is submerged, defaulting to river");
            }
        }
        if (!bank.isDry() && height >= TerraformGenerator.seaLevel) {
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> Submerged biome above ground detected");
            }
            BiomeBank replacement = null;
            if (!bank.getHandler().forceDefaultToBeach()) {
                int highestDom = Integer.MIN_VALUE;
                for (BiomeSection sect : BiomeSection.getSurroundingSections(tw, rawX, rawZ)) {
                    if (debugPrint) {
                        TerraformGeneratorPlugin.logger.info("calculateBiome -> -> Comparison Section: " + sect.toString());
                    }
                    if (!sect.getBiomeBank().isDry()) continue;
                    int compDist = (int)sect.getDominanceBasedOnRadius(rawX, rawZ);
                    if (debugPrint) {
                        TerraformGeneratorPlugin.logger.info("calculateBiome -> -> -> Dominance: " + compDist);
                    }
                    if (compDist <= highestDom) continue;
                    replacement = sect.getBiomeBank();
                    highestDom = compDist;
                }
            }
            BiomeBank biomeBank = bank = replacement == null ? bank.getHandler().getBeachType() : replacement;
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> -> Submerged biome defaulted to: " + String.valueOf((Object)replacement));
            }
        }
        if (debugPrint) {
            TerraformGeneratorPlugin.logger.info("calculateBiome -> Evaluated: " + String.valueOf((Object)bank));
        }
        return bank;
    }

    @NotNull
    public static BiomeBank calculateHeightIndependentBiome(TerraformWorld tw, int x, int z) {
        BiomeSection mostDominant = BiomeSection.getMostDominantSection(tw, x, z);
        return mostDominant.getBiomeBank();
    }

    public static void initSinglesConfig() {
        try {
            singleLand = BiomeBank.valueOf(TConfig.c.BIOME_SINGLE_TERRESTRIAL_TYPE.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e2) {
            singleLand = null;
        }
        try {
            singleOcean = BiomeBank.valueOf(TConfig.c.BIOME_SINGLE_OCEAN_TYPE.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e3) {
            singleOcean = null;
        }
        try {
            singleDeepOcean = BiomeBank.valueOf(TConfig.c.BIOME_SINGLE_DEEPOCEAN_TYPE.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e4) {
            singleDeepOcean = null;
        }
        try {
            singleMountain = BiomeBank.valueOf(TConfig.c.BIOME_SINGLE_MOUNTAIN_TYPE.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e5) {
            singleMountain = null;
        }
        try {
            singleHighMountain = BiomeBank.valueOf(TConfig.c.BIOME_SINGLE_HIGHMOUNTAIN_TYPE.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e6) {
            singleHighMountain = null;
        }
    }

    public static boolean isBiomeEnabled(@NotNull BiomeBank bank) {
        if (bank.getBiomeWeight() <= 0) {
            return false;
        }
        return switch (bank.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case BiomeType.BEACH, BiomeType.RIVER -> true;
            case BiomeType.DEEP_OCEANIC -> {
                if (singleDeepOcean == null || singleDeepOcean == bank) {
                    yield true;
                }
                yield false;
            }
            case BiomeType.FLAT -> {
                if (singleLand == null || singleLand == bank) {
                    yield true;
                }
                yield false;
            }
            case BiomeType.HIGH_MOUNTAINOUS -> {
                if (singleHighMountain == null || singleHighMountain == bank) {
                    yield true;
                }
                yield false;
            }
            case BiomeType.MOUNTAINOUS -> {
                if (singleMountain == null || singleMountain == bank) {
                    yield true;
                }
                yield false;
            }
            case BiomeType.OCEANIC -> singleOcean == null || singleOcean == bank;
        };
    }

    @NotNull
    public static BiomeBank selectBiome(@NotNull BiomeSection section, double temperature, double moisture) {
        Random sectionRand = section.getSectionRandom();
        if (TConfig.c.BIOME_FORCE_RADIUS > 0) {
            CoordPair lowerZoneBound = new CoordPair(-TConfig.c.BIOME_FORCE_RADIUS >> BiomeSection.bitshifts, -TConfig.c.BIOME_FORCE_RADIUS >> BiomeSection.bitshifts);
            CoordPair upperZoneBound = new CoordPair(TConfig.c.BIOME_FORCE_RADIUS >> BiomeSection.bitshifts, TConfig.c.BIOME_FORCE_RADIUS >> BiomeSection.bitshifts);
            if (lowerZoneBound.x() <= section.getX() && section.getX() <= upperZoneBound.x() && lowerZoneBound.z() <= section.getZ() && section.getZ() <= upperZoneBound.z()) {
                return BiomeBank.valueOf(TConfig.c.BIOME_FORCED_BIOME);
            }
        }
        BiomeType targetType = BiomeType.FLAT;
        BiomeClimate climate = BiomeClimate.selectClimate(temperature, moisture);
        double oceanicNoise = section.getOceanLevel();
        if (oceanicNoise < 0.0 || TConfig.c.BIOME_OCEANIC_THRESHOLD < 0.0f) {
            if ((oceanicNoise = Math.abs(oceanicNoise)) >= (double)TConfig.c.BIOME_DEEP_OCEANIC_THRESHOLD) {
                targetType = BiomeType.DEEP_OCEANIC;
            } else if (oceanicNoise >= (double)TConfig.c.BIOME_OCEANIC_THRESHOLD) {
                targetType = BiomeType.OCEANIC;
            }
        } else {
            double mountainousNoise = section.getMountainLevel();
            if (mountainousNoise > 0.0) {
                if (mountainousNoise >= (double)TConfig.c.BIOME_HIGH_MOUNTAINOUS_THRESHOLD) {
                    targetType = BiomeType.HIGH_MOUNTAINOUS;
                } else if (mountainousNoise >= (double)TConfig.c.BIOME_MOUNTAINOUS_THRESHOLD) {
                    targetType = BiomeType.MOUNTAINOUS;
                }
            }
        }
        switch (targetType) {
            case FLAT: {
                if (singleLand == null) break;
                return singleLand;
            }
            case OCEANIC: {
                if (singleOcean == null) break;
                return singleOcean;
            }
            case DEEP_OCEANIC: {
                if (singleDeepOcean == null) break;
                return singleDeepOcean;
            }
            case MOUNTAINOUS: {
                if (singleMountain == null) break;
                return singleMountain;
            }
            case HIGH_MOUNTAINOUS: {
                if (singleHighMountain == null) break;
                return singleHighMountain;
            }
        }
        ArrayList<BiomeBank> contenders = new ArrayList<BiomeBank>();
        for (BiomeBank biome : BiomeBank.values()) {
            if (biome.biomeWeight <= 0 || biome.getType() != targetType || biome.climate != climate) continue;
            for (int i = 0; i < biome.biomeWeight; ++i) {
                contenders.add(biome);
            }
        }
        Collections.shuffle(contenders, sectionRand);
        if (contenders.isEmpty()) {
            TerraformGeneratorPlugin.logger.info("Defaulted for: " + temperature + " : " + moisture + "," + String.valueOf((Object)climate) + ":" + String.valueOf((Object)targetType));
            return switch (targetType) {
                default -> throw new IncompatibleClassChangeError();
                case BiomeType.BEACH -> BiomeBank.valueOf(TConfig.c.BIOME_DEFAULT_BEACH);
                case BiomeType.DEEP_OCEANIC -> BiomeBank.valueOf(TConfig.c.BIOME_DEFAULT_DEEPOCEANIC);
                case BiomeType.FLAT -> BiomeBank.valueOf(TConfig.c.BIOME_DEFAULT_FLAT);
                case BiomeType.MOUNTAINOUS -> BiomeBank.valueOf(TConfig.c.BIOME_DEFAULT_MOUNTAINOUS);
                case BiomeType.OCEANIC -> BiomeBank.valueOf(TConfig.c.BIOME_DEFAULT_OCEANIC);
                case BiomeType.RIVER -> BiomeBank.valueOf(TConfig.c.BIOME_DEFAULT_RIVER);
                case BiomeType.HIGH_MOUNTAINOUS -> BiomeBank.valueOf(TConfig.c.BIOME_DEFAULT_HIGHMOUNTAINOUS);
            };
        }
        return (BiomeBank)((Object)contenders.get(0));
    }

    public AbstractCavePopulator getCavePop() {
        return this.cavePop;
    }

    public BiomeType getType() {
        return this.type;
    }

    public BiomeHandler getHandler() {
        return this.handler;
    }

    public BiomeClimate getClimate() {
        return this.climate;
    }

    public int getBiomeWeight() {
        return this.biomeWeight;
    }

    public boolean isDry() {
        return this.getType().isDry();
    }

    static {
        BIOMESECTION_CACHE = new ConcurrentLRUCache<BiomeSection, BiomeSection>("BIOMESECTION_CACHE", 250, key -> {
            key.doCalculations();
            return key;
        });
        debugPrint = false;
        singleLand = null;
        singleOcean = null;
        singleDeepOcean = null;
        singleMountain = null;
        singleHighMountain = null;
    }
}

