/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;

public class BiomeBlender {
    final boolean blendBiomeGrid;
    final boolean blendWater;
    private final TerraformWorld tw;
    double gridBlendingFactor = 1.0;
    int riverThreshold = 5;
    boolean blendBeachesToo = true;
    int smoothBlendTowardsRivers = -1;

    public BiomeBlender(TerraformWorld tw, boolean blendBiomeGrid, boolean blendWater) {
        this.tw = tw;
        this.blendBiomeGrid = blendBiomeGrid;
        this.blendWater = blendWater;
    }

    public BiomeBlender(TerraformWorld tw) {
        this(tw, true, true);
    }

    public double getEdgeFactor(BiomeBank currentBiome, int x, int z) {
        return this.getEdgeFactor(currentBiome, x, z, this.blendBeachesToo ? HeightMap.RIVER.getHeight(this.tw, x, z) : 0.0);
    }

    public double getEdgeFactor(BiomeBank currentBiome, int x, int z, double riverDepth) {
        double gridFactor;
        double height;
        double riverFactor;
        double factor = 1.0;
        if (this.blendWater && (riverFactor = this.smoothBlendTowardsRivers == -1 ? (this.blendBeachesToo ? riverDepth / (double)(-this.riverThreshold) : (HeightMap.getPreciseHeight(this.tw, x, z) - (double)TerraformGenerator.seaLevel) / (double)this.riverThreshold) : ((height = HeightMap.getPreciseHeight(this.tw, x, z)) > (double)(TerraformGenerator.seaLevel + this.smoothBlendTowardsRivers) ? 1.0 : (height <= (double)TerraformGenerator.seaLevel ? 0.0 : (height - (double)TerraformGenerator.seaLevel) / (double)this.smoothBlendTowardsRivers))) < factor) {
            factor = Math.max(0.0, riverFactor);
        }
        if (this.blendBiomeGrid && (gridFactor = this.getGridEdgeFactor(currentBiome, this.tw, x, z)) < factor) {
            factor = gridFactor;
        }
        return factor;
    }

    public double getGridEdgeFactor(BiomeBank currentBiome, TerraformWorld tw, int x, int z) {
        SimpleLocation target = new SimpleLocation(x, 0, z);
        Collection<BiomeSection> sections = BiomeSection.getSurroundingSections(tw, 3, x, z);
        BiomeSection mostDominantTarget = null;
        double dominance = -100.0;
        for (BiomeSection section : sections) {
            double dom;
            if (section.getBiomeBank() != currentBiome || !((dom = (double)section.getDominance(target)) > dominance)) continue;
            mostDominantTarget = section;
            dominance = dom;
        }
        if (mostDominantTarget == null) {
            return 0.0;
        }
        double factor = 1.0;
        for (BiomeSection section : sections) {
            if (section.getBiomeBank() == currentBiome) continue;
            float dom = section.getDominance(target);
            double diff = Math.max(0.0, dominance - (double)dom);
            factor = Math.min(factor, diff * this.gridBlendingFactor);
        }
        return Math.min(factor, 1.0);
    }

    @NotNull
    public BiomeBlender setGridBlendingFactor(double gridBlendingFactor) {
        this.gridBlendingFactor = gridBlendingFactor;
        return this;
    }

    @NotNull
    public BiomeBlender setRiverThreshold(int riverThreshold) {
        this.riverThreshold = riverThreshold;
        return this;
    }

    @NotNull
    public BiomeBlender setSmoothBlendTowardsRivers(int smoothBlendTowardsRivers) {
        this.smoothBlendTowardsRivers = smoothBlendTowardsRivers;
        return this;
    }

    @NotNull
    public BiomeBlender setBlendBeaches(boolean blendBeachesToo) {
        this.blendBeachesToo = blendBeachesToo;
        return this;
    }
}

