/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.TreeDB;
import org.terraform.utils.GenUtils;

public class SwampHandler
extends BiomeHandler {
    @Override
    @NotNull
    public BiomeBank getRiverType() {
        return BiomeBank.SWAMP;
    }

    @Override
    public boolean isOcean() {
        return true;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.SWAMP;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{GenUtils.randChoice(rand, new Material[]{Material.GRASS_BLOCK, Material.PODZOL, Material.PODZOL}), GenUtils.randChoice(rand, new Material[]{Material.DIRT}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    public BiomeHandler getTransformHandler() {
        return BiomeBank.MANGROVE.getHandler();
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, Random random, int rawX, int surfaceY, int rawZ, PopulatorDataAbstract data) {
        BiomeBank.MANGROVE.getHandler().populateSmallItems(tw, random, rawX, surfaceY, rawZ, data);
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        int treeY;
        int treeZ;
        int treeX;
        if (GenUtils.chance(random, 8, 10) && data.getBiome(treeX = GenUtils.randInt(random, 2, 12) + data.getChunkX() * 16, treeZ = GenUtils.randInt(random, 2, 12) + data.getChunkZ() * 16) == this.getBiome() && (treeY = GenUtils.getHighestGround(data, treeX, treeZ)) > TerraformGenerator.seaLevel - 6) {
            TreeDB.spawnBreathingRoots(tw, new SimpleBlock(data, treeX, treeY, treeZ), Material.OAK_LOG);
            FractalTypes.Tree.SWAMP_TOP.build(tw, new SimpleBlock(data, treeX, treeY, treeZ), t -> {
                t.setCheckGradient(false);
                t.setRootMaterial(Material.OAK_WOOD);
                t.setBranchMaterial(Material.OAK_LOG);
                t.getFractalLeaves().setMaterial(Material.OAK_LEAVES);
                t.getFractalLeaves().setMangrovePropagules(false);
            });
        }
    }

    @Override
    @NotNull
    public BiomeBank getBeachType() {
        return BiomeBank.MUDFLATS;
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double height = HeightMap.CORE.getHeight(tw, x, z) - 10.0;
        if (height <= 0.0) {
            height = 3.0;
        }
        return height;
    }
}

