/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.BiomeType;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class PaintedHillsHandler
extends AbstractMountainHandler {
    @Override
    protected double getPeakMultiplier(@NotNull BiomeSection section, @NotNull Random sectionRandom) {
        return GenUtils.randDouble(sectionRandom, 1.05, 1.1);
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.SAVANNA;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{Material.ORANGE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.ORANGE_TERRACOTTA, GenUtils.randChoice(rand, new Material[]{Material.ORANGE_TERRACOTTA, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.ORANGE_TERRACOTTA, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        this.correctDirt(new SimpleBlock(data, rawX, surfaceY, rawZ));
        FastNoise paintNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_PAINTEDHILLS_NOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 4L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.03f);
            return n;
        });
        if (HeightMap.getTrueHeightGradient(data, rawX, rawZ, 3) < TConfig.c.MISC_TREES_GRADIENT_LIMIT) {
            data.setType(rawX, surfaceY, rawZ, Material.GRASS_BLOCK);
            if (random.nextBoolean()) {
                data.setType(rawX, surfaceY - 1, rawZ, Material.DIRT);
            }
            if (GenUtils.chance(random, 1, 30)) {
                PlantBuilder.GRASS.build(data, rawX, surfaceY + 1, rawZ);
                if (random.nextBoolean()) {
                    PlantBuilder.TALL_GRASS.build(data, rawX, surfaceY + 1, rawZ);
                } else {
                    PlantBuilder.DEAD_BUSH.build(data, rawX, surfaceY + 1, rawZ);
                }
            }
        }
        int terracottaDepth = 9;
        for (int i = 0; i < terracottaDepth; ++i) {
            if (data.getType(rawX, surfaceY - i, rawZ) != Material.ORANGE_TERRACOTTA) continue;
            double noise = paintNoise.GetNoise(rawX, surfaceY - i, rawZ);
            Material mat = noise > 0.3 ? Material.RED_TERRACOTTA : (noise > 0.0 ? Material.CYAN_TERRACOTTA : (noise > -0.3 ? Material.LIGHT_BLUE_TERRACOTTA : Material.YELLOW_TERRACOTTA));
            data.setType(rawX, surfaceY - i, rawZ, mat);
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 25)) {
            int treeY;
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || data.getType((sLoc = sLoc.getAtY(treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ()))).getX(), sLoc.getY(), sLoc.getZ()) != Material.GRASS_BLOCK) continue;
            new FractalTreeBuilder(FractalTypes.Tree.SAVANNA_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
    }

    private void correctDirt(@NotNull SimpleBlock start) {
        for (int depth = 0; depth < 5; ++depth) {
            for (BlockFace face : BlockUtils.directBlockFaces) {
                if (start.getRelative(face).getType() != Material.ORANGE_TERRACOTTA) continue;
                start.setType(Material.ORANGE_TERRACOTTA);
                break;
            }
            start = start.getDown();
        }
    }

    @Override
    public double calculateHeight(@NotNull TerraformWorld tw, int x, int z) {
        SimpleLocation mountainPeak;
        double distFromPeak;
        Random sectionRand;
        double maxPeak;
        double heightMultiplier;
        double height = HeightMap.CORE.getHeight(tw, x, z);
        double maxMountainRadius = BiomeSection.sectionWidth;
        height += HeightMap.ATTRITION.getHeight(tw, x, z);
        BiomeSection sect = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
        if (sect.getBiomeBank().getType() != BiomeType.MOUNTAINOUS) {
            sect = BiomeSection.getMostDominantSection(tw, x, z);
        }
        if ((heightMultiplier = (maxPeak = this.getPeakMultiplier(sect, sectionRand = sect.getSectionRandom())) * ((distFromPeak = 1.42 * maxMountainRadius - Math.sqrt(Math.pow(x - (mountainPeak = sect.getCenter()).getX(), 2.0) + Math.pow(z - mountainPeak.getZ(), 2.0))) / maxMountainRadius)) < 1.0) {
            heightMultiplier = 1.0;
        }
        height *= heightMultiplier;
        FastNoise jaggedPeaksNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_PAINTEDHILLS_ROCKS_NOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 2L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(5);
            n.SetFrequency(0.05f);
            return n;
        });
        double noise = jaggedPeaksNoise.GetNoise(x, z);
        if (noise > 0.3) {
            height += Math.sqrt(noise) * 40.0;
        }
        if (height > 200.0) {
            height = 200.0 + (height - 200.0) * 0.5;
        }
        if (height > 230.0) {
            height = 230.0 + (height - 230.0) * 0.3;
        }
        if (height > 240.0) {
            height = 240.0 + (height - 240.0) * 0.1;
        }
        if (height > 250.0) {
            height = 250.0 + (height - 250.0) * 0.05;
        }
        return height;
    }
}

