/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command.contants;

import java.io.FileNotFoundException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.terraform.command.contants.TerraCommandArgument;
import org.terraform.data.SimpleBlock;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.schematic.TerraSchematic;

public class SchematicArgument
extends TerraCommandArgument<TerraSchematic> {
    public SchematicArgument(String name, boolean isOptional) {
        super(name, isOptional);
    }

    @Override
    public TerraSchematic parse(@NotNull CommandSender sender, String value) {
        try {
            return TerraSchematic.load(value, new SimpleBlock(((Player)sender).getLocation()));
        }
        catch (FileNotFoundException e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
            return null;
        }
    }

    @Override
    @NotNull
    public String validate(@NotNull CommandSender sender, String value) {
        try {
            TerraSchematic.load(value, new SimpleBlock(((Player)sender).getLocation()));
        }
        catch (Throwable e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
            return "Problem loading schematic. Check console for error";
        }
        return "";
    }
}

