/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.data;

import java.util.Objects;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.utils.BlockUtils;

public class Wall
extends SimpleBlock {
    private final BlockFace direction;

    public Wall(@NotNull SimpleBlock block, BlockFace dir) {
        super(block.getPopData(), block.getX(), block.getY(), block.getZ());
        this.direction = dir;
    }

    public Wall(@NotNull PopulatorDataAbstract data, @NotNull SimpleLocation loc, BlockFace dir) {
        super(data, loc.getX(), loc.getY(), loc.getZ());
        this.direction = dir;
    }

    public Wall(@NotNull SimpleBlock block) {
        super(block.getPopData(), block.getX(), block.getY(), block.getZ());
        this.direction = BlockFace.NORTH;
    }

    public Wall(@NotNull PopulatorDataAbstract data, int x, int y, int z, BlockFace dir) {
        super(data, x, y, z);
        this.direction = dir;
    }

    @NotNull
    public Wall clone() {
        return new Wall(this.popData, this.getX(), this.getY(), this.getZ(), this.direction);
    }

    @Override
    @NotNull
    public Wall getAtY(int y) {
        return new Wall(this.popData, this.getX(), y, this.getZ(), this.direction);
    }

    @NotNull
    public Wall getLeft() {
        return new Wall(this.getRelative(BlockUtils.getAdjacentFaces(this.direction)[0]), this.direction);
    }

    @Override
    @NotNull
    public Wall getUp() {
        return new Wall(super.getUp(), this.direction);
    }

    @Override
    @NotNull
    public Wall getUp(int i) {
        return new Wall(super.getUp(i), this.direction);
    }

    @Override
    @NotNull
    public Wall getGround() {
        return new Wall(super.getGround(), this.direction);
    }

    @Override
    @NotNull
    public Wall getGroundOrDry() {
        return new Wall(super.getGroundOrDry(), this.direction);
    }

    @Override
    @NotNull
    public Wall getGroundOrSeaLevel() {
        return new Wall(super.getGroundOrSeaLevel(), this.direction);
    }

    @Override
    public Wall findCeiling(int cutoff) {
        SimpleBlock sb = super.findCeiling(cutoff);
        if (sb == null) {
            return null;
        }
        return new Wall(sb, this.direction);
    }

    @Override
    public Wall findFloor(int cutoff) {
        SimpleBlock sb = super.findFloor(cutoff);
        if (sb == null) {
            return null;
        }
        return new Wall(sb, this.direction);
    }

    @Override
    public Wall findNearestAirPocket(int cutoff) {
        SimpleBlock sb = super.findNearestAirPocket(cutoff);
        if (sb == null) {
            return null;
        }
        return new Wall(sb, this.direction);
    }

    @Override
    public Wall findStonelikeFloor(int cutoff) {
        SimpleBlock sb = super.findStonelikeFloor(cutoff);
        if (sb == null) {
            return null;
        }
        return new Wall(sb, this.direction);
    }

    @Override
    public Wall findStonelikeCeiling(int cutoff) {
        SimpleBlock sb = super.findStonelikeCeiling(cutoff);
        if (sb == null) {
            return null;
        }
        return new Wall(Objects.requireNonNull(super.findStonelikeCeiling(cutoff)), this.direction);
    }

    @Nullable
    public Wall findRight(int cutoff) {
        Wall ceil = this.getRight();
        while (cutoff > 0) {
            if (ceil.isSolid()) {
                return ceil;
            }
            --cutoff;
            ceil = ceil.getRight();
        }
        return null;
    }

    @Nullable
    public Wall findDir(@NotNull BlockFace face, int cutoff) {
        Wall ceil = this.getRelative(face);
        while (cutoff > 0) {
            if (ceil.isSolid()) {
                return ceil;
            }
            --cutoff;
            ceil = ceil.getRelative(face);
        }
        return null;
    }

    @Nullable
    public Wall findLeft(int cutoff) {
        Wall ceil = this.getLeft();
        while (cutoff > 0) {
            if (ceil.isSolid()) {
                return ceil;
            }
            --cutoff;
            ceil = ceil.getLeft();
        }
        return null;
    }

    public Wall getLeft(int it) {
        if (it < 0) {
            return this.getRight(-it);
        }
        Wall w = this;
        for (int i = 0; i < it; ++i) {
            w = w.getLeft();
        }
        return w;
    }

    @NotNull
    public Wall getRight() {
        return new Wall(this.getRelative(BlockUtils.getAdjacentFaces(this.direction)[1]), this.direction);
    }

    public Wall getRight(int it) {
        if (it < 0) {
            return this.getLeft(-it);
        }
        Wall w = this;
        for (int i = 0; i < it; ++i) {
            w = w.getRight();
        }
        return w;
    }

    @NotNull
    public SimpleBlock get() {
        return this;
    }

    @NotNull
    public Wall getRear() {
        return new Wall(super.getRelative(this.direction.getOppositeFace()), this.direction);
    }

    @NotNull
    public Wall flip() {
        return new Wall(this, this.direction.getOppositeFace());
    }

    public Wall getRear(int it) {
        if (it < 0) {
            return this.getFront(-it);
        }
        Wall w = this.clone();
        for (int i = 0; i < it; ++i) {
            w = w.getRear();
        }
        return w;
    }

    @NotNull
    public Wall getFront() {
        return new Wall(super.getRelative(this.direction), this.direction);
    }

    public Wall getFront(int it) {
        if (it < 0) {
            return this.getRear(-it);
        }
        Wall w = this.clone();
        for (int i = 0; i < it; ++i) {
            w = w.getFront();
        }
        return w;
    }

    public BlockFace getDirection() {
        return this.direction;
    }

    @Override
    @NotNull
    public Wall getDown(int i) {
        return new Wall(super.getDown(i), this.direction);
    }

    @Override
    @NotNull
    public Wall getDown() {
        return new Wall(super.getDown(), this.direction);
    }

    @Override
    @NotNull
    public Wall getRelative(int x, int y, int z) {
        return new Wall(super.getRelative(x, y, z), this.direction);
    }

    @Override
    @NotNull
    public Wall getRelative(@NotNull BlockFace face) {
        return new Wall(super.getRelative(face), this.direction);
    }

    @Override
    @NotNull
    public Wall getRelative(@NotNull BlockFace face, int depth) {
        return new Wall(super.getRelative(face, depth), this.direction);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public void lootTableChest(TerraLootTable table) {
        this.get().getPopData().lootTableChest(this.getX(), this.getY(), this.getZ(), table);
    }
}

