/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.spigot.v1_21_R6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Biomes;
import org.bukkit.Bukkit;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.version.TerraformFieldHandler;
import org.terraform.utils.version.TerraformMethodHandler;

public class CustomBiomeHandler {
    public static final HashMap<CustomBiomeType, ResourceKey<BiomeBase>> terraformGenBiomeRegistry = new HashMap();

    public static IRegistry<BiomeBase> getBiomeRegistry() {
        return (IRegistry)MinecraftServer.getServer().bg().a(Registries.aN).orElseThrow();
    }

    public static void init() {
        CraftServer craftserver = (CraftServer)Bukkit.getServer();
        DedicatedServer dedicatedserver = craftserver.getServer();
        IRegistryWritable registrywritable = (IRegistryWritable)CustomBiomeHandler.getBiomeRegistry();
        try {
            TerraformFieldHandler frozen = new TerraformFieldHandler(RegistryMaterials.class, "frozen", "l");
            frozen.field.set(registrywritable, false);
            TerraformGeneratorPlugin.logger.info("Unfreezing biome registry...");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            TerraformGeneratorPlugin.logger.error(e1.toString());
            TerraformGeneratorPlugin.logger.stackTrace(e1);
            return;
        }
        Holder.c forestbiome = registrywritable.p().b(Biomes.i);
        for (CustomBiomeType type : CustomBiomeType.values()) {
            if (type == CustomBiomeType.NONE) continue;
            try {
                assert (forestbiome != null);
                CustomBiomeHandler.registerCustomBiome(type, dedicatedserver, (IRegistryWritable<BiomeBase>)registrywritable, (Holder<BiomeBase>)forestbiome);
                TerraformGeneratorPlugin.logger.info("Registered custom biome: " + type.toString().toLowerCase(Locale.ENGLISH));
            }
            catch (Throwable e2) {
                TerraformGeneratorPlugin.logger.error("Failed to register custom biome: " + type.getKey());
                TerraformGeneratorPlugin.logger.stackTrace(e2);
            }
        }
        try {
            TerraformFieldHandler frozen = new TerraformFieldHandler(RegistryMaterials.class, "frozen", "l");
            frozen.field.set(registrywritable, true);
            TerraformGeneratorPlugin.logger.info("Freezing biome registry");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            TerraformGeneratorPlugin.logger.stackTrace(e1);
        }
    }

    private static void registerCustomBiome(@NotNull CustomBiomeType biomeType, DedicatedServer dedicatedserver, @NotNull IRegistryWritable<BiomeBase> registrywritable, @NotNull Holder<BiomeBase> forestBiomeHolder) throws Throwable {
        BiomeBase forestbiome = (BiomeBase)forestBiomeHolder.a();
        TerraformFieldHandler defaultRegInfoField = new TerraformFieldHandler(ReloadableServerRegistries.class, "b", "DEFAULT_REGISTRATION_INFO");
        Object regInfo = defaultRegInfoField.field.get(null);
        ResourceKey newKey = ResourceKey.a((ResourceKey)Registries.aN, (MinecraftKey)MinecraftKey.a((String)"terraformgenerator", (String)biomeType.toString().toLowerCase(Locale.ENGLISH)));
        BiomeBase.a newBiomeBuilder = new BiomeBase.a();
        newBiomeBuilder.a(forestbiome.c());
        TerraformFieldHandler biomeSettingMobsField = new TerraformFieldHandler(BiomeBase.class, "mobSettings", "k");
        BiomeSettingsMobs biomeSettingMobs = (BiomeSettingsMobs)biomeSettingMobsField.field.get(forestbiome);
        newBiomeBuilder.a(biomeSettingMobs);
        TerraformFieldHandler biomeSettingGenField = new TerraformFieldHandler(BiomeBase.class, "generationSettings", "j");
        BiomeSettingsGeneration biomeSettingGen = (BiomeSettingsGeneration)biomeSettingGenField.field.get(forestbiome);
        newBiomeBuilder.a(biomeSettingGen);
        newBiomeBuilder.a(0.7f);
        newBiomeBuilder.b(biomeType.getRainFall());
        if (biomeType.isCold()) {
            newBiomeBuilder.a(BiomeBase.TemperatureModifier.b);
        } else {
            newBiomeBuilder.a(BiomeBase.TemperatureModifier.a);
        }
        BiomeFog.a newFog = new BiomeFog.a();
        newFog.a(biomeType.getFogColor().isEmpty() ? forestbiome.e() : Integer.parseInt(biomeType.getFogColor(), 16)).b(biomeType.getWaterColor().isEmpty() ? forestbiome.j() : Integer.parseInt(biomeType.getWaterColor(), 16)).c(biomeType.getWaterFogColor().isEmpty() ? forestbiome.k() : Integer.parseInt(biomeType.getWaterFogColor(), 16)).d(biomeType.getSkyColor().isEmpty() ? forestbiome.a() : Integer.parseInt(biomeType.getSkyColor(), 16)).e(biomeType.getFoliageColor().isEmpty() ? forestbiome.f() : Integer.parseInt(biomeType.getFoliageColor(), 16)).g(biomeType.getGrassColor().isEmpty() ? Integer.parseInt("79C05A", 16) : Integer.parseInt(biomeType.getGrassColor(), 16));
        newBiomeBuilder.a(newFog.b());
        BiomeBase biome = newBiomeBuilder.a();
        if (registrywritable.p().a(newKey).isPresent() && ((Holder.c)registrywritable.p().a(newKey).get()).b()) {
            TerraformGeneratorPlugin.logger.info(String.valueOf(newKey) + " was already registered. Was there a plugin/server reload?");
            return;
        }
        TerraformMethodHandler register = new TerraformMethodHandler(registrywritable.getClass(), new String[]{"register", "a"}, ResourceKey.class, Object.class, Class.forName("net.minecraft.core.RegistrationInfo"));
        Holder.c holder = (Holder.c)register.method.invoke(registrywritable, newKey, biome, regInfo);
        TerraformMethodHandler bindValue = new TerraformMethodHandler(Holder.c.class, new String[]{"bindValue", "b"}, Object.class);
        bindValue.method.invoke((Object)holder, biome);
        HashSet tags = new HashSet();
        forestBiomeHolder.c().forEach(tags::add);
        TerraformMethodHandler bindTags = new TerraformMethodHandler(Holder.c.class, new String[]{"bindTags", "a"}, Collection.class);
        bindTags.method.invoke((Object)holder, tags);
        terraformGenBiomeRegistry.put(biomeType, (ResourceKey<BiomeBase>)newKey);
    }

    public static Set<Holder<BiomeBase>> biomeListToBiomeSet(@NotNull IRegistry<BiomeBase> registry) {
        ArrayList Biomes2 = new ArrayList();
        Registry.BIOME.iterator().forEachRemaining(biome -> {
            try {
                if (biome == null) {
                    return;
                }
                Holder holder = CraftBiome.bukkitToMinecraftHolder((Biome)biome);
                if (holder == null) {
                    return;
                }
                Biomes2.add(holder);
            }
            catch (Throwable e2) {
                TerraformGeneratorPlugin.logger.info("Ignoring biome " + String.valueOf(biome));
            }
        });
        for (CustomBiomeType cbt : CustomBiomeType.values()) {
            if (cbt == CustomBiomeType.NONE) continue;
            ResourceKey<BiomeBase> rkey = terraformGenBiomeRegistry.get((Object)cbt);
            Optional holder = registry.a(rkey);
            holder.ifPresent(Biomes2::add);
        }
        return Set.copyOf(Biomes2);
    }
}

