/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.mineshaft;

import java.io.FileNotFoundException;
import java.util.EnumSet;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.schematic.TerraSchematic;
import org.terraform.structure.mineshaft.OreLiftSchematicParser;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class ShaftTopPopulator
extends RoomPopulatorAbstract {
    public ShaftTopPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int[] lowerCorner = room.getLowerCorner(1);
        int[] upperCorner = room.getUpperCorner(1);
        int y = room.getY();
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                SimpleBlock b2 = new SimpleBlock(data, x, y, z);
                if (b2.getDown().getType() != Material.OAK_FENCE) continue;
                while (b2.getDown().getType() == Material.OAK_FENCE) {
                    b2 = b2.getDown();
                }
                while (b2.getY() <= y) {
                    b2.setType(Material.SCAFFOLDING);
                    b2 = b2.getUp();
                }
            }
        }
        Wall w = new Wall(new SimpleBlock(data, room.getX(), room.getY() + 3, room.getZ()));
        if ((w = w.findCeiling(10)) != null) {
            try {
                Wall target = w.getRelative(0, -GenUtils.randInt(this.rand, 8, 10), 0);
                BlockUtils.carveCaveAir(new Random().nextInt(777123), 3.0f, 5.0f, 3.0f, new SimpleBlock(data, target.getX(), room.getY(), target.getZ()), false, EnumSet.of(Material.BARRIER));
                TerraSchematic schema = TerraSchematic.load("ore-lift", target.get().getRelative(-1, 0, -1));
                schema.parser = new OreLiftSchematicParser();
                schema.setFace(BlockFace.NORTH);
                schema.apply();
                target.LPillar(w.getY() - target.getY(), this.rand, Material.OAK_FENCE);
            }
            catch (FileNotFoundException e2) {
                TerraformGeneratorPlugin.logger.stackTrace(e2);
            }
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return false;
    }
}

