/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;

public class PyramidStairwayTopPopulator
extends RoomPopulatorAbstract {
    public PyramidStairwayTopPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int bfIndex = 6;
        for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
            data.setType(room.getX() + face.getModX(), room.getY(), room.getZ() + face.getModZ(), Material.CAVE_AIR);
        }
        for (int i = 0; i < room.getHeight(); ++i) {
            data.setType(room.getX(), room.getY() + i, room.getZ(), Material.CHISELED_SANDSTONE);
        }
        BlockFace face = BlockUtils.xzPlaneBlockFaces[bfIndex];
        Slab bottom = (Slab)Bukkit.createBlockData((Material)Material.SANDSTONE_SLAB);
        bottom.setType(Slab.Type.BOTTOM);
        data.setBlockData(room.getX() + face.getModX(), room.getY(), room.getZ() + face.getModZ(), (BlockData)bottom);
        bfIndex = PyramidStairwayTopPopulator.getNextIndex(bfIndex);
        face = BlockUtils.xzPlaneBlockFaces[bfIndex];
        Slab top = (Slab)Bukkit.createBlockData((Material)Material.SANDSTONE_SLAB);
        top.setType(Slab.Type.TOP);
        data.setBlockData(room.getX() + face.getModX(), room.getY(), room.getZ() + face.getModZ(), (BlockData)top);
        bfIndex = PyramidStairwayTopPopulator.getNextIndex(bfIndex);
        face = BlockUtils.xzPlaneBlockFaces[bfIndex];
        data.setBlockData(room.getX() + face.getModX(), room.getY(), room.getZ() + face.getModZ(), (BlockData)top);
        bfIndex = PyramidStairwayTopPopulator.getNextIndex(bfIndex);
        face = BlockUtils.xzPlaneBlockFaces[bfIndex];
        data.setBlockData(room.getX() + face.getModX(), room.getY(), room.getZ() + face.getModZ(), (BlockData)top);
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return false;
    }
}

