/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.small.ruinedportal;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeClimate;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.MegaChunk;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfig;
import org.terraform.structure.MultiMegaChunkStructurePopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CylinderBuilder;
import org.terraform.utils.GenUtils;
import org.terraform.utils.StalactiteBuilder;
import org.terraform.utils.blockdata.ChestBuilder;
import org.terraform.utils.blockdata.StairBuilder;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class RuinedPortalPopulator
extends MultiMegaChunkStructurePopulator {
    private static final Material[] portalBlocks = new Material[]{Material.OBSIDIAN, Material.CRYING_OBSIDIAN};

    @Override
    public void populate(@NotNull TerraformWorld tw, @NotNull PopulatorDataAbstract data) {
        if (!this.isEnabled()) {
            return;
        }
        Random random = this.getHashedRandom(tw, data.getChunkX(), data.getChunkZ());
        MegaChunk mc = new MegaChunk(data.getChunkX(), data.getChunkZ());
        for (int[] coords : this.getCoordsFromMegaChunk(tw, mc)) {
            int x = coords[0];
            int z = coords[1];
            if (x >> 4 != data.getChunkX() || z >> 4 != data.getChunkZ()) continue;
            int height = GenUtils.getHighestGround(data, x, z);
            this.spawnRuinedPortal(tw, random, data, x, height + 1, z);
        }
    }

    public void spawnRuinedPortal(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data, int x, int y, int z) {
        SimpleBlock core = new SimpleBlock(data, x, y, z);
        BiomeBank biome = tw.getBiomeBank(x, z);
        boolean overgrown = biome.getClimate() == BiomeClimate.HUMID_VEGETATION;
        boolean snowy = biome.getClimate() == BiomeClimate.SNOWY;
        int mossiness = 0;
        if (biome.getClimate() == BiomeClimate.HUMID_VEGETATION) {
            mossiness = 2;
        } else if (biome.getClimate() == BiomeClimate.DRY_VEGETATION || biome.getClimate() == BiomeClimate.TRANSITION) {
            mossiness = 1;
        }
        this.spawnRuinedPortal(tw, random, core.getUp(), mossiness, overgrown, snowy);
    }

    public void spawnRuinedPortal(TerraformWorld tw, @NotNull Random random, @NotNull SimpleBlock core, int mossiness, boolean overgrown, boolean snowy) {
        Wall target;
        int height;
        int depth;
        int horRadius = GenUtils.randInt(random, 2, 4);
        int vertHeight = 1 + horRadius * 2;
        BlockFace facing = BlockUtils.getDirectBlockFace(random);
        Wall w = new Wall(core, facing);
        Material lavaFluid = Material.LAVA;
        if (BlockUtils.isWet(core) || snowy || overgrown) {
            lavaFluid = Material.MAGMA_BLOCK;
        }
        BlockUtils.replaceCircularPatch(random.nextInt(99999), (float)horRadius * 2.5f, core.getDown(), snowy, Material.NETHERRACK);
        Material[] stoneBricks = BlockUtils.stoneBricks;
        if (mossiness == 0) {
            stoneBricks = new Material[]{Material.STONE_BRICKS, Material.CRACKED_STONE_BRICKS};
        }
        if (mossiness > 1) {
            stoneBricks = new Material[]{Material.STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.MOSSY_STONE_BRICKS};
        }
        new CylinderBuilder(random, w.getDown(), stoneBricks).setRadius(horRadius + 1).setRY(1.0f).setHardReplace(false).build();
        Wall effectiveGround = w.getRight(horRadius).findFloor(10);
        int heightCorrection = vertHeight;
        if (effectiveGround != null) {
            if (effectiveGround.getY() >= w.getY() - 2) {
                effectiveGround = effectiveGround.getAtY(w.getY() - 2);
            } else {
                heightCorrection = vertHeight + (w.getY() - 2 - effectiveGround.getY());
            }
            new StalactiteBuilder(portalBlocks).setVerticalSpace(Math.round(2.5f * (float)heightCorrection * 1.5f)).setFacingUp(true).setSolidBlockType(portalBlocks).setMinRadius(2).build(random, effectiveGround);
        }
        effectiveGround = w.getLeft(horRadius + 1).findFloor(10);
        heightCorrection = vertHeight;
        if (effectiveGround != null) {
            if (effectiveGround.getY() >= w.getY() - 2) {
                effectiveGround = effectiveGround.getAtY(w.getY() - 2);
            } else {
                heightCorrection = vertHeight + (w.getY() - 2 - effectiveGround.getY());
            }
            new StalactiteBuilder(portalBlocks).setVerticalSpace(Math.round(2.5f * (float)heightCorrection * 1.5f)).setFacingUp(true).setSolidBlockType(portalBlocks).setMinRadius(2).build(random, effectiveGround);
        }
        for (int left = 0; left < horRadius; ++left) {
            w.getLeft(left).setType(portalBlocks);
            for (depth = -3; depth <= 3; ++depth) {
                for (height = 0; height < vertHeight - 2; ++height) {
                    target = w.getFront(depth).getLeft(left).getUp(1 + height);
                    target.setType(this.getFluid(target));
                }
            }
            w.getUp(vertHeight).getLeft(left).setType(portalBlocks);
            w.getUp(vertHeight + 1).getLeft(left).setType(Material.STONE_BRICK_SLAB, this.getFluid(w.getUp(vertHeight + 1).getLeft(left)));
        }
        for (int right = 1; right < horRadius - 1; ++right) {
            w.getRight(right).setType(portalBlocks);
            for (depth = -3; depth <= 3; ++depth) {
                for (height = 0; height < vertHeight - 2; ++height) {
                    target = w.getFront(depth).getRight(right).getUp(1 + height);
                    target.setType(this.getFluid(target));
                }
            }
            w.getUp(vertHeight).getRight(right).setType(portalBlocks);
            w.getUp(vertHeight + 1).getRight(right).setType(Material.STONE_BRICK_SLAB, this.getFluid(w.getUp(vertHeight + 1).getRight(right)));
        }
        w.getLeft(horRadius).Pillar(1 + vertHeight, portalBlocks);
        w.getRight(horRadius - 1).Pillar(1 + vertHeight, portalBlocks);
        Wall rightCorner = w.getUp(vertHeight).getRight(horRadius - 1);
        Wall leftCorner = w.getUp(vertHeight).getLeft(horRadius);
        FastNoise noise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.STRUCTURE_RUINEDPORTAL_FISSURES, world -> {
            FastNoise n = new FastNoise((int)world.getSeed());
            n.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
            n.SetFrequency(0.035f);
            n.SetFractalOctaves(5);
            return n;
        });
        HashMap<SimpleBlock, Integer> lavaLocs = new HashMap<SimpleBlock, Integer>();
        int lowestY = 9999;
        for (int relx = -horRadius * 3; relx < horRadius * 3; ++relx) {
            for (int relz = -horRadius * 3; relz < horRadius * 3; ++relz) {
                double fissureNoise = 3.0f - 100.0f * Math.abs(noise.GetNoise(relx + core.getX(), relz + core.getZ()));
                if (!(fissureNoise > 0.0)) continue;
                SimpleBlock target2 = core.getRelative(relx, 0, relz).getGround();
                fissureNoise = (1.0 - Math.min(1.0, target2.distance(core) / (double)(horRadius * 3))) * fissureNoise;
                lavaLocs.put(target2, (int)Math.round(fissureNoise));
                if (lowestY <= target2.getY()) continue;
                lowestY = target2.getY();
            }
        }
        for (Map.Entry entry : lavaLocs.entrySet()) {
            int i;
            SimpleBlock target3 = (SimpleBlock)entry.getKey();
            int depth2 = (Integer)entry.getValue();
            int tempY = target3.getY();
            target3 = target3.getAtY(lowestY);
            for (i = target3.getY(); i <= tempY; ++i) {
                target3.getAtY(i).setType(this.getFluid(target3.getAtY(i)));
            }
            for (i = 0; i <= depth2; ++i) {
                target3.getDown(i).setType(lavaFluid);
            }
        }
        if (random.nextBoolean()) {
            int i;
            for (i = 0; i < GenUtils.randInt(1, 3); ++i) {
                rightCorner.getDown(i).setType(this.getFluid(rightCorner.getDown(i)));
            }
            BlockUtils.dropDownBlock(rightCorner.getUp(), this.getFluid(rightCorner.getUp()));
            for (i = 1; i < GenUtils.randInt(random, 2, horRadius + 2); ++i) {
                rightCorner.getLeft(i).setType(this.getFluid(rightCorner.getLeft(i)));
                BlockUtils.dropDownBlock(rightCorner.getLeft(i).getUp(), this.getFluid(rightCorner.getLeft(i).getUp()));
            }
            if (overgrown && TConfig.arePlantsEnabled() && leftCorner.getRight().isSolid()) {
                leftCorner.getRight().getRear().downLPillar(random, GenUtils.randInt(vertHeight / 2, vertHeight - 1), Material.OAK_LEAVES);
                leftCorner.getRight().getFront().downLPillar(random, GenUtils.randInt(vertHeight / 2, vertHeight - 1), Material.OAK_LEAVES);
            }
        } else {
            int i;
            for (i = 0; i < GenUtils.randInt(1, 3); ++i) {
                leftCorner.getDown(i).setType(this.getFluid(leftCorner.getDown(i)));
            }
            BlockUtils.dropDownBlock(leftCorner.getUp(), this.getFluid(leftCorner.getUp()));
            for (i = 1; i < GenUtils.randInt(random, 2, horRadius + 2); ++i) {
                leftCorner.getRight(i).setType(this.getFluid(leftCorner.getRight(i)));
                BlockUtils.dropDownBlock(leftCorner.getRight(i).getUp(), this.getFluid(leftCorner.getRight(i).getUp()));
            }
            if (overgrown && TConfig.arePlantsEnabled() && rightCorner.getLeft().isSolid()) {
                rightCorner.getLeft().getRear().downLPillar(random, GenUtils.randInt(vertHeight / 2, vertHeight - 1), Material.OAK_LEAVES);
                rightCorner.getLeft().getFront().downLPillar(random, GenUtils.randInt(vertHeight / 2, vertHeight - 1), Material.OAK_LEAVES);
            }
        }
        if (rightCorner.isSolid()) {
            new StairBuilder(Material.STONE_BRICK_STAIRS).setFacing(BlockUtils.getLeft(w.getDirection())).apply(rightCorner.getUp());
        }
        if (leftCorner.isSolid()) {
            new StairBuilder(Material.STONE_BRICK_STAIRS).setFacing(BlockUtils.getRight(w.getDirection())).apply(leftCorner.getUp());
        }
        if (w.getUp(vertHeight).isSolid()) {
            new StairBuilder(Material.STONE_BRICK_STAIRS).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getUp(2 + vertHeight));
            w.getUp(1 + vertHeight).setType(Material.GOLD_BLOCK, Material.CHISELED_STONE_BRICKS);
        }
        if (w.getLeft().getUp(vertHeight).isSolid()) {
            new StairBuilder(Material.STONE_BRICK_STAIRS).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getLeft().getUp(2 + vertHeight));
            w.getLeft().getUp(1 + vertHeight).setType(Material.GOLD_BLOCK, Material.CHISELED_STONE_BRICKS);
        }
        new ChestBuilder(Material.CHEST).setFacing(w.getDirection()).setLootTable(TerraLootTable.RUINED_PORTAL).apply(w.getFront(GenUtils.randInt(3, (int)((float)horRadius * 1.5f))).getRight(GenUtils.randInt(3, (int)((float)horRadius * 1.5f))).getGround().getUp());
    }

    @NotNull
    private Material getFluid(@NotNull SimpleBlock block) {
        if (BlockUtils.isWet(block)) {
            return Material.WATER;
        }
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (!BlockUtils.isWet(block.getRelative(face))) continue;
            return Material.WATER;
        }
        return Material.AIR;
    }

    @Override
    public int[][] getCoordsFromMegaChunk(@NotNull TerraformWorld tw, @NotNull MegaChunk mc) {
        int num = TConfig.c.STRUCTURES_RUINEDPORTAL_COUNT_PER_MEGACHUNK;
        int[][] coords = new int[num][2];
        for (int i = 0; i < num; ++i) {
            coords[i] = mc.getRandomCoords(tw.getHashedRand(mc.getX(), mc.getZ(), 4363463 * (1 + i)));
        }
        return coords;
    }

    @Override
    public int[] getNearestFeature(@NotNull TerraformWorld tw, int rawX, int rawZ) {
        MegaChunk mc = new MegaChunk(rawX, 0, rawZ);
        double minDistanceSquared = 2.147483647E9;
        int[] min = null;
        for (int nx = -1; nx <= 1; ++nx) {
            for (int nz = -1; nz <= 1; ++nz) {
                for (int[] loc : this.getCoordsFromMegaChunk(tw, mc)) {
                    double distSqr = Math.pow(loc[0] - rawX, 2.0) + Math.pow(loc[1] - rawZ, 2.0);
                    if (!(distSqr < minDistanceSquared)) continue;
                    minDistanceSquared = distSqr;
                    min = loc;
                }
            }
        }
        return min;
    }

    private boolean rollSpawnRatio(@NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        return GenUtils.chance(tw.getHashedRand(chunkX, chunkZ, 976123), (int)(TConfig.c.STRUCTURES_RUINEDPORTAL_SPAWNRATIO * 10000.0), 10000);
    }

    @Override
    public boolean canSpawn(@NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        if (!this.isEnabled()) {
            return false;
        }
        MegaChunk mc = new MegaChunk(chunkX, chunkZ);
        for (int[] coords : this.getCoordsFromMegaChunk(tw, mc)) {
            if (coords[0] >> 4 != chunkX || coords[1] >> 4 != chunkZ) continue;
            return this.rollSpawnRatio(tw, chunkX, chunkZ);
        }
        return false;
    }

    @Override
    @NotNull
    public Random getHashedRandom(@NotNull TerraformWorld world, int chunkX, int chunkZ) {
        return world.getHashedRand(729384234L, chunkX, chunkZ);
    }

    @Override
    public boolean isEnabled() {
        return TConfig.areStructuresEnabled() && TConfig.c.STRUCTURES_RUINEDPORTAL_ENABLED;
    }

    @Override
    public int getChunkBufferDistance() {
        return 1;
    }
}

