/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.house;

import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Switch;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.house.PlainsVillageHouseVariant;
import org.terraform.structure.village.plains.house.PlainsVillageStandardPiece;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.ChestBuilder;
import org.terraform.utils.blockdata.DirectionalBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class PlainsVillageKitchenPiece
extends PlainsVillageStandardPiece {
    public PlainsVillageKitchenPiece(PlainsVillagePopulator plainsVillagePopulator, PlainsVillageHouseVariant variant, int widthX, int height, int widthZ, JigsawType type, BlockFace[] validDirs) {
        super(plainsVillagePopulator, variant, widthX, height, widthZ, type, validDirs);
    }

    @Override
    public void postBuildDecoration(@NotNull Random random, @NotNull PopulatorDataAbstract data) {
        int i;
        super.postBuildDecoration(random, data);
        if (this.getWalledFaces().isEmpty()) {
            return;
        }
        BlockFace primaryWall = this.getWalledFaces().get(random.nextInt(this.getWalledFaces().size()));
        SimpleBlock core = new SimpleBlock(data, this.getRoom().getX(), this.getRoom().getY() + 1, this.getRoom().getZ());
        int numUtilities = 5;
        if (core.getRelative(primaryWall, 3).getType() == this.plainsVillagePopulator.woodDoor) {
            --numUtilities;
        }
        AbstractMap.SimpleEntry<Wall, Integer> entry = this.getRoom().getWall(data, primaryWall, 0);
        Wall w = entry.getKey();
        ArrayList utilities = Lists.newArrayList((Object[])new Material[]{Material.SMOKER});
        for (i = 0; i < numUtilities; ++i) {
            utilities.add(GenUtils.randChoice(random, new Material[]{Material.HOPPER, Material.FURNACE, Material.CRAFTING_TABLE}));
        }
        Collections.shuffle(utilities);
        for (i = 0; i < entry.getValue(); ++i) {
            if (w.getRear().getType() != this.plainsVillagePopulator.woodDoor) {
                Material mat = (Material)utilities.get(--numUtilities);
                switch (mat) {
                    case HOPPER: {
                        w.setType(mat);
                        if (w.getRear().getUp().getType() == Material.GLASS_PANE) break;
                        Switch lever = (Switch)Bukkit.createBlockData((Material)Material.LEVER);
                        lever.setPowered(true);
                        lever.setAttachedFace(FaceAttachable.AttachedFace.WALL);
                        lever.setFacing(w.getDirection());
                        w.getUp().setBlockData((BlockData)lever);
                        break;
                    }
                    case FURNACE: 
                    case SMOKER: {
                        new DirectionalBuilder(mat).setFacing(w.getDirection()).apply(w);
                        w.getUp().setType(this.plainsVillagePopulator.woodPressurePlate);
                        new StairBuilder(Material.BRICK_STAIRS).setFacing(w.getDirection().getOppositeFace()).setHalf(Bisected.Half.TOP).apply(w.getUp(2));
                        Wall chimneyWall = w.getUp(3);
                        boolean hitCeiling = false;
                        int chimneyHeight = 0;
                        while (chimneyHeight < 4) {
                            if (chimneyWall.isSolid()) {
                                hitCeiling = true;
                            } else if (hitCeiling && GenUtils.chance(random, ++chimneyHeight, 3)) break;
                            chimneyWall.setType(Material.BRICKS);
                            chimneyWall = chimneyWall.getUp();
                        }
                        chimneyWall.setType(Material.BRICK_WALL);
                        break;
                    }
                    case CRAFTING_TABLE: {
                        w.setType(mat);
                        break;
                    }
                }
            }
            w = w.getLeft();
        }
        for (BlockFace face : this.getWalledFaces()) {
            if (face == primaryWall) continue;
            entry = this.getRoom().getWall(data, face, 0);
            w = entry.getKey();
            for (int i2 = 0; i2 < entry.getValue(); ++i2) {
                if (w.getRear().getType() != this.plainsVillagePopulator.woodDoor && !w.isSolid()) {
                    int decor = random.nextInt(5);
                    switch (decor) {
                        case 0: {
                            new StairBuilder(Material.STONE_BRICK_STAIRS, Material.POLISHED_ANDESITE_STAIRS, this.plainsVillagePopulator.woodStairs).setFacing(w.getDirection().getOppositeFace()).setHalf(Bisected.Half.TOP).apply(w);
                            break;
                        }
                        case 1: {
                            w.setType(Material.SMOOTH_STONE, Material.POLISHED_ANDESITE, Material.PUMPKIN, Material.DRIED_KELP_BLOCK, Material.MELON);
                            break;
                        }
                        case 2: {
                            new ChestBuilder(Material.CHEST).setFacing(w.getDirection()).setLootTable(TerraLootTable.VILLAGE_BUTCHER, TerraLootTable.VILLAGE_PLAINS_HOUSE);
                        }
                    }
                }
                w = w.getLeft();
            }
        }
    }

    @Override
    public void build(@NotNull PopulatorDataAbstract data, @NotNull Random rand) {
        super.build(data, rand);
    }
}

