/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class SphereBuilder {
    private final Random random;
    private final int seed;
    private final SimpleBlock core;
    @NotNull
    private final Collection<Material> replaceWhitelist = new ArrayList<Material>();
    private boolean isSmooth = false;
    private float rX = 1.0f;
    private float rY = 1.0f;
    private float rZ = 1.0f;
    private float padding = 0.0f;
    private double minRadius = 0.0;
    private double maxRadius = 100.0;
    private boolean hardReplace = false;
    private Material[] types;
    private Material[] containmentMaterial = new Material[]{Material.STONE};
    private Material[] upperType;
    private Material[] lowerType;
    private int staticWaterLevel = -9999;
    private float sphereFrequency = 0.09f;
    private boolean doLiquidContainment = false;
    private SphereType sphereType = SphereType.FULL_SPHERE;

    public SphereBuilder(@NotNull Random random, SimpleBlock core, Material ... types) {
        this.random = random;
        this.seed = random.nextInt(99999999);
        this.types = types;
        this.core = core;
    }

    @NotNull
    public SphereBuilder setSphereType(SphereType sphereType) {
        this.sphereType = sphereType;
        return this;
    }

    @NotNull
    public SphereBuilder setUpperType(Material ... upperType) {
        this.upperType = upperType;
        return this;
    }

    @NotNull
    public SphereBuilder setLowerType(Material ... lowerType) {
        this.lowerType = lowerType;
        return this;
    }

    @NotNull
    public SphereBuilder setStaticWaterLevel(int staticWaterLevel) {
        this.staticWaterLevel = staticWaterLevel;
        return this;
    }

    @NotNull
    public SphereBuilder addToWhitelist(Material ... mats) {
        this.replaceWhitelist.addAll(Arrays.asList(mats));
        return this;
    }

    @NotNull
    public SphereBuilder setRadius(float radius) {
        this.rX = radius;
        this.rY = radius;
        this.rZ = radius;
        return this;
    }

    @NotNull
    public SphereBuilder setSphereFrequency(float sphereFrequency) {
        this.sphereFrequency = sphereFrequency;
        return this;
    }

    @NotNull
    public SphereBuilder setRX(float rX) {
        this.rX = rX;
        return this;
    }

    @NotNull
    public SphereBuilder setRZ(float rZ) {
        this.rZ = rZ;
        return this;
    }

    @NotNull
    public SphereBuilder setRY(float rY) {
        this.rY = rY;
        return this;
    }

    @NotNull
    public SphereBuilder setSnowy() {
        this.upperType = new Material[]{Material.SNOW};
        return this;
    }

    @NotNull
    public SphereBuilder setHardReplace(boolean hardReplace) {
        this.hardReplace = hardReplace;
        return this;
    }

    @NotNull
    public SphereBuilder setDoLiquidContainment(boolean doLiquidContainment) {
        this.doLiquidContainment = doLiquidContainment;
        return this;
    }

    @NotNull
    public SphereBuilder setCointainmentMaterials(Material ... containmentMaterial) {
        this.containmentMaterial = containmentMaterial;
        return this;
    }

    @NotNull
    public SphereBuilder setMinRadius(double minRadius) {
        this.minRadius = minRadius;
        return this;
    }

    @NotNull
    public SphereBuilder setMaxRadius(double maxRadius) {
        this.maxRadius = maxRadius;
        return this;
    }

    @NotNull
    public SphereBuilder setSmooth(boolean isSmooth) {
        this.isSmooth = isSmooth;
        return this;
    }

    @NotNull
    public SphereBuilder setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public void build() {
        if (this.rX <= 0.0f && this.rY <= 0.0f && this.rZ <= 0.0f) {
            return;
        }
        if ((double)this.rX <= 0.5 && (double)this.rY <= 0.5 && (double)this.rZ <= 0.5) {
            this.unitReplace(this.core, this.core.getY());
            return;
        }
        FastNoise noise = new FastNoise(this.seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(this.sphereFrequency);
        float effectiveRYLower = -this.rY;
        if (this.sphereType == SphereType.UPPER_SEMISPHERE) {
            effectiveRYLower = 0.0f;
        }
        float effectiveRYUpper = this.rY;
        if (this.sphereType == SphereType.LOWER_SEMISPHERE) {
            effectiveRYUpper = 0.0f;
        }
        for (float x = -this.rX - this.padding; x <= this.rX + this.padding; x += 1.0f) {
            for (float y = effectiveRYLower; y <= effectiveRYUpper; y += 1.0f) {
                for (float z = -this.rZ - this.padding; z <= this.rZ + this.padding; z += 1.0f) {
                    SimpleBlock rel = this.core.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double equationResult = Math.pow(x, 2.0) / Math.pow(this.rX, 2.0) + Math.pow(y, 2.0) / Math.pow(this.rY, 2.0) + Math.pow(z, 2.0) / Math.pow(this.rZ, 2.0);
                    double noiseVal = !this.isSmooth ? 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ()) : 1.0;
                    if (noiseVal < this.minRadius) {
                        noiseVal = this.minRadius;
                    }
                    if (noiseVal > this.maxRadius) {
                        noiseVal = this.maxRadius;
                    }
                    if (!(equationResult <= noiseVal)) continue;
                    Material[] original = this.types;
                    if (rel.getY() <= this.staticWaterLevel) {
                        this.types = new Material[]{Material.WATER};
                        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN}) {
                            if (!BlockUtils.isAir(rel.getRelative(face).getType())) continue;
                            this.types = new Material[]{Material.STONE};
                        }
                    }
                    this.unitReplace(rel, (int)((float)this.core.getY() + effectiveRYUpper));
                    this.types = original;
                }
            }
        }
    }

    private void unitReplace(@NotNull SimpleBlock rel, int effectiveRYUpper) {
        if (this.replaceWhitelist.isEmpty()) {
            if (this.hardReplace || !rel.isSolid()) {
                rel.setType(GenUtils.randChoice(this.random, this.types));
                if (this.doLiquidContainment) {
                    rel.replaceAdjacentNonLiquids(new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}, this.types[0], this.containmentMaterial);
                }
            }
        } else if (this.replaceWhitelist.contains(rel.getType())) {
            rel.setType(GenUtils.randChoice(this.random, this.types));
            if (this.doLiquidContainment) {
                rel.replaceAdjacentNonLiquids(new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}, this.types[0], this.containmentMaterial);
            }
        }
        if (rel.isSolid()) {
            if (this.upperType != null && rel.getY() == effectiveRYUpper) {
                rel.getUp().lsetType(this.upperType);
            }
            if (this.lowerType != null) {
                rel.getDown().setType(this.lowerType);
            }
        }
    }

    public static enum SphereType {
        UPPER_SEMISPHERE,
        LOWER_SEMISPHERE,
        FULL_SPHERE;

    }
}

