/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.datastructs;

import java.util.HashMap;
import org.terraform.data.CoordPair;
import org.terraform.data.SimpleLocation;
import org.terraform.utils.datastructs.CompressedChunkBools;

public class CompressedCoordBools {
    HashMap<CoordPair, CompressedChunkBools> chunks = new HashMap();

    public void set(SimpleLocation loc, boolean val) {
        if (val) {
            this.set(loc);
        } else {
            this.unSet(loc);
        }
    }

    public void set(SimpleLocation loc) {
        this.getOrCreate(loc).set(loc.getX() & 0xF, loc.getY(), loc.getZ() & 0xF);
    }

    public void unSet(SimpleLocation loc) {
        if (!this.chunks.containsKey(new CoordPair(loc.getX() >> 4, loc.getZ() >> 4))) {
            return;
        }
        this.getOrCreate(loc).unSet(loc.getX() & 0xF, loc.getY(), loc.getZ() & 0xF);
    }

    public boolean isSet(SimpleLocation loc) {
        if (!this.chunks.containsKey(new CoordPair(loc.getX() >> 4, loc.getZ() >> 4))) {
            return false;
        }
        return this.getOrCreate(loc).isSet(loc.getX() & 0xF, loc.getY(), loc.getZ() & 0xF);
    }

    private CompressedChunkBools getOrCreate(SimpleLocation loc) {
        CoordPair key = new CoordPair(loc.getX() >> 4, loc.getZ() >> 4);
        CompressedChunkBools compressed = this.chunks.get(key);
        if (compressed == null) {
            compressed = new CompressedChunkBools();
            this.chunks.put(key, compressed);
        }
        return compressed;
    }
}

