/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R2;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.bukkit.NativeGeneratorPatcherPopulator;
import org.terraform.coregen.populatordata.IPopulatorDataBaseHeightAccess;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.v1_18_R2.EntityTypeMapper;
import org.terraform.v1_18_R2.NMSChunkGenerator;

public class PopulatorData
extends PopulatorDataAbstract
implements IPopulatorDataBaseHeightAccess {
    private static final HashMap<EntityType, EntityTypes<?>> entityTypesDict = new HashMap();
    final GeneratorAccessSeed rlwa;
    final IChunkAccess ica;
    private final int chunkX;
    private final int chunkZ;
    private final NMSChunkGenerator gen;
    private int radius = 1;

    public PopulatorData(GeneratorAccessSeed rlwa, IChunkAccess ica, NMSChunkGenerator gen, int chunkX, int chunkZ) {
        this.rlwa = rlwa;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.gen = gen;
        this.ica = ica;
        if (entityTypesDict.isEmpty()) {
            for (EntityType type : EntityType.values()) {
                if (type == EntityType.ENDER_SIGNAL || type == EntityType.UNKNOWN) continue;
                try {
                    EntityTypes et = (EntityTypes)EntityTypes.class.getDeclaredField(EntityTypeMapper.getObfsNameFromBukkitEntityType(type)).get(null);
                    entityTypesDict.put(type, et);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    TerraformGeneratorPlugin.logger.stackTrace(e);
                }
            }
        }
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    @NotNull
    public Material getType(int x, int y, int z) {
        try {
            return CraftMagicNumbers.getMaterial((Block)this.rlwa.a_(new BlockPosition(x, y, z)).b());
        }
        catch (Exception e) {
            Bukkit.getLogger().info("Error chunk: " + this.chunkX + "," + this.chunkZ + "--- Block Coords: " + 16 * this.chunkX + "," + 16 * this.chunkZ + " for coords " + x + "," + y + "," + z);
            TerraformGeneratorPlugin.logger.stackTrace(e);
            return null;
        }
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData((IBlockData)this.rlwa.a_(new BlockPosition(x, y, z)));
    }

    @Override
    public void setType(int x, int y, int z, @NotNull Material type) {
        if (Math.abs((x >> 4) - this.chunkX) > this.radius || Math.abs((z >> 4) - this.chunkZ) > this.radius) {
            if (this.radius > 0) {
                NativeGeneratorPatcherPopulator.pushChange(this.rlwa.getMinecraftWorld().getWorld().getName(), x, y, z, Bukkit.createBlockData((Material)type));
            } else {
                TerraformGeneratorPlugin.logger.stackTrace(new Exception("Tried to call adjacent chunk with populator radius 0: (" + x + "," + y + "," + z + ") for chunk (" + this.chunkX + "," + this.chunkZ + ")"));
            }
        } else {
            this.rlwa.a(new BlockPosition(x, y, z), ((CraftBlockData)Bukkit.createBlockData((Material)type)).getState(), 0);
        }
    }

    @Override
    public void setBlockData(int x, int y, int z, @NotNull BlockData data) {
        if (Math.abs((x >> 4) - this.chunkX) > this.radius || Math.abs((z >> 4) - this.chunkZ) > this.radius) {
            if (this.radius > 0) {
                NativeGeneratorPatcherPopulator.pushChange(this.rlwa.getMinecraftWorld().getWorld().getName(), x, y, z, data);
            } else {
                TerraformGeneratorPlugin.logger.stackTrace(new Exception("Tried to call adjacent chunk with populator radius 0: (" + x + "," + y + "," + z + ") for chunk (" + this.chunkX + "," + this.chunkZ + ")"));
            }
        } else {
            this.rlwa.a(new BlockPosition(x, y, z), ((CraftBlockData)data).getState(), 0);
        }
    }

    @Override
    public Biome getBiome(int rawX, int rawZ) {
        TerraformWorld tw = this.gen.getTerraformWorld();
        return tw.getBiomeBank(rawX, rawZ).getHandler().getBiome();
    }

    @Override
    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public void addEntity(int rawX, int rawY, int rawZ, EntityType type) {
        if (Math.abs((rawX >> 4) - this.chunkX) > 1 || Math.abs((rawZ >> 4) - this.chunkZ) > 1) {
            TerraformGeneratorPlugin.logger.info("Failed to spawn " + String.valueOf(type) + " as it was out of bounds.");
            return;
        }
        try {
            EntityTypes<?> et = entityTypesDict.get(type);
            Entity e = et.a((World)this.rlwa.getMinecraftWorld());
            e.o((double)rawX + 0.5, (double)rawY, (double)rawZ + 0.5);
            if (e instanceof EntityInsentient) {
                ((EntityInsentient)e).a((WorldAccess)this.rlwa, this.rlwa.d_(new BlockPosition((double)rawX + 0.5, (double)rawY, (double)rawZ + 0.5)), EnumMobSpawn.n, (GroupDataEntity)null, (NBTTagCompound)null);
            }
            this.rlwa.b(e);
        }
        catch (IllegalArgumentException | SecurityException e1) {
            TerraformGeneratorPlugin.logger.stackTrace(e1);
        }
    }

    @Override
    public void setSpawner(int rawX, int rawY, int rawZ, @NotNull EntityType type) {
        if (!TConfig.areAnimalsEnabled()) {
            return;
        }
        BlockPosition pos = new BlockPosition(rawX, rawY, rawZ);
        this.setType(rawX, rawY, rawZ, Material.SPAWNER);
        TileEntity tileentity = this.rlwa.c_(pos);
        if (tileentity instanceof TileEntityMobSpawner) {
            try {
                EntityTypes nmsEntity = (EntityTypes)IRegistry.W.a(new MinecraftKey(type.getName()));
                ((TileEntityMobSpawner)tileentity).d().a(nmsEntity);
            }
            catch (IllegalArgumentException | SecurityException e) {
                TerraformGeneratorPlugin.logger.stackTrace(e);
            }
        } else {
            TerraformGeneratorPlugin.logger.error("Failed to fetch mob spawner entity at (," + rawX + "," + rawY + "," + rawZ + ")");
        }
    }

    @Override
    public void lootTableChest(int x, int y, int z, @NotNull TerraLootTable table) {
        BlockPosition pos = new BlockPosition(x, y, z);
        TileEntityLootable.a((IBlockAccess)this.rlwa, (Random)this.gen.getTerraformWorld().getHashedRand(x, y, z), (BlockPosition)pos, (MinecraftKey)this.getLootTable(table));
    }

    @Nullable
    private MinecraftKey getLootTable(@NotNull TerraLootTable table) {
        return switch (table) {
            case TerraLootTable.EMPTY -> LootTables.a;
            case TerraLootTable.SPAWN_BONUS_CHEST -> LootTables.b;
            case TerraLootTable.END_CITY_TREASURE -> LootTables.c;
            case TerraLootTable.SIMPLE_DUNGEON -> LootTables.d;
            case TerraLootTable.VILLAGE_WEAPONSMITH -> LootTables.e;
            case TerraLootTable.VILLAGE_TOOLSMITH -> LootTables.f;
            case TerraLootTable.VILLAGE_ARMORER -> LootTables.g;
            case TerraLootTable.VILLAGE_CARTOGRAPHER -> LootTables.h;
            case TerraLootTable.VILLAGE_MASON -> LootTables.i;
            case TerraLootTable.VILLAGE_SHEPHERD -> LootTables.j;
            case TerraLootTable.VILLAGE_BUTCHER -> LootTables.k;
            case TerraLootTable.VILLAGE_FLETCHER -> LootTables.l;
            case TerraLootTable.VILLAGE_FISHER -> LootTables.m;
            case TerraLootTable.VILLAGE_TANNERY -> LootTables.n;
            case TerraLootTable.VILLAGE_TEMPLE -> LootTables.o;
            case TerraLootTable.VILLAGE_DESERT_HOUSE -> LootTables.p;
            case TerraLootTable.VILLAGE_PLAINS_HOUSE -> LootTables.q;
            case TerraLootTable.VILLAGE_TAIGA_HOUSE -> LootTables.r;
            case TerraLootTable.VILLAGE_SNOWY_HOUSE -> LootTables.s;
            case TerraLootTable.VILLAGE_SAVANNA_HOUSE -> LootTables.t;
            case TerraLootTable.ABANDONED_MINESHAFT -> LootTables.u;
            case TerraLootTable.NETHER_BRIDGE -> LootTables.v;
            case TerraLootTable.STRONGHOLD_LIBRARY -> LootTables.w;
            case TerraLootTable.STRONGHOLD_CROSSING -> LootTables.x;
            case TerraLootTable.STRONGHOLD_CORRIDOR -> LootTables.y;
            case TerraLootTable.DESERT_PYRAMID -> LootTables.z;
            case TerraLootTable.JUNGLE_TEMPLE -> LootTables.A;
            case TerraLootTable.JUNGLE_TEMPLE_DISPENSER -> LootTables.B;
            case TerraLootTable.IGLOO_CHEST -> LootTables.C;
            case TerraLootTable.WOODLAND_MANSION -> LootTables.D;
            case TerraLootTable.UNDERWATER_RUIN_SMALL -> LootTables.E;
            case TerraLootTable.UNDERWATER_RUIN_BIG -> LootTables.F;
            case TerraLootTable.BURIED_TREASURE -> LootTables.G;
            case TerraLootTable.SHIPWRECK_MAP -> LootTables.H;
            case TerraLootTable.SHIPWRECK_SUPPLY -> LootTables.I;
            case TerraLootTable.SHIPWRECK_TREASURE -> LootTables.J;
            case TerraLootTable.PILLAGER_OUTPOST -> LootTables.K;
            case TerraLootTable.RUINED_PORTAL -> LootTables.P;
            default -> null;
        };
    }

    @Override
    @NotNull
    public TerraformWorld getTerraformWorld() {
        return this.gen.getTerraformWorld();
    }

    @Override
    public int getBaseHeight(int rawX, int rawZ) {
        return this.gen.a(rawX, rawZ, HeightMap.Type.a, (LevelHeightAccessor)this.rlwa);
    }
}

