/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_21_R3;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBiome;
import org.jetbrains.annotations.Nullable;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_21_R3.CustomBiomeHandler;

public class TerraformWorldProviderBiome
extends WorldChunkManager {
    private static final boolean debug = false;
    private final TerraformWorld tw;
    private final IRegistry<BiomeBase> registry;
    private final Set<Holder<BiomeBase>> biomeList = CustomBiomeHandler.biomeListToBiomeBaseSet(CustomBiomeHandler.getBiomeRegistry());

    public TerraformWorldProviderBiome(TerraformWorld tw, WorldChunkManager delegate) {
        this.tw = tw;
        this.registry = CustomBiomeHandler.getBiomeRegistry();
    }

    public Stream<Holder<BiomeBase>> b() {
        return this.biomeList.stream();
    }

    public Set<Holder<BiomeBase>> c() {
        return this.biomeList;
    }

    protected MapCodec<? extends WorldChunkManager> a() {
        throw new UnsupportedOperationException("Cannot serialize TerraformWorldProviderBiome");
    }

    @Nullable
    public Holder<BiomeBase> getNoiseBiome(int x, int y, int z, Climate.Sampler arg3) {
        BiomeBank bank = this.tw.getBiomeBank(x << 2, z << 2);
        if (bank.getHandler().getCustomBiome() == CustomBiomeType.NONE) {
            return CraftBiome.bukkitToMinecraftHolder((Biome)bank.getHandler().getBiome());
        }
        ResourceKey<BiomeBase> rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)bank.getHandler().getCustomBiome());
        Optional holder = this.registry.a(rkey);
        if (holder.isEmpty()) {
            TerraformGeneratorPlugin.logger.error("Custom biome was not found in the vanilla registry!");
        }
        if (holder.isPresent()) {
            return (Holder)holder.get();
        }
        return CraftBiome.bukkitToMinecraftHolder((Biome)bank.getHandler().getBiome());
    }
}

