/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_21_R6;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.FeatureCountTracker;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdStructure;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.StructureLocator;
import org.terraform.structure.StructurePopulator;
import org.terraform.structure.StructureRegistry;
import org.terraform.structure.VanillaStructurePopulator;
import org.terraform.structure.monument.MonumentPopulator;
import org.terraform.structure.pillager.mansion.MansionPopulator;
import org.terraform.structure.small.buriedtreasure.BuriedTreasurePopulator;
import org.terraform.structure.stronghold.StrongholdPopulator;
import org.terraform.structure.trialchamber.TrialChamberPopulator;
import org.terraform.utils.version.TerraformFieldHandler;
import org.terraform.utils.version.TerraformMethodHandler;
import org.terraform.v1_21_R6.MapRenderWorldProviderBiome;
import org.terraform.v1_21_R6.TerraformWorldProviderBiome;

public class NMSChunkGenerator
extends ChunkGenerator {
    @NotNull
    private final ChunkGenerator delegate;
    @NotNull
    private final TerraformWorld tw;
    @NotNull
    private final MapRenderWorldProviderBiome mapRendererBS;
    @NotNull
    private final TerraformWorldProviderBiome twBS;
    @NotNull
    private final TerraformMethodHandler tryGenerateStructure;
    private final ArrayList<ResourceLocation> possibleStructureSets = new ArrayList();
    @NotNull
    private final TerraformMethodHandler getWriteableArea;
    @NotNull
    private final Supplier featuresPerStep;

    public NMSChunkGenerator(String worldName, long seed, @NotNull ChunkGenerator delegate) throws NoSuchMethodException, SecurityException, NoSuchFieldException, IllegalAccessException {
        super(delegate.getBiomeSource(), delegate.generationSettingsGetter);
        this.tw = TerraformWorld.get(worldName, seed);
        this.delegate = delegate;
        this.mapRendererBS = new MapRenderWorldProviderBiome(this.tw, delegate.getBiomeSource());
        this.twBS = new TerraformWorldProviderBiome(TerraformWorld.get(worldName, seed), delegate.getBiomeSource());
        this.featuresPerStep = (Supplier)new TerraformFieldHandler(ChunkGenerator.class, (String[])new String[]{"featuresPerStep", "c"}).field.get(delegate);
        this.getWriteableArea = new TerraformMethodHandler(ChunkGenerator.class, new String[]{"getWritableArea", "a"}, ChunkAccess.class);
        for (StructurePopulator pop : StructureRegistry.getAllPopulators()) {
            if (!(pop instanceof VanillaStructurePopulator)) continue;
            VanillaStructurePopulator vsp = (VanillaStructurePopulator)pop;
            this.possibleStructureSets.add(ResourceLocation.parse((String)vsp.structureRegistryKey));
        }
        this.tryGenerateStructure = new TerraformMethodHandler(ChunkGenerator.class, new String[]{"tryGenerateStructure", "a"}, StructureSet.StructureSelectionEntry.class, StructureManager.class, RegistryAccess.class, RandomState.class, StructureTemplateManager.class, Long.TYPE, ChunkAccess.class, ChunkPos.class, SectionPos.class, ResourceKey.class);
    }

    @NotNull
    public BiomeSource getBiomeSource() {
        return this.mapRendererBS;
    }

    @NotNull
    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }

    @NotNull
    protected MapCodec<? extends ChunkGenerator> codec() {
        return MapCodec.unit(null);
    }

    @NotNull
    public CompletableFuture<ChunkAccess> createBiomes(RandomState randomstate, Blender blender, StructureManager structuremanager, @NotNull ChunkAccess ChunkAccess2) {
        return CompletableFuture.supplyAsync(() -> ChunkAccess2, Util.backgroundExecutor().forName("init_biomes"));
    }

    public Pair<BlockPos, Holder<Structure>> findNearestMapStructure(ServerLevel ServerLevel2, @NotNull HolderSet<Structure> holderset, @NotNull BlockPos BlockPos2, int i, boolean flag) {
        int pX = BlockPos2.getX();
        int pZ = BlockPos2.getZ();
        for (Holder holder : holderset) {
            Structure feature = (Structure)holder.value();
            TerraformGeneratorPlugin.logger.info("Vanilla locate for " + feature.getClass().getName() + " invoked.");
            if (((Structure)holder.value()).getClass() == StrongholdStructure.class) {
                int[] coords = new StrongholdPopulator().getNearestFeature(this.tw, pX, pZ);
                return new Pair((Object)new BlockPos(coords[0], 20, coords[1]), (Object)holder);
            }
            if (TConfig.c.DEVSTUFF_VANILLA_LOCATE_DISABLE) continue;
            if (((Structure)holder.value()).getClass() == OceanMonumentStructure.class) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MonumentPopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
                return new Pair((Object)new BlockPos(coords[0], 50, coords[1]), (Object)holder);
            }
            if (((Structure)holder.value()).getClass() == WoodlandMansionStructure.class) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MansionPopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
                return new Pair((Object)new BlockPos(coords[0], 50, coords[1]), (Object)holder);
            }
            if (holder.value() instanceof JigsawStructure && ((Registry)MinecraftServer.getServer().registryAccess().lookup(Registries.STRUCTURE).orElseThrow()).getValue(ResourceLocation.parse((String)"trial_chambers")) == holder.value()) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new TrialChamberPopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
                return new Pair((Object)new BlockPos(coords[0], 50, coords[1]), (Object)holder);
            }
            if (((Structure)holder.value()).getClass() != BuriedTreasureStructure.class) continue;
            int[] coords = StructureLocator.locateMultiMegaChunkStructure(this.tw, new MegaChunk(pX, 0, pZ), new BuriedTreasurePopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
            if (coords == null) {
                return null;
            }
            return new Pair((Object)new BlockPos(coords[0], 50, coords[1]), (Object)holder);
        }
        return null;
    }

    public void applyBiomeDecoration(WorldGenLevel worldGenLevel, ChunkAccess ChunkAccess2, StructureManager structuremanager) {
        this.delegate.applyBiomeDecoration(worldGenLevel, ChunkAccess2, structuremanager);
        this.addVanillaDecorations(worldGenLevel, ChunkAccess2, structuremanager);
    }

    public void addVanillaDecorations(WorldGenLevel worldGenLevel, ChunkAccess chunkAccess, StructureManager structuremanager) {
        ChunkPos ChunkPos2 = chunkAccess.getPos();
        if (!SharedConstants.debugVoidTerrain((ChunkPos)ChunkPos2)) {
            SectionPos sectionPos = SectionPos.of((ChunkPos)ChunkPos2, (int)worldGenLevel.getMinSectionY());
            BlockPos BlockPos2 = sectionPos.origin();
            Registry iregistry = worldGenLevel.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            Map<Integer, List<Structure>> map = iregistry.stream().collect(Collectors.groupingBy(structurex -> structurex.step().ordinal()));
            List list = (List)this.featuresPerStep.get();
            WorldgenRandom seededrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
            long i = seededrandom.setDecorationSeed(worldGenLevel.getSeed(), BlockPos2.getX(), BlockPos2.getZ());
            ObjectArraySet set = new ObjectArraySet();
            ChunkPos.rangeClosed((ChunkPos)sectionPos.chunk(), (int)1).forEach(arg_0 -> NMSChunkGenerator.lambda$addVanillaDecorations$2(worldGenLevel, (Set)set, arg_0));
            set.retainAll(this.biomeSource.possibleBiomes());
            int j = list.size();
            try {
                Registry iregistry1 = worldGenLevel.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE);
                int k = Math.max(GenerationStep.Decoration.values().length, j);
                for (int l = 0; l < k; ++l) {
                    int i1 = 0;
                    if (!structuremanager.shouldGenerateStructures()) continue;
                    for (Structure structure : map.getOrDefault(l, Collections.emptyList())) {
                        seededrandom.setFeatureSeed(i, i1, l);
                        Supplier<String> supplier = () -> {
                            Optional<String> optional = iregistry.getResourceKey((Object)structure).map(Object::toString);
                            Objects.requireNonNull(structure);
                            return (String)optional.orElseGet(structure::toString);
                        };
                        try {
                            worldGenLevel.setCurrentlyGenerating(supplier);
                            structuremanager.startsForStructure(sectionPos, structure).forEach(structurestart -> {
                                try {
                                    structurestart.placeInChunk(worldGenLevel, structuremanager, (ChunkGenerator)this, (RandomSource)seededrandom, (BoundingBox)this.getWriteableArea.method.invoke(null, chunkAccess), ChunkPos2);
                                }
                                catch (IllegalAccessException | InvocationTargetException e2) {
                                    CrashReport crashreport = CrashReport.forThrowable((Throwable)e2, (String)"TerraformGenerator");
                                    throw new ReportedException(crashreport);
                                }
                            });
                        }
                        catch (Exception var31) {
                            CrashReport crashreport = CrashReport.forThrowable((Throwable)var31, (String)"Feature placement");
                            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Feature");
                            Objects.requireNonNull(supplier);
                            crashreportsystemdetails.setDetail("Description", supplier::get);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
                worldGenLevel.setCurrentlyGenerating((Supplier)null);
                if (SharedConstants.DEBUG_FEATURE_COUNT) {
                    FeatureCountTracker.chunkDecorated((ServerLevel)worldGenLevel.getLevel());
                }
            }
            catch (Exception var32) {
                CrashReport crashreport2 = CrashReport.forThrowable((Throwable)var32, (String)"Biome decoration");
                crashreport2.addCategory("Generation").setDetail("CenterX", (Object)ChunkPos2.x).setDetail("CenterZ", (Object)ChunkPos2.z).setDetail("Decoration Seed", (Object)i);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void applyCarvers(WorldGenRegion worldGenRegion, long seed, RandomState randomstate, BiomeManager biomemanager, StructureManager structuremanager, @NotNull ChunkAccess chunkAccess) {
        chunkAccess.fillBiomesFromNoise((BiomeResolver)this.twBS, null);
        this.delegate.applyCarvers(worldGenRegion, seed, randomstate, biomemanager, structuremanager, chunkAccess);
    }

    public int getGenDepth() {
        return this.delegate.getGenDepth();
    }

    public void createStructures(RegistryAccess registryAccess, @NotNull ChunkGeneratorStructureState chunkgeneratorstructurestate, StructureManager structuremanager, @NotNull ChunkAccess ChunkAccess2, StructureTemplateManager structuretemplatemanager, ResourceKey<Level> resourcekey) {
        ChunkPos ChunkPos2 = ChunkAccess2.getPos();
        SectionPos sectionPos = SectionPos.bottomOf((ChunkAccess)ChunkAccess2);
        RandomState randomstate = chunkgeneratorstructurestate.randomState();
        MegaChunk mc = new MegaChunk(ChunkPos2.x, ChunkPos2.z);
        SingleMegaChunkStructurePopulator[] spops = StructureRegistry.getLargeStructureForMegaChunk(this.tw, mc);
        int[] centerCoords = mc.getCenterBiomeSectionChunkCoords();
        if (spops == null) {
            return;
        }
        for (SingleMegaChunkStructurePopulator pop : spops) {
            if (!(pop instanceof VanillaStructurePopulator)) continue;
            VanillaStructurePopulator vpop = (VanillaStructurePopulator)pop;
            this.possibleStructureSets.stream().filter(resourceLoc -> vpop.structureRegistryKey.equals(resourceLoc.getPath())).map(resourceLoc -> (StructureSet)((Registry)MinecraftServer.getServer().registryAccess().lookup(Registries.STRUCTURE_SET).orElseThrow()).getValue(resourceLoc)).forEach(structureSet -> {
                StructurePlacement structureplacement = structureSet.placement();
                List list = structureSet.structures();
                if (centerCoords[0] == ChunkPos2.x && centerCoords[1] == ChunkPos2.z) {
                    try {
                        Object retVal = this.tryGenerateStructure.method.invoke((Object)this, list.getFirst(), structuremanager, registryAccess, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.getLevelSeed(), ChunkAccess2, ChunkPos2, sectionPos, resourcekey);
                        TerraformGeneratorPlugin.logger.info(ChunkPos2.x + "," + ChunkPos2.z + " will spawn a vanilla structure, with tryGenerateStructure == " + String.valueOf(retVal));
                    }
                    catch (Throwable t) {
                        TerraformGeneratorPlugin.logger.info(ChunkPos2.x + "," + ChunkPos2.z + " Failed to generate a vanilla structure");
                        TerraformGeneratorPlugin.logger.stackTrace(t);
                    }
                }
            });
        }
    }

    public void createReferences(WorldGenLevel gas, StructureManager manager, ChunkAccess ica) {
        this.delegate.createReferences(gas, manager, ica);
    }

    public int getSpawnHeight(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomstate, StructureManager structuremanager, ChunkAccess ChunkAccess2) {
        return this.delegate.fillFromNoise(blender, randomstate, structuremanager, ChunkAccess2);
    }

    public void buildSurface(WorldGenRegion worldGenRegion, StructureManager structuremanager, RandomState randomstate, ChunkAccess ChunkAccess2) {
        this.delegate.buildSurface(worldGenRegion, structuremanager, randomstate, ChunkAccess2);
    }

    public NoiseColumn getBaseColumn(int i, int j, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.delegate.getBaseColumn(i, j, levelheightaccessor, randomstate);
    }

    public void spawnOriginalMobs(WorldGenRegion WorldGenRegion2) {
        this.delegate.spawnOriginalMobs(WorldGenRegion2);
    }

    public int getSeaLevel() {
        return TerraformGenerator.seaLevel;
    }

    public int getMinY() {
        return this.delegate.getMinY();
    }

    public int getFirstFreeHeight(int i, int j, Heightmap.Types heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.getFirstFreeHeight(i, j, heightmap_type, levelheightaccessor, randomstate);
    }

    public int getFirstOccupiedHeight(int i, int j, Heightmap.Types heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.getFirstOccupiedHeight(i, j, heightmap_type, levelheightaccessor, randomstate) - 1;
    }

    public int getBaseHeight(int i, int j, Heightmap.Types heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return 100;
    }

    public void addDebugScreenInfo(List<String> list, RandomState randomstate, BlockPos BlockPos2) {
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$2(WorldGenLevel worldGenLevel, Set set, ChunkPos ChunkPos1) {
        ChunkAccess ichunkaccess1 = worldGenLevel.getChunk(ChunkPos1.x, ChunkPos1.z);
        for (LevelChunkSection chunksection : ichunkaccess1.getSections()) {
            PalettedContainerRO palettedcontainerro = chunksection.getBiomes();
            Objects.requireNonNull(set);
            palettedcontainerro.getAll(set::add);
        }
    }
}

