/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_21_R6;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.jetbrains.annotations.Nullable;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_21_R6.CustomBiomeHandler;

public class TerraformWorldProviderBiome
extends BiomeSource {
    private static final boolean debug = false;
    private final TerraformWorld tw;
    private final Registry<net.minecraft.world.level.biome.Biome> registry;
    private final Set<Holder<net.minecraft.world.level.biome.Biome>> biomeList = CustomBiomeHandler.biomeListToBiomeSet(CustomBiomeHandler.getBiomeRegistry());

    public TerraformWorldProviderBiome(TerraformWorld tw, BiomeSource delegate) {
        this.tw = tw;
        this.registry = CustomBiomeHandler.getBiomeRegistry();
    }

    public Stream<Holder<net.minecraft.world.level.biome.Biome>> collectPossibleBiomes() {
        return this.biomeList.stream();
    }

    public Set<Holder<net.minecraft.world.level.biome.Biome>> possibleBiomes() {
        return this.biomeList;
    }

    protected MapCodec<? extends BiomeSource> codec() {
        throw new UnsupportedOperationException("Cannot serialize TerraformWorldProviderBiome");
    }

    @Nullable
    public Holder<net.minecraft.world.level.biome.Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler arg3) {
        BiomeBank bank = this.tw.getBiomeBank(x << 2, z << 2);
        if (bank.getHandler().getCustomBiome() == CustomBiomeType.NONE) {
            return CraftBiome.bukkitToMinecraftHolder((Biome)bank.getHandler().getBiome());
        }
        ResourceKey<net.minecraft.world.level.biome.Biome> rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)bank.getHandler().getCustomBiome());
        Optional holder = this.registry.get(rkey);
        if (holder.isEmpty()) {
            TerraformGeneratorPlugin.logger.error("Custom biome was not found in the vanilla registry!");
        }
        if (holder.isPresent()) {
            return (Holder)holder.get();
        }
        return CraftBiome.bukkitToMinecraftHolder((Biome)bank.getHandler().getBiome());
    }
}

