/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.beach;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.MushroomBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class MushroomBeachHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.MUSHROOM_FIELDS;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{Material.MYCELIUM, Material.DIRT, GenUtils.randChoice(rand, new Material[]{Material.STONE, Material.DIRT, Material.DIRT}), GenUtils.randChoice(rand, new Material[]{Material.STONE, Material.DIRT})};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        if (surfaceY < TerraformGenerator.seaLevel) {
            return;
        }
        if (BlockUtils.isDirtLike(data.getType(rawX, surfaceY, rawZ)) && BlockUtils.isAir(data.getType(rawX, surfaceY + 1, rawZ)) && GenUtils.chance(1, 60)) {
            PlantBuilder.build(data, rawX, surfaceY + 1, rawZ, PlantBuilder.RED_MUSHROOM, PlantBuilder.BROWN_MUSHROOM);
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        int choice;
        int treeY;
        SimpleLocation[] bigTrees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 33, 0.15f);
        SimpleLocation[] smallDecorations = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 15, 0.3f);
        for (SimpleLocation sLoc : bigTrees) {
            FractalTypes.Mushroom type;
            treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            choice = random.nextInt(3);
            switch (choice) {
                case 0: {
                    FractalTypes.Mushroom mushroom = FractalTypes.Mushroom.GIANT_RED_MUSHROOM;
                    break;
                }
                case 1: {
                    FractalTypes.Mushroom mushroom = FractalTypes.Mushroom.GIANT_BROWN_MUSHROOM;
                    break;
                }
                default: {
                    FractalTypes.Mushroom mushroom = type = FractalTypes.Mushroom.GIANT_BROWN_FUNNEL_MUSHROOM;
                }
            }
            if (!(HeightMap.getTrueHeightGradient(data, sLoc.getX(), sLoc.getZ(), 3) <= TConfig.c.MISC_TREES_GRADIENT_LIMIT)) continue;
            new MushroomBuilder(type).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
        block10: for (SimpleLocation sLoc : smallDecorations) {
            treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(treeY)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            choice = random.nextInt(4);
            switch (choice) {
                case 0: {
                    new MushroomBuilder(FractalTypes.Mushroom.SMALL_POINTY_RED_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                    continue block10;
                }
                case 1: {
                    new MushroomBuilder(FractalTypes.Mushroom.SMALL_BROWN_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                    continue block10;
                }
                case 2: {
                    new MushroomBuilder(FractalTypes.Mushroom.SMALL_RED_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                    continue block10;
                }
                default: {
                    new MushroomBuilder(FractalTypes.Mushroom.TINY_RED_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                }
            }
        }
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; x += 2) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; z += 2) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || y < TerraformGenerator.seaLevel + 4 || !(HeightMap.getTrueHeightGradient(data, x, z, 3) > 2.0) || !GenUtils.chance(random, 1, 20)) continue;
                BlockUtils.replaceCircle(random.nextInt(919292), 3.0f, new SimpleBlock(data, x, y - 2, z), GenUtils.randChoice(random, new Material[]{Material.BROWN_MUSHROOM_BLOCK, Material.RED_MUSHROOM_BLOCK}));
            }
        }
    }
}

