/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfig;
import org.terraform.small_items.PlantBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class ForestHandler
extends BiomeHandler {
    protected static void spawnRock(@NotNull Random rand, @NotNull PopulatorDataAbstract data, int x, int y, int z) {
        ArrayList<int[]> locations = new ArrayList<int[]>(20);
        locations.add(new int[]{x, y, z});
        locations.add(new int[]{x, y + 1, z});
        locations.add(new int[]{x + 1, y + 1, z});
        locations.add(new int[]{x - 1, y + 1, z});
        locations.add(new int[]{x, y + 1, z + 1});
        locations.add(new int[]{x, y + 1, z - 1});
        locations.add(new int[]{x + 1, y, z});
        locations.add(new int[]{x - 1, y, z});
        locations.add(new int[]{x, y, z + 1});
        locations.add(new int[]{x, y, z - 1});
        locations.add(new int[]{x + 1, y, z});
        locations.add(new int[]{x - 1, y, z + 1});
        locations.add(new int[]{x + 1, y, z + 1});
        locations.add(new int[]{x - 1, y, z - 1});
        locations.add(new int[]{x, y - 1, z});
        locations.add(new int[]{x + 1, y - 1, z});
        locations.add(new int[]{x - 1, y - 1, z});
        locations.add(new int[]{x, y - 1, z + 1});
        locations.add(new int[]{x, y - 1, z - 1});
        for (int[] coords : locations) {
            int Tz;
            int Ty;
            int Tx = coords[0];
            if (data.getType(Tx, Ty = coords[1], Tz = coords[2]).isSolid() && !data.getType(Tx, Ty, Tz).toString().contains("LEAVES")) continue;
            data.setType(Tx, Ty, Tz, GenUtils.randChoice(rand, new Material[]{Material.COBBLESTONE, Material.STONE, Material.MOSSY_COBBLESTONE}));
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.FOREST;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{GenUtils.weightedRandomMaterial(rand, Material.GRASS_BLOCK, 35, Material.PODZOL, 3), Material.DIRT, Material.DIRT, GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.DIRT, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        FastNoise pathNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_FOREST_PATHNOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 12L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.07f);
            return n;
        });
        if ((double)pathNoise.GetNoise(rawX, rawZ) > 0.3 && GenUtils.chance(random, 99, 100) && data.getBiome(rawX, rawZ) == this.getBiome() && BlockUtils.isDirtLike(data.getType(rawX, surfaceY, rawZ))) {
            data.setType(rawX, surfaceY, rawZ, Material.DIRT_PATH);
        }
        if (data.getType(rawX, surfaceY, rawZ) == Material.GRASS_BLOCK && GenUtils.chance(random, 1, 10)) {
            switch (random.nextInt(4)) {
                case 0: {
                    PlantBuilder.GRASS.build(data, rawX, surfaceY + 1, rawZ);
                    break;
                }
                case 1: {
                    PlantBuilder.TALL_GRASS.build(data, rawX, surfaceY + 1, rawZ);
                    break;
                }
                case 2: {
                    BlockUtils.pickFlower().build(data, rawX, surfaceY + 1, rawZ);
                    break;
                }
                case 3: {
                    PlantBuilder.BUSH.build(data, rawX, surfaceY + 1, rawZ);
                }
            }
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] rocks;
        SimpleLocation[] trees;
        int treeY;
        int treeZ;
        int treeX;
        if (TConfig.c.TREES_FOREST_BIG_ENABLED && GenUtils.chance(random, 6, 10) && data.getBiome(treeX = GenUtils.randInt(random, 2, 12) + data.getChunkX() * 16, treeZ = GenUtils.randInt(random, 2, 12) + data.getChunkZ() * 16) == this.getBiome() && BlockUtils.isDirtLike(data.getType(treeX, treeY = GenUtils.getHighestGround(data, treeX, treeZ), treeZ))) {
            FractalTypes.Tree.FOREST.build(tw, new SimpleBlock(data, treeX, treeY, treeZ));
        }
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 8)) {
            int treeY2 = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (data.getBiome((sLoc = sLoc.getAtY(treeY2)).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            if (random.nextInt(7) == 0) {
                Wall w = new Wall(data, sLoc.getUp(), BlockUtils.getDirectBlockFace(random));
                int length = GenUtils.randInt(2, 3);
                for (int i = -length; i <= length && w.getFront(i).isAir() && w.getFront(i).getDown().isSolid(); ++i) {
                    w.getFront(i).setBlockData((BlockData)new OrientableBuilder(Material.OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(w.getDirection())).get());
                    if (!w.getFront(i).getUp().isAir() || random.nextInt(5) != 0) continue;
                    PlantBuilder.build(w.getFront(i).getUp(), PlantBuilder.RED_MUSHROOM, PlantBuilder.BROWN_MUSHROOM);
                }
                continue;
            }
            FractalTypes.Tree.NORMAL_SMALL.build(tw, new SimpleBlock(data, sLoc.getX(), sLoc.getY(), sLoc.getZ()));
        }
        for (SimpleLocation sLoc : rocks = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 10)) {
            if (data.getBiome((sLoc = sLoc.getAtY(GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ()))).getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ())) && data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.COBBLESTONE && data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.MOSSY_COBBLESTONE && data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.STONE) continue;
            int ny = GenUtils.randInt(random, -1, 1);
            ForestHandler.spawnRock(random, data, sLoc.getX(), sLoc.getY() + ny, sLoc.getZ());
            if (!GenUtils.chance(random, 1, 3)) continue;
            ForestHandler.spawnRock(random, data, GenUtils.randInt(random, -1, 1) + sLoc.getX(), sLoc.getY() + ny + 1, sLoc.getZ() + GenUtils.randInt(random, -1, 1));
        }
    }
}

