/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class DesertHillsHandler
extends AbstractMountainHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    protected double getPeakMultiplier(@NotNull BiomeSection section, @NotNull Random sectionRandom) {
        return GenUtils.randDouble(sectionRandom, 1.1, 1.3);
    }

    @Override
    @NotNull
    public Biome getBiome() {
        return Biome.DESERT;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{Material.SAND, Material.SAND, GenUtils.randChoice(rand, new Material[]{Material.SANDSTONE, Material.SAND}), GenUtils.randChoice(rand, new Material[]{Material.SANDSTONE, Material.SAND}), GenUtils.randChoice(rand, new Material[]{Material.SANDSTONE, Material.SAND}), Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, GenUtils.randChoice(rand, new Material[]{Material.SANDSTONE, Material.SAND, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.SANDSTONE, Material.STONE})};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        FastNoise duneNoise = NoiseCacheHandler.getNoise(world, NoiseCacheHandler.NoiseCacheEntry.BIOME_DESERT_DUNENOISE, tw -> {
            FastNoise n = new FastNoise((int)tw.getSeed());
            n.SetNoiseType(FastNoise.NoiseType.CubicFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.03f);
            return n;
        });
        int y = surfaceY;
        while ((double)y > HeightMap.CORE.getHeight(world, rawX, rawZ)) {
            if (duneNoise.GetNoise(rawX, y, rawZ) > 0.0f) {
                if (data.getType(rawX, y, rawZ) == Material.SAND || data.getType(rawX, y, rawZ) == Material.RED_SAND) {
                    if (TConfig.c.BIOME_DESERT_MOUNTAINS_YELLOW_CONCRETE_POWDER) {
                        data.setType(rawX, y, rawZ, Material.YELLOW_CONCRETE_POWDER);
                    }
                } else if ((data.getType(rawX, y, rawZ) == Material.SANDSTONE || data.getType(rawX, y, rawZ) == Material.RED_SANDSTONE) && TConfig.c.BIOME_DESERT_MOUNTAINS_YELLOW_CONCRETE) {
                    data.setType(rawX, y, rawZ, Material.YELLOW_CONCRETE);
                }
            }
            --y;
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
    }
}

