/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.ocean;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeType;
import org.terraform.biome.ocean.AbstractOceanHandler;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;

public class OceansHandler
extends AbstractOceanHandler {
    public OceansHandler(BiomeType oceanType) {
        super(oceanType);
    }

    @Override
    public boolean isOcean() {
        return true;
    }

    @Override
    @NotNull
    public Biome getBiome() {
        if (this.oceanType == BiomeType.DEEP_OCEANIC) {
            return Biome.DEEP_OCEAN;
        }
        return Biome.OCEAN;
    }

    @Override
    public Material @NotNull [] getSurfaceCrust(@NotNull Random rand) {
        return new Material[]{Material.GRAVEL, Material.GRAVEL, GenUtils.randChoice(rand, new Material[]{Material.STONE, Material.GRAVEL, Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.STONE}), GenUtils.randChoice(rand, new Material[]{Material.STONE})};
    }

    @Override
    public void populateSmallItems(@NotNull TerraformWorld world, @NotNull Random random, int rawX, int surfaceY, int rawZ, @NotNull PopulatorDataAbstract data) {
        boolean growsKelp = world.getHashedRand(rawX >> 4, rawZ >> 4, 371412).nextBoolean();
        if (surfaceY >= TerraformGenerator.seaLevel - 2) {
            data.setType(rawX, surfaceY, rawZ, Material.SAND);
        } else if (surfaceY >= TerraformGenerator.seaLevel - 4 && random.nextBoolean()) {
            data.setType(rawX, surfaceY, rawZ, Material.SAND);
        }
        if (!BlockUtils.isStoneLike(data.getType(rawX, surfaceY, rawZ))) {
            return;
        }
        if (GenUtils.chance(random, 10, 100)) {
            CoralGenerator.generateKelpGrowth(data, rawX, surfaceY + 1, rawZ);
        } else if (GenUtils.chance(random, 3, 50) && growsKelp && surfaceY + 1 < TerraformGenerator.seaLevel - 10) {
            this.generateKelp(rawX, surfaceY + 1, rawZ, data, random);
        }
    }

    private void generateKelp(int x, int y, int z, @NotNull PopulatorDataAbstract data, Random random) {
        for (int ny = y; ny < TerraformGenerator.seaLevel - GenUtils.randInt(5, 15); ++ny) {
            data.setType(x, ny, z, Material.KELP_PLANT);
        }
    }

    @Override
    public void populateLargeItems(@NotNull TerraformWorld tw, @NotNull Random random, @NotNull PopulatorDataAbstract data) {
        SimpleLocation[] rocks;
        for (SimpleLocation sLoc : rocks = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 25, 0.4f)) {
            int rockY;
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || data.getType((sLoc = sLoc.getAtY(rockY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ()))).getX(), sLoc.getY(), sLoc.getZ()) != Material.GRAVEL) continue;
            BlockUtils.replaceSphere(random.nextInt(9987), (float)GenUtils.randDouble(random, 3.0, 7.0), (float)GenUtils.randDouble(random, 2.0, 4.0), (float)GenUtils.randDouble(random, 3.0, 7.0), new SimpleBlock(data, sLoc), true, GenUtils.randChoice(Material.STONE, Material.GRANITE, Material.ANDESITE, Material.DIORITE));
        }
    }
}

