/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command;

import java.util.ArrayList;
import java.util.Stack;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.terraform.command.contants.TerraCommand;
import org.terraform.command.contants.TerraCommandArgument;
import org.terraform.main.TerraformCommandManager;
import org.terraform.main.TerraformGeneratorPlugin;

public class HelpCommand
extends TerraCommand {
    private final TerraformCommandManager man;

    public HelpCommand(TerraformGeneratorPlugin plugin, TerraformCommandManager man, String ... string) {
        super(plugin, string);
        this.man = man;
    }

    @Override
    public boolean isInAcceptedParamRange(@NotNull Stack<String> args) {
        return args.size() <= 1;
    }

    @Override
    public boolean canConsoleExec() {
        return true;
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return true;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Stack<String> args) {
        ArrayList<TerraCommand> cmds = new ArrayList<TerraCommand>();
        for (TerraCommand cmd : this.man.getCommands()) {
            if (!cmd.hasPermission(sender)) continue;
            cmds.add(cmd);
        }
        int maxPages = (int)((double)(cmds.size() / 6));
        int page = 0;
        if (!args.isEmpty()) {
            try {
                page = Integer.parseInt(args.pop());
                if (page <= 0) {
                    sender.sendMessage(this.plugin.getLang().fetchLang("command.help.postive-pages"));
                    return;
                }
                --page;
            }
            catch (NumberFormatException e2) {
                sender.sendMessage(this.plugin.getLang().fetchLang("command.help.postive-pages"));
                return;
            }
        }
        if (page > maxPages) {
            page = maxPages;
        }
        String base = this.man.bases.get(0);
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "============[" + String.valueOf(ChatColor.AQUA) + this.plugin.getName() + String.valueOf(ChatColor.GOLD) + "][" + String.valueOf(ChatColor.YELLOW) + "Pg. " + (page + 1) + String.valueOf(ChatColor.GOLD) + "]============");
        sender.sendMessage("");
        for (int i = 0; i < 6; ++i) {
            if (cmds.size() <= page * 5 + i) continue;
            TerraCommand cmd = (TerraCommand)cmds.get(page * 5 + i);
            StringBuilder params = new StringBuilder();
            params.append(ChatColor.YELLOW).append("/").append(base).append(" ").append(String.join((CharSequence)"/", cmd.aliases)).append(' ');
            for (TerraCommandArgument<?> param : cmd.parameters) {
                if (param.isOptional()) {
                    params.append(ChatColor.GRAY).append("<").append(param.getName()).append("> ");
                    continue;
                }
                params.append(ChatColor.AQUA).append("[").append(param.getName()).append("] ");
            }
            params.append(ChatColor.DARK_GRAY).append("- ").append(ChatColor.YELLOW).append(this.plugin.getLang().fetchLang(cmd.getLangPath()));
            sender.sendMessage(params.toString());
        }
        sender.sendMessage("");
        if (page != maxPages) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "/" + base + " h " + (page + 2) + String.valueOf(ChatColor.DARK_GRAY) + "- " + String.valueOf(ChatColor.YELLOW) + (page + 1) + "/" + (maxPages + 1));
        } else {
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + (page + 1) + "/" + (maxPages + 1));
        }
    }

    @Override
    @NotNull
    public String getDefaultDescription() {
        return "Displays a list of commands for this plugin.";
    }
}

