/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Stack;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeType;
import org.terraform.command.contants.InvalidArgumentException;
import org.terraform.command.contants.TerraCommand;
import org.terraform.command.contants.TerraCommandArgument;
import org.terraform.data.TerraformWorld;
import org.terraform.main.LangOpt;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.GenUtils;
import org.terraform.utils.Vector2f;

public class LocateBiomeCommand
extends TerraCommand {
    public LocateBiomeCommand(TerraformGeneratorPlugin plugin, String ... aliases) {
        super(plugin, aliases);
        this.parameters.add(new LocateBiomeTypeArgument("biomeType", false));
    }

    @Override
    @NotNull
    public String getDefaultDescription() {
        return "Tries to locate a certain biome";
    }

    @Override
    public boolean canConsoleExec() {
        return false;
    }

    @Override
    public boolean hasPermission(@NotNull CommandSender sender) {
        return sender.isOp() || sender.hasPermission("terraformgenerator.locatebiome");
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Stack<String> args) throws InvalidArgumentException {
        Player p = (Player)sender;
        if (!args.isEmpty()) {
            try {
                new Task(p.getUniqueId(), TerraformWorld.get(p.getWorld()), p.getLocation().getBlockX(), p.getLocation().getBlockZ(), (BiomeBank)((Object)this.parseArguments(sender, args).get(0))).runTaskAsynchronously((Plugin)TerraformGeneratorPlugin.get());
            }
            catch (IllegalArgumentException e2) {
                sender.sendMessage(LangOpt.COMMAND_LOCATEBIOME_INVALIDBIOME.parse(new String[0]));
                StringBuilder types = new StringBuilder();
                boolean b2 = true;
                for (BiomeBank type : BiomeBank.values()) {
                    ChatColor col = ChatColor.RED;
                    if (b2) {
                        col = ChatColor.DARK_RED;
                    }
                    b2 = !b2;
                    types.append(col).append((Object)type).append(' ');
                }
                sender.sendMessage(types.toString());
            }
        }
    }

    private void syncSendMessage(UUID uuid, String msg) {
        super.syncSendMessage(uuid, "Locate Biome", msg);
    }

    private void syncSendMessage(UUID uuid, String msg, int x, int y, int z) {
        super.syncSendMessageTP(uuid, "Locate Biome", msg, x, y, z);
    }

    private static class LocateBiomeTypeArgument
    extends TerraCommandArgument<BiomeBank> {
        public LocateBiomeTypeArgument(String name, boolean isOptional) {
            super(name, isOptional);
        }

        @Override
        @NotNull
        public BiomeBank parse(CommandSender sender, @NotNull String value) {
            return BiomeBank.valueOf(value.toUpperCase(Locale.ENGLISH));
        }

        @Override
        @NotNull
        public String validate(CommandSender sender, @NotNull String value) {
            try {
                this.parse(sender, value);
            }
            catch (IllegalArgumentException e2) {
                return "That biome type does not exist!";
            }
            return "";
        }

        @Override
        @NotNull
        public ArrayList<String> getTabOptions(String @NotNull [] args) {
            if (args.length != 2) {
                return new ArrayList<String>();
            }
            ArrayList<String> values = new ArrayList<String>();
            for (BiomeBank bank : BiomeBank.values()) {
                if (!bank.name().startsWith(args[1].toUpperCase(Locale.ENGLISH))) continue;
                values.add(bank.name());
            }
            return values;
        }
    }

    private class Task
    extends BukkitRunnable {
        final UUID p;
        final BiomeBank b;
        final TerraformWorld tw;
        final int x;
        final int z;

        public Task(UUID player, TerraformWorld tw, int x, int z, BiomeBank targetBiome) {
            this.p = player;
            this.b = targetBiome;
            this.tw = tw;
            this.x = x;
            this.z = z;
        }

        public void run() {
            Vector2f location;
            if (this.b.getType() == BiomeType.BEACH || this.b.getType() == BiomeType.RIVER) {
                location = GenUtils.locateHeightDependentBiome(this.tw, this.b, new Vector2f(this.x, this.z), 5000, 25);
                if (location == null) {
                    LocateBiomeCommand.this.syncSendMessage(this.p, LangOpt.COMMAND_LOCATEBIOME_NOT_IN_5000.parse(new String[0]));
                }
            } else {
                location = GenUtils.locateHeightIndependentBiome(this.tw, this.b, new Vector2f(this.x, this.z));
            }
            if (location != null) {
                int x = (int)location.x;
                int z = (int)location.y;
                String message = LangOpt.COMMAND_LOCATE_LOCATE_COORDS.parse("%x%", "" + x, "%z%", "" + z);
                LocateBiomeCommand.this.syncSendMessage(this.p, message, x, LocateBiomeCommand.this.getHighestY(this.tw, x, z), z);
            } else {
                LocateBiomeCommand.this.syncSendMessage(this.p, LangOpt.COMMAND_LOCATEBIOME_DISABLED.parse(new String[0]));
            }
        }
    }
}

