/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen;

import java.util.HashMap;
import org.terraform.biome.BiomeSection;
import org.terraform.coregen.HeightMap;
import org.terraform.data.CoordPair;

public record SectionBlurCache(BiomeSection sect, float[][] intermediate, float[][] blurred) {
    public void fillCache() {
        float lineTotalHeight;
        int arrIdZ;
        int arrIdX;
        int relZ;
        int relX;
        HashMap<CoordPair, Float> dominantBiomeHeights = new HashMap<CoordPair, Float>();
        for (relX = this.sect.getLowerBounds().getX() - 5; relX <= this.sect.getUpperBounds().getX() + 5; ++relX) {
            for (relZ = this.sect.getLowerBounds().getZ() - 5; relZ <= this.sect.getUpperBounds().getZ() + 5; ++relZ) {
                arrIdX = relX - (this.sect.getLowerBounds().getX() - 5);
                arrIdZ = relZ - (this.sect.getLowerBounds().getZ() - 5);
                lineTotalHeight = 0.0f;
                for (int offsetX = -5; offsetX <= 5; ++offsetX) {
                    lineTotalHeight += HeightMap.getDominantBiomeHeight(this.sect.getTw(), relX + offsetX, relZ, dominantBiomeHeights);
                }
                this.intermediate[arrIdX][arrIdZ] = lineTotalHeight;
            }
        }
        for (relX = this.sect.getLowerBounds().getX(); relX <= this.sect.getUpperBounds().getX(); ++relX) {
            for (relZ = this.sect.getLowerBounds().getZ(); relZ <= this.sect.getUpperBounds().getZ(); ++relZ) {
                arrIdX = relX - (this.sect.getLowerBounds().getX() - 5);
                arrIdZ = relZ - (this.sect.getLowerBounds().getZ() - 5);
                lineTotalHeight = 0.0f;
                for (int offsetZ = -5; offsetZ <= 5; ++offsetZ) {
                    int querIdZ = relZ + offsetZ - (this.sect.getLowerBounds().getZ() - 5);
                    lineTotalHeight += this.intermediate[arrIdX][querIdZ];
                }
                this.blurred[arrIdX][arrIdZ] = lineTotalHeight / 121.0f;
            }
        }
    }

    public float getBlurredHeight(int blockX, int blockZ) {
        int arrIdX = blockX - (this.sect.getLowerBounds().getX() - 5);
        int arrIdZ = blockZ - (this.sect.getLowerBounds().getZ() - 5);
        return this.blurred[arrIdX][arrIdZ];
    }

    @Override
    public int hashCode() {
        return this.sect.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SectionBlurCache) {
            SectionBlurCache s = (SectionBlurCache)o;
            return s.sect.equals(this.sect);
        }
        return false;
    }
}

