/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.main;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;

public class LanguageManager {
    private final File file;
    @NotNull
    private final HashMap<String, String> cache = new HashMap();
    private FileConfiguration langFile;

    public LanguageManager(@NotNull TerraformGeneratorPlugin plugin, @NotNull TConfig config) {
        this.file = new File(plugin.getDataFolder(), config.LANGUAGE_FILE);
        this.reloadLangFile();
        this.loadDefaults();
    }

    private void loadDefaults() {
        this.fetchLang("permissions.insufficient", "&cYou don't have enough permissions to perform this action!");
        this.fetchLang("command.wrong-arg-length", "&cToo many or too little arguments provided!");
        this.fetchLang("command.unknown", "&cUnknown subcommand.");
        this.fetchLang("command.help.postive-pages", "&cThe page specified must be a positive number!");
        this.fetchLang("permissions.console-cannot-exec", "&cOnly players can execute this command.");
    }

    public String fetchLang(@NotNull String langKey) {
        return this.fetchLang(langKey, null);
    }

    public String fetchLang(@NotNull String langKey, @Nullable String def) {
        if (this.cache.containsKey(langKey)) {
            return this.cache.get(langKey);
        }
        String value = this.langFile.getString(langKey);
        if (value == null) {
            value = def == null ? langKey : def;
            this.langFile.set(langKey, (Object)value);
            this.saveLangFile();
        }
        value = ChatColor.translateAlternateColorCodes((char)'&', (String)value);
        this.cache.put(langKey, value);
        return value;
    }

    public void saveLangFile() {
        try {
            this.langFile.save(this.file);
        }
        catch (IOException e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
        }
    }

    public void reloadLangFile() {
        this.cache.clear();
        this.langFile = YamlConfiguration.loadConfiguration((File)this.file);
    }
}

