/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.spigot.v1_21_R6;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.FeatureCountTracker;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdStructure;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.spigot.v1_21_R6.MapRenderWorldProviderBiome;
import org.terraform.spigot.v1_21_R6.TerraformWorldProviderBiome;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.StructureLocator;
import org.terraform.structure.StructurePopulator;
import org.terraform.structure.StructureRegistry;
import org.terraform.structure.VanillaStructurePopulator;
import org.terraform.structure.monument.MonumentPopulator;
import org.terraform.structure.pillager.mansion.MansionPopulator;
import org.terraform.structure.small.buriedtreasure.BuriedTreasurePopulator;
import org.terraform.structure.stronghold.StrongholdPopulator;
import org.terraform.structure.trialchamber.TrialChamberPopulator;
import org.terraform.utils.version.TerraformFieldHandler;
import org.terraform.utils.version.TerraformMethodHandler;

public class NMSChunkGenerator
extends ChunkGenerator {
    @NotNull
    private final ChunkGenerator delegate;
    @NotNull
    private final TerraformWorld tw;
    @NotNull
    private final MapRenderWorldProviderBiome mapRendererBS;
    @NotNull
    private final TerraformWorldProviderBiome twBS;
    @NotNull
    private final TerraformMethodHandler tryGenerateStructure;
    private final ArrayList<MinecraftKey> possibleStructureSets = new ArrayList();
    @NotNull
    private final TerraformMethodHandler getWriteableArea;
    @NotNull
    private final Supplier featuresPerStep;

    public NMSChunkGenerator(String worldName, long seed, @NotNull ChunkGenerator delegate) throws NoSuchMethodException, SecurityException, NoSuchFieldException, IllegalAccessException {
        super(delegate.d(), delegate.d);
        this.tw = TerraformWorld.get(worldName, seed);
        this.delegate = delegate;
        this.mapRendererBS = new MapRenderWorldProviderBiome(this.tw, delegate.d());
        this.twBS = new TerraformWorldProviderBiome(TerraformWorld.get(worldName, seed), delegate.d());
        this.featuresPerStep = (Supplier)new TerraformFieldHandler(ChunkGenerator.class, (String[])new String[]{"featuresPerStep", "c"}).field.get(delegate);
        this.getWriteableArea = new TerraformMethodHandler(ChunkGenerator.class, new String[]{"getWritableArea", "a"}, IChunkAccess.class);
        for (StructurePopulator pop : StructureRegistry.getAllPopulators()) {
            if (!(pop instanceof VanillaStructurePopulator)) continue;
            VanillaStructurePopulator vsp = (VanillaStructurePopulator)pop;
            this.possibleStructureSets.add(MinecraftKey.a((String)vsp.structureRegistryKey));
        }
        this.tryGenerateStructure = new TerraformMethodHandler(ChunkGenerator.class, new String[]{"tryGenerateStructure", "a"}, StructureSet.a.class, StructureManager.class, IRegistryCustom.class, RandomState.class, StructureTemplateManager.class, Long.TYPE, IChunkAccess.class, ChunkCoordIntPair.class, SectionPosition.class, ResourceKey.class);
    }

    @NotNull
    public WorldChunkManager d() {
        return this.mapRendererBS;
    }

    @NotNull
    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }

    @NotNull
    protected MapCodec<? extends ChunkGenerator> b() {
        return MapCodec.unit(null);
    }

    @NotNull
    public CompletableFuture<IChunkAccess> a(RandomState randomstate, Blender blender, StructureManager structuremanager, @NotNull IChunkAccess ChunkAccess) {
        return CompletableFuture.supplyAsync(() -> ChunkAccess, SystemUtils.h().a("init_biomes"));
    }

    public Pair<BlockPosition, Holder<Structure>> a(WorldServer ServerLevel, @NotNull HolderSet<Structure> holderset, @NotNull BlockPosition BlockPos, int i, boolean flag) {
        int pX = BlockPos.u();
        int pZ = BlockPos.w();
        for (Holder holder : holderset) {
            Structure feature = (Structure)holder.a();
            TerraformGeneratorPlugin.logger.info("Vanilla locate for " + feature.getClass().getName() + " invoked.");
            if (((Structure)holder.a()).getClass() == StrongholdStructure.class) {
                int[] coords = new StrongholdPopulator().getNearestFeature(this.tw, pX, pZ);
                return new Pair((Object)new BlockPosition(coords[0], 20, coords[1]), (Object)holder);
            }
            if (TConfig.c.DEVSTUFF_VANILLA_LOCATE_DISABLE) continue;
            if (((Structure)holder.a()).getClass() == OceanMonumentStructure.class) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MonumentPopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
                return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
            }
            if (((Structure)holder.a()).getClass() == WoodlandMansionStructure.class) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MansionPopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
                return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
            }
            if (holder.a() instanceof JigsawStructure && ((IRegistry)MinecraftServer.getServer().bg().a(Registries.bm).orElseThrow()).a(MinecraftKey.a((String)"trial_chambers")) == holder.a()) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new TrialChamberPopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
                return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
            }
            if (((Structure)holder.a()).getClass() != BuriedTreasureStructure.class) continue;
            int[] coords = StructureLocator.locateMultiMegaChunkStructure(this.tw, new MegaChunk(pX, 0, pZ), new BuriedTreasurePopulator(), TConfig.c.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS);
            if (coords == null) {
                return null;
            }
            return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
        }
        return null;
    }

    public void a(GeneratorAccessSeed worldGenLevel, IChunkAccess ChunkAccess, StructureManager structuremanager) {
        this.delegate.a(worldGenLevel, ChunkAccess, structuremanager);
        this.addVanillaDecorations(worldGenLevel, ChunkAccess, structuremanager);
    }

    public void addVanillaDecorations(GeneratorAccessSeed worldGenLevel, IChunkAccess chunkAccess, StructureManager structuremanager) {
        ChunkCoordIntPair ChunkPos = chunkAccess.f();
        if (!SharedConstants.a((ChunkCoordIntPair)ChunkPos)) {
            SectionPosition sectionPos = SectionPosition.a((ChunkCoordIntPair)ChunkPos, (int)worldGenLevel.at());
            BlockPosition BlockPos = sectionPos.j();
            IRegistry iregistry = worldGenLevel.L_().f(Registries.bm);
            Map<Integer, List<Structure>> map = iregistry.s().collect(Collectors.groupingBy(structurex -> structurex.c().ordinal()));
            List list = (List)this.featuresPerStep.get();
            SeededRandom seededrandom = new SeededRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.a()));
            long i = seededrandom.a(worldGenLevel.H(), BlockPos.u(), BlockPos.w());
            ObjectArraySet set = new ObjectArraySet();
            ChunkCoordIntPair.a((ChunkCoordIntPair)sectionPos.r(), (int)1).forEach(arg_0 -> NMSChunkGenerator.lambda$addVanillaDecorations$2(worldGenLevel, (Set)set, arg_0));
            set.retainAll(this.b.c());
            int j = list.size();
            try {
                IRegistry iregistry1 = worldGenLevel.L_().f(Registries.bj);
                int k = Math.max(WorldGenStage.Decoration.values().length, j);
                for (int l = 0; l < k; ++l) {
                    int i1 = 0;
                    if (!structuremanager.a()) continue;
                    for (Structure structure : map.getOrDefault(l, Collections.emptyList())) {
                        seededrandom.b(i, i1, l);
                        Supplier<String> supplier = () -> {
                            Optional<String> optional = iregistry.d((Object)structure).map(Object::toString);
                            Objects.requireNonNull(structure);
                            return (String)optional.orElseGet(structure::toString);
                        };
                        try {
                            worldGenLevel.a(supplier);
                            structuremanager.a(sectionPos, structure).forEach(structurestart -> {
                                try {
                                    structurestart.a(worldGenLevel, structuremanager, (ChunkGenerator)this, (RandomSource)seededrandom, (StructureBoundingBox)this.getWriteableArea.method.invoke(null, chunkAccess), ChunkPos);
                                }
                                catch (IllegalAccessException | InvocationTargetException e2) {
                                    CrashReport crashreport = CrashReport.a((Throwable)e2, (String)"TerraformGenerator");
                                    throw new ReportedException(crashreport);
                                }
                            });
                        }
                        catch (Exception var31) {
                            CrashReport crashreport = CrashReport.a((Throwable)var31, (String)"Feature placement");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Feature");
                            Objects.requireNonNull(supplier);
                            crashreportsystemdetails.a("Description", supplier::get);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
                worldGenLevel.a((Supplier)null);
                if (SharedConstants.aW) {
                    FeatureCountTracker.a((WorldServer)worldGenLevel.a());
                }
            }
            catch (Exception var32) {
                CrashReport crashreport2 = CrashReport.a((Throwable)var32, (String)"Biome decoration");
                crashreport2.a("Generation").a("CenterX", (Object)ChunkPos.h).a("CenterZ", (Object)ChunkPos.i).a("Decoration Seed", (Object)i);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void a(RegionLimitedWorldAccess worldGenRegion, long seed, RandomState randomstate, BiomeManager biomemanager, StructureManager structuremanager, @NotNull IChunkAccess chunkAccess) {
        chunkAccess.a((BiomeResolver)this.twBS, null);
        this.delegate.a(worldGenRegion, seed, randomstate, biomemanager, structuremanager, chunkAccess);
    }

    public int e() {
        return this.delegate.e();
    }

    public void a(IRegistryCustom registryAccess, @NotNull ChunkGeneratorStructureState chunkgeneratorstructurestate, StructureManager structuremanager, @NotNull IChunkAccess ChunkAccess, StructureTemplateManager structuretemplatemanager, ResourceKey<World> resourcekey) {
        ChunkCoordIntPair ChunkPos = ChunkAccess.f();
        SectionPosition sectionPos = SectionPosition.a((IChunkAccess)ChunkAccess);
        RandomState randomstate = chunkgeneratorstructurestate.c();
        MegaChunk mc = new MegaChunk(ChunkPos.h, ChunkPos.i);
        SingleMegaChunkStructurePopulator[] spops = StructureRegistry.getLargeStructureForMegaChunk(this.tw, mc);
        int[] centerCoords = mc.getCenterBiomeSectionChunkCoords();
        if (spops == null) {
            return;
        }
        for (SingleMegaChunkStructurePopulator pop : spops) {
            if (!(pop instanceof VanillaStructurePopulator)) continue;
            VanillaStructurePopulator vpop = (VanillaStructurePopulator)pop;
            this.possibleStructureSets.stream().filter(resourceLoc -> vpop.structureRegistryKey.equals(resourceLoc.a())).map(resourceLoc -> (StructureSet)((IRegistry)MinecraftServer.getServer().bg().a(Registries.bl).orElseThrow()).a(resourceLoc)).forEach(structureSet -> {
                StructurePlacement structureplacement = structureSet.b();
                List list = structureSet.a();
                if (centerCoords[0] == ChunkPos.h && centerCoords[1] == ChunkPos.i) {
                    try {
                        Object retVal = this.tryGenerateStructure.method.invoke((Object)this, list.getFirst(), structuremanager, registryAccess, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.d(), ChunkAccess, ChunkPos, sectionPos, resourcekey);
                        TerraformGeneratorPlugin.logger.info(ChunkPos.h + "," + ChunkPos.i + " will spawn a vanilla structure, with tryGenerateStructure == " + String.valueOf(retVal));
                    }
                    catch (Throwable t) {
                        TerraformGeneratorPlugin.logger.info(ChunkPos.h + "," + ChunkPos.i + " Failed to generate a vanilla structure");
                        TerraformGeneratorPlugin.logger.stackTrace(t);
                    }
                }
            });
        }
    }

    public void a(GeneratorAccessSeed gas, StructureManager manager, IChunkAccess ica) {
        this.delegate.a(gas, manager, ica);
    }

    public int a(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public CompletableFuture<IChunkAccess> a(Blender blender, RandomState randomstate, StructureManager structuremanager, IChunkAccess ChunkAccess) {
        return this.delegate.a(blender, randomstate, structuremanager, ChunkAccess);
    }

    public void a(RegionLimitedWorldAccess worldGenRegion, StructureManager structuremanager, RandomState randomstate, IChunkAccess ChunkAccess) {
        this.delegate.a(worldGenRegion, structuremanager, randomstate, ChunkAccess);
    }

    public BlockColumn a(int i, int j, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.delegate.a(i, j, levelheightaccessor, randomstate);
    }

    public void a(RegionLimitedWorldAccess WorldGenRegion) {
        this.delegate.a(WorldGenRegion);
    }

    public int f() {
        return TerraformGenerator.seaLevel;
    }

    public int g() {
        return this.delegate.g();
    }

    public int b(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.b(i, j, heightmap_type, levelheightaccessor, randomstate);
    }

    public int c(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.c(i, j, heightmap_type, levelheightaccessor, randomstate) - 1;
    }

    public int a(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return 100;
    }

    public void a(List<String> list, RandomState randomstate, BlockPosition BlockPos) {
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$2(GeneratorAccessSeed worldGenLevel, Set set, ChunkCoordIntPair ChunkPos1) {
        IChunkAccess ichunkaccess1 = worldGenLevel.a(ChunkPos1.h, ChunkPos1.i);
        for (ChunkSection chunksection : ichunkaccess1.d()) {
            PalettedContainerRO palettedcontainerro = chunksection.i();
            Objects.requireNonNull(set);
            palettedcontainerro.a(set::add);
        }
    }
}

