/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure;

import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.HeightMap;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfig;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.StructureRegistry;

public class StructureBufferDistanceHandler {
    public static boolean[] canDecorateChunk(@NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        if (Math.pow(chunkX * 16, 2.0) + Math.pow(chunkZ * 16, 2.0) < (double)HeightMap.spawnFlatRadiusSquared) {
            return new boolean[]{false, true};
        }
        boolean[] canDecorate = new boolean[]{true, true};
        MegaChunk mc = new MegaChunk(chunkX, chunkZ);
        BiomeBank biome = mc.getCenterBiomeSection(tw).getBiomeBank();
        for (SingleMegaChunkStructurePopulator structPop : StructureRegistry.getLargeStructureForMegaChunk(tw, mc)) {
            SingleMegaChunkStructurePopulator spop;
            int chunkBufferRadius;
            if (structPop == null || !(structPop instanceof SingleMegaChunkStructurePopulator) || (chunkBufferRadius = (spop = structPop).getChunkBufferDistance()) <= 0 && spop.getCaveClusterBufferDistance() <= 0) continue;
            int[] chunkCoords = mc.getCenterBiomeSectionChunkCoords();
            if (!TConfig.areStructuresEnabled() || !spop.canSpawn(tw, chunkCoords[0], chunkCoords[1], biome)) continue;
            int dist = (int)(Math.pow(chunkCoords[0] - chunkX, 2.0) + Math.pow(chunkCoords[1] - chunkZ, 2.0));
            double rootedDist = Math.max(Math.sqrt(dist), 0.002);
            canDecorate[0] = canDecorate[0] & rootedDist > (double)chunkBufferRadius;
            canDecorate[1] = canDecorate[1] & rootedDist > (double)spop.getCaveClusterBufferDistance();
            if (canDecorate[0] || canDecorate[1]) continue;
            return canDecorate;
        }
        return canDecorate;
    }
}

