/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.structure.ancientcity.AncientCityAbstractRoomPopulator;
import org.terraform.structure.ancientcity.AncientCityUtils;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class AncientCityRuinsPlatform
extends AncientCityAbstractRoomPopulator {
    public AncientCityRuinsPlatform(TerraformWorld tw, HashSet<SimpleLocation> occupied, RoomLayoutGenerator gen, Random rand, boolean forceSpawn, boolean unique) {
        super(tw, gen, rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        super.populate(data, room);
        FastNoise ruinsNoise = NoiseCacheHandler.getNoise(this.tw, NoiseCacheHandler.NoiseCacheEntry.STRUCTURE_ANCIENTCITY_RUINS, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 11L));
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFrequency(0.09f);
            return n;
        });
        int totalPillars = 0;
        for (Map.Entry<Wall, Integer> entry : this.effectiveRoom.getFourWalls(data, 2).entrySet()) {
            Wall w = entry.getKey();
            for (int i = 0; i < entry.getValue(); ++i) {
                w.LPillar(Math.round(Math.abs(5.0f * ruinsNoise.GetNoise(totalPillars, 0.0f))), AncientCityUtils.deepslateBricks);
                w = w.getLeft();
                ++totalPillars;
            }
        }
        super.sculkUp(this.tw, data, this.effectiveRoom);
    }

    @Override
    public boolean canPopulate(@NotNull CubeRoom room) {
        return room.getWidthX() < 20 || room.getWidthZ() < 20;
    }
}

