/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.data.SimpleBlock;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.MultipleFacingBuilder;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.version.V_1_19;

public class AncientCityUtils {
    public static final Material[] deepslateBricks = new Material[]{Material.DEEPSLATE_BRICKS, Material.CRACKED_DEEPSLATE_BRICKS};
    public static final Material[] deepslateTiles = new Material[]{Material.DEEPSLATE_TILES, Material.CRACKED_DEEPSLATE_TILES};
    @Nullable
    private static Tag<Material> t = null;

    public static void placeSupportPillar(@NotNull SimpleBlock w) {
        Random dud = new Random();
        w.downUntilSolid(dud, Material.DEEPSLATE_BRICKS);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            w.getRelative(face).downUntilSolid(dud, Material.DEEPSLATE_BRICKS);
        }
        for (BlockFace face : BlockUtils.xzDiagonalPlaneBlockFaces) {
            int height = w.getRelative(face).downUntilSolid(dud, Material.COBBLED_DEEPSLATE_WALL);
            w.getRelative(face).getDown(height - 1).CorrectMultipleFacing(height);
        }
    }

    public static void spreadSculk(@NotNull FastNoise circleNoise, @NotNull Random random, float radius, @NotNull SimpleBlock center) {
        if (t == null) {
            try {
                t = (Tag)Tag.class.getDeclaredField("SCULK_REPLACEABLE_WORLD_GEN").get(null);
            }
            catch (Exception e2) {
                TerraformGeneratorPlugin.logger.stackTrace(e2);
            }
        }
        boolean placedShrieker = false;
        boolean placedSensor = false;
        boolean placedCatalyst = false;
        for (float nx = -radius; nx <= radius; nx += 1.0f) {
            for (float nz = -radius; nz <= radius; nz += 1.0f) {
                for (float ny = -radius; ny <= radius; ny += 1.0f) {
                    float noiseVal;
                    double equationResult;
                    SimpleBlock rel = center.getRelative(Math.round(nx), Math.round(ny), Math.round(nz));
                    if (!rel.isSolid() || rel.getType() == V_1_19.SCULK_VEIN || !((equationResult = Math.pow(nx, 2.0) / Math.pow(radius, 2.0) + Math.pow(nz, 2.0) / Math.pow(radius, 2.0) + Math.pow(ny, 2.0) / Math.pow(radius, 2.0)) <= 1.0 + 0.7 * (double)(noiseVal = circleNoise.GetNoise(rel.getX(), rel.getY(), rel.getZ()))) || !BlockUtils.isExposedToNonSolid(rel) && rel.getDown().isSolid() && rel.getUp().isSolid()) continue;
                    if (t.isTagged((Keyed)rel.getType()) && equationResult <= 0.7 * (1.0 + 0.7 * (double)noiseVal)) {
                        assert (V_1_19.SCULK != null);
                        rel.setType(V_1_19.SCULK);
                        if (rel.getUp().isSolid()) continue;
                        if (!placedCatalyst && GenUtils.chance(random, 1, 40)) {
                            placedCatalyst = true;
                            rel.getUp().setType(V_1_19.SCULK_CATALYST);
                            continue;
                        }
                        if (!placedSensor && GenUtils.chance(random, 1, 20)) {
                            placedSensor = true;
                            rel.getUp().setType(V_1_19.SCULK_SENSOR);
                            continue;
                        }
                        if (placedShrieker || !GenUtils.chance(random, 1, 90)) continue;
                        placedShrieker = true;
                        rel.getUp().setBlockData(V_1_19.getActiveSculkShrieker());
                        continue;
                    }
                    if (rel.getType() == V_1_19.SCULK_SHRIEKER || rel.getType() == V_1_19.SCULK_SENSOR || Tag.STAIRS.isTagged((Keyed)rel.getType()) || Tag.SLABS.isTagged((Keyed)rel.getType())) continue;
                    for (BlockFace face : BlockUtils.sixBlockFaces) {
                        SimpleBlock adj = rel.getRelative(face);
                        if (adj.isAir()) {
                            new MultipleFacingBuilder(V_1_19.SCULK_VEIN).setFace(face.getOppositeFace(), true).apply(adj);
                            continue;
                        }
                        if (adj.getType() != V_1_19.SCULK_VEIN) continue;
                        MultipleFacing mf = (MultipleFacing)adj.getBlockData();
                        mf.setFace(face.getOppositeFace(), true);
                        adj.setBlockData((BlockData)mf);
                    }
                }
            }
        }
    }
}

