/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.catacombs;

import java.util.Random;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.structure.catacombs.CatacombsStandardPopulator;
import org.terraform.structure.room.CubeRoom;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.CylinderBuilder;
import org.terraform.utils.GenUtils;
import org.terraform.utils.SphereBuilder;

public class CatacombsDripstoneBasinPopulator
extends CatacombsStandardPopulator {
    public CatacombsDripstoneBasinPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        super.populate(data, room);
        SimpleBlock center = room.getCenterSimpleBlock(data).getUp();
        new SphereBuilder(new Random(), center.getDown(), Material.WATER).setRadius(3.0f).setSphereType(SphereBuilder.SphereType.LOWER_SEMISPHERE).setDoLiquidContainment(true).setHardReplace(true).build();
        new CylinderBuilder(new Random(), center.getUp(10), Material.CAVE_AIR).setRadius(2.5f).setRY(6.0f).setHardReplace(true).build();
        for (int i = 2; i <= GenUtils.randInt(2, 5); ++i) {
            int[] coords = room.randomCoords(this.rand, 2);
            SimpleBlock target = new SimpleBlock(data, coords[0], room.getY() + 1, coords[2]);
            if ((target = target.findFloor(room.getHeight())) == null || !BlockUtils.isWet(target.getUp())) continue;
            CoralGenerator.generateSeaPickles(data, target.getX(), target.getY() + 1, target.getZ());
        }
    }
}

