/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.catacombs;

import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.Bisected;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Skeleton;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataSpigotAPI;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfig;
import org.terraform.structure.catacombs.CatacombsPathPopulator;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.SphereBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class CatacombsStandardPopulator
extends RoomPopulatorAbstract {
    public CatacombsStandardPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int[] lowerCorner = room.getLowerCorner(0);
        int[] upperCorner = room.getUpperCorner(0);
        float maxTotalDiff = (float)room.getWidthX() / 2.0f + (float)room.getWidthZ() / 2.0f;
        int y = room.getY();
        new SphereBuilder(this.rand, room.getCenterSimpleBlock(data), CatacombsPathPopulator.pathMaterial).setRX((float)room.getWidthX() / 2.0f).setRZ((float)room.getWidthZ() / 2.0f).setRY((float)room.getWidthX() / 3.0f).setHardReplace(true).setSphereType(SphereBuilder.SphereType.LOWER_SEMISPHERE).build();
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                if (this.rand.nextInt(5) < 4) {
                    data.setType(x, y, z, GenUtils.randChoice(CatacombsPathPopulator.pathMaterial));
                } else if (!data.getType(x, y, z).isSolid()) {
                    data.setType(x, y, z, GenUtils.randChoice(Material.STONE, Material.ANDESITE, Material.CRACKED_STONE_BRICKS));
                }
                SimpleBlock ceiling = new SimpleBlock(data, x, y + 1, z).findCeiling(room.getHeight() + 1);
                if (ceiling == null) continue;
                float maxDownExtend = room.getHeight() - 4;
                int xDiffFromCent = Math.abs(x - room.getX()) + this.rand.nextInt(2);
                int zDiffFromCent = Math.abs(z - room.getZ()) + this.rand.nextInt(2);
                int extend = Math.round((float)(xDiffFromCent + zDiffFromCent) / maxTotalDiff * maxDownExtend);
                ceiling.getDown().downLPillar(new Random(), extend, Material.STONE, Material.ANDESITE, Material.CRACKED_STONE_BRICKS);
                if (!TConfig.areDecorationsEnabled() || this.rand.nextInt(10) != 0) continue;
                ceiling.getDown(extend + 1).getRelative(BlockUtils.getDirectBlockFace(this.rand)).lsetType(Material.COBWEB);
            }
        }
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 0).entrySet()) {
            Wall w = entry.getKey();
            for (int i = 0; i < entry.getValue(); ++i) {
                Wall target;
                w.getRear().ReplacePillar(room.getHeight(), Material.STONE, Material.ANDESITE);
                if (this.rand.nextInt(8) == 4 && (target = w.getUp(this.rand.nextInt(room.getHeight()) + 1).getRear()).isSolid()) {
                    target.ReplacePillar(1, Material.POLISHED_ANDESITE);
                    target.getRight().ReplacePillar(1, Material.POLISHED_ANDESITE);
                }
                if ((w.getUp(2).getLeft().getRear().isAir() || w.getUp(2).getRight().getRear().isAir()) && w.getUp(2).getRear().isSolid()) {
                    new StairBuilder(Material.STONE_BRICK_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS, Material.COBBLESTONE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(w.getDirection().getOppositeFace()).apply(w.getUp(2));
                    BlockUtils.placeCandle(w.getUp(3), GenUtils.randInt(1, 4), this.lightCandles());
                }
                w = w.getLeft();
            }
        }
        for (int i = 0; i < 1 + this.rand.nextInt(3); ++i) {
            int[] coords = room.randomCoords(this.rand, 1);
            SimpleBlock target = new SimpleBlock(data, coords[0], room.getY() + 1, coords[2]);
            target = target.getAtY(room.getY() + 1);
            if (!(data instanceof PopulatorDataSpigotAPI)) continue;
            Skeleton e2 = (Skeleton)((PopulatorDataSpigotAPI)data).lr.spawnEntity(new Location(Objects.requireNonNull(data.getTerraformWorld()).getWorld(), (double)target.getX() + 0.5, (double)target.getY() + 0.3, (double)target.getZ() + 0.5), EntityType.SKELETON);
            Objects.requireNonNull(e2.getEquipment()).setItemInMainHand(new ItemStack(Material.IRON_SWORD));
            e2.setPersistent(true);
        }
    }

    protected void spawnHangingChains(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        if (!TConfig.areDecorationsEnabled()) {
            return;
        }
        for (int i = 3; i <= 10; ++i) {
            int[] coords = room.randomCoords(this.rand, 1);
            SimpleBlock target = new SimpleBlock(data, coords[0], room.getY() + 1, coords[2]);
            if ((target = target.findCeiling(room.getHeight())) == null || target.getY() - room.getY() < 4) continue;
            target.getDown().downLPillar(new Random(), GenUtils.randInt(3, 5), Material.CHAIN);
        }
    }

    protected boolean lightCandles() {
        return true;
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

