/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.caves;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeType;
import org.terraform.data.MegaChunk;
import org.terraform.data.SimpleChunkLocation;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.structure.JigsawState;
import org.terraform.structure.JigsawStructurePopulator;
import org.terraform.structure.caves.GenericLargeCavePopulator;
import org.terraform.structure.caves.LargeCaveRoomCarver;
import org.terraform.structure.caves.LargeCaveRoomPiece;
import org.terraform.structure.caves.LargeLushCavePopulator;
import org.terraform.structure.caves.MushroomCavePopulator;
import org.terraform.structure.room.RoomLayout;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class LargeCavePopulator
extends JigsawStructurePopulator {
    @Override
    @NotNull
    public JigsawState calculateRoomPopulators(@NotNull TerraformWorld tw, @NotNull MegaChunk mc) {
        JigsawState state = new JigsawState();
        int[] spawnCoords = mc.getCenterBiomeSectionBlockCoords();
        int x = spawnCoords[0];
        int z = spawnCoords[1];
        Random rand = tw.getHashedRand(x, z, 79810139);
        FastNoise noise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.STRUCTURE_LARGECAVE_CARVER, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 8726L));
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFrequency(0.04f);
            return n;
        });
        int minY = GenUtils.randInt(rand, -5, -32);
        int highest = GenUtils.getTransformedHeight(tw, x, z) - minY;
        int rX = GenUtils.randInt(rand, 30, 50);
        int rY = (highest - 20) / 2;
        int rZ = GenUtils.randInt(rand, 30, 50);
        int y = rY + minY + 6;
        GenericLargeCavePopulator cavePopulator = Objects.requireNonNull(GenUtils.choice(rand, new GenericLargeCavePopulator[]{new MushroomCavePopulator(tw.getHashedRand(x, 13729804, z), false, false), new GenericLargeCavePopulator(tw.getHashedRand(x, 13729804, z), false, false), new LargeLushCavePopulator(tw.getHashedRand(x, 13729804, z), false, false)}));
        RoomLayoutGenerator gen = new RoomLayoutGenerator(new Random(), RoomLayout.RANDOM_BRUTEFORCE, 10, x, y, z, 150);
        gen.setGenPaths(false);
        gen.roomCarver = new LargeCaveRoomCarver(GenUtils.randChoice(rand, new Material[]{Material.LAVA, Material.WATER}));
        SimpleLocation center = new SimpleLocation(x, y, z);
        TerraformGeneratorPlugin.logger.info("Large Cave at " + String.valueOf(center) + " has water level > " + minY + " with populator " + cavePopulator.getClass().getSimpleName());
        HashMap<SimpleChunkLocation, LargeCaveRoomPiece> chunkToRoom = new HashMap<SimpleChunkLocation, LargeCaveRoomPiece>();
        ArrayDeque<SimpleLocation> queue = new ArrayDeque<SimpleLocation>();
        HashSet<SimpleLocation> seen = new HashSet<SimpleLocation>();
        int actualMinY = y;
        seen.add(center);
        queue.add(center);
        while (!queue.isEmpty()) {
            SimpleLocation v = (SimpleLocation)queue.remove();
            LargeCaveRoomPiece caveRoom = chunkToRoom.computeIfAbsent(new SimpleChunkLocation(tw.getName(), GenUtils.getTripleChunk(v.getX() >> 4), GenUtils.getTripleChunk(v.getZ() >> 4)), loc -> {
                LargeCaveRoomPiece newRoom = new LargeCaveRoomPiece(41, 41, 15, GenUtils.getTripleChunk(v.getX() >> 4) * 16 + 7, y, GenUtils.getTripleChunk(v.getZ() >> 4) * 16 + 7);
                newRoom.setRoomPopulator(cavePopulator);
                gen.getRooms().add(newRoom);
                return newRoom;
            });
            actualMinY = Math.min(actualMinY, v.getY());
            boolean nextToBoundary = false;
            for (BlockFace face : BlockUtils.sixBlockFaces) {
                double n;
                SimpleLocation neighbour = v.getRelative(face);
                if (seen.contains(neighbour)) continue;
                if (neighbour.getY() + 3 >= GenUtils.getTransformedHeight(tw, neighbour.getX(), neighbour.getZ())) {
                    nextToBoundary = true;
                    continue;
                }
                double equationResult = Math.pow(neighbour.getX() - center.getX(), 2.0) / Math.pow(rX, 2.0) + Math.pow(neighbour.getY() - center.getY(), 2.0) / Math.pow(rY, 2.0) + Math.pow(neighbour.getZ() - center.getZ(), 2.0) / Math.pow(rZ, 2.0);
                if (equationResult > 1.0 + Math.max(0.0, n = 0.7 * (double)noise.GetNoise(neighbour.getX(), neighbour.getY(), neighbour.getZ()))) {
                    nextToBoundary = true;
                    continue;
                }
                seen.add(neighbour);
                queue.add(neighbour);
            }
            caveRoom.toCarve.set(v);
            caveRoom.boundaries.set(v, nextToBoundary);
            if (nextToBoundary || caveRoom.startingLoc != null) continue;
            caveRoom.startingLoc = v;
        }
        ((LargeCaveRoomCarver)gen.roomCarver).waterLevel = actualMinY + GenUtils.randInt(rand, 4, 7);
        gen.getRooms().forEach(room -> {
            ((LargeCaveRoomPiece)room).waterLevel = ((LargeCaveRoomCarver)gen.roomCarver).waterLevel;
        });
        state.roomPopulatorStates.add(gen);
        return state;
    }

    private boolean rollSpawnRatio(@NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        return GenUtils.chance(tw.getHashedRand(chunkX, chunkZ, 12345), (int)(TConfig.c.STRUCTURES_LARGECAVE_SPAWNRATIO * 10000.0), 10000);
    }

    @Override
    public boolean canSpawn(@NotNull TerraformWorld tw, int chunkX, int chunkZ, @NotNull BiomeBank biome) {
        if (!this.isEnabled()) {
            return false;
        }
        if (biome.getType() == BiomeType.DEEP_OCEANIC) {
            return false;
        }
        return this.rollSpawnRatio(tw, chunkX, chunkZ);
    }

    @Override
    @NotNull
    public Random getHashedRandom(@NotNull TerraformWorld tw, int chunkX, int chunkZ) {
        return tw.getHashedRand(123912L, chunkX, chunkZ);
    }

    @Override
    public boolean isEnabled() {
        return TConfig.areCavesEnabled() && TConfig.c.STRUCTURES_LARGECAVE_ENABLED;
    }

    @Override
    public int getChunkBufferDistance() {
        return 0;
    }

    @Override
    public int getCaveClusterBufferDistance() {
        return 3;
    }
}

