/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.mineshaft;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Furnace;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfig;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.GenUtils;

public class SmeltingHallPopulator
extends RoomPopulatorAbstract {
    public SmeltingHallPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int[] lowerCorner = room.getLowerCorner(3);
        int[] upperCorner = room.getUpperCorner(3);
        int y = room.getY();
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                SimpleBlock b2 = new SimpleBlock(data, x, y, z);
                if (b2.getType() != Material.CAVE_AIR && b2.getType() != Material.OAK_PLANKS && b2.getType() != Material.OAK_SLAB && b2.getType() != Material.GRAVEL) continue;
                b2.setType(GenUtils.randChoice(Material.STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.MOSSY_COBBLESTONE, Material.COBBLESTONE, Material.CAVE_AIR));
                if (!TConfig.areDecorationsEnabled() || !GenUtils.chance(this.rand, 1, 150)) continue;
                b2.getUp().setType(Material.COBBLESTONE);
                b2.getUp(2).setType(Material.LANTERN);
            }
        }
        for (int[] corner : room.getAllCorners(3)) {
            int x = corner[0];
            int z = corner[1];
            Wall w = new Wall(new SimpleBlock(data, x, room.getY() + 1, z), BlockFace.NORTH);
            if (w.findCeiling(50) != null) {
                if (!TConfig.areDecorationsEnabled()) continue;
                w.LPillar(50, this.rand, Material.IRON_BARS);
                continue;
            }
            w.getDown().downUntilSolid(this.rand, Material.OAK_LOG);
        }
        Object object = room.getFourWalls(data, 4).entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry walls = (Map.Entry)object.next();
            int type = this.rand.nextInt(3);
            if (type == 0) continue;
            Wall w = (Wall)walls.getKey();
            int l = (Integer)walls.getValue();
            for (int i = 0; i < l; ++i) {
                if (TConfig.areDecorationsEnabled() && w.getType() == Material.CAVE_AIR) {
                    if (type == 1) {
                        Furnace furnace = (Furnace)Bukkit.createBlockData((Material)Material.FURNACE);
                        furnace.setFacing(w.getDirection());
                        for (int ny = 0; ny < room.getHeight() / 3; ++ny) {
                            w.getRelative(0, ny, 0).setBlockData((BlockData)furnace);
                        }
                    } else if (GenUtils.chance(this.rand, 1, 5)) {
                        Chest chest = (Chest)Bukkit.createBlockData((Material)Material.CHEST);
                        chest.setFacing(w.getDirection());
                        w.setBlockData((BlockData)chest);
                        data.lootTableChest(w.getX(), w.getY(), w.getZ(), TerraLootTable.ABANDONED_MINESHAFT);
                    }
                }
                w = w.getLeft();
            }
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

