/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.monument;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Stairs;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.Wall;
import org.terraform.structure.monument.MonumentDesign;
import org.terraform.structure.monument.MonumentRoomPopulator;
import org.terraform.structure.room.CubeRoom;
import org.terraform.utils.GenUtils;

public class CageRoomPopulator
extends MonumentRoomPopulator {
    public CageRoomPopulator(Random rand, MonumentDesign design, boolean forceSpawn, boolean unique) {
        super(rand, design, forceSpawn, unique);
    }

    @Override
    public boolean canPopulate(@NotNull CubeRoom room) {
        return room.getHeight() > 9;
    }

    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int i;
        super.populate(data, room);
        if (GenUtils.chance(this.rand, 3, 5)) {
            return;
        }
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 0).entrySet()) {
            Wall w = entry.getKey().getUp(7);
            int length = entry.getValue();
            for (i = 0; i < length; ++i) {
                if (i % 2 == 0) {
                    Waterlogged wall = (Waterlogged)Bukkit.createBlockData((Material)Material.PRISMARINE_WALL);
                    wall.setWaterlogged(w.get().getY() <= TerraformGenerator.seaLevel);
                    for (int j = 0; j < room.getHeight() - 9; ++j) {
                        w.getRelative(0, j, 0).setBlockData((BlockData)wall);
                    }
                } else {
                    w.Pillar(room.getHeight() - 9, this.rand, Material.DARK_PRISMARINE_SLAB, Material.PRISMARINE_SLAB, Material.PRISMARINE_BRICK_SLAB);
                    Stairs s = (Stairs)Bukkit.createBlockData((Material)this.design.stairs());
                    s.setFacing(w.getDirection());
                    s.setWaterlogged(w.get().getY() <= TerraformGenerator.seaLevel);
                    w.setBlockData((BlockData)s);
                    s = (Stairs)s.clone();
                    s.setHalf(Bisected.Half.TOP);
                    w.getRelative(0, room.getHeight() - 9, 0).setBlockData((BlockData)s);
                }
                w = w.getLeft();
            }
        }
        for (Object corner : (Object)room.getAllCorners()) {
            for (i = 0; i < room.getHeight(); ++i) {
                if (!data.getType((int)corner[0], i + room.getY(), (int)corner[1]).isSolid()) continue;
                data.setType((int)corner[0], i + room.getY(), (int)corner[1], Material.DARK_PRISMARINE);
            }
        }
    }
}

