/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.monument;

import java.util.Locale;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.schematic.TerraSchematic;
import org.terraform.structure.monument.MonumentSchematicParser;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public enum MonumentDesign {
    DARK_PRISMARINE_CORNERS(Material.DARK_PRISMARINE, Material.PRISMARINE_BRICKS),
    PRISMARINE_LANTERNS(Material.PRISMARINE_BRICKS, Material.PRISMARINE_BRICKS, Material.PRISMARINE),
    DARK_LIGHTLESS(Material.PRISMARINE, Material.DARK_PRISMARINE, Material.DARK_PRISMARINE, Material.DARK_PRISMARINE);

    final Material[] tileSet;

    private MonumentDesign(Material ... tileSet) {
        this.tileSet = tileSet;
    }

    public Material[] tileSet() {
        return this.tileSet;
    }

    @Nullable
    public Material slab() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> Material.DARK_PRISMARINE_SLAB;
            case 0 -> GenUtils.randChoice(Material.DARK_PRISMARINE_SLAB, Material.PRISMARINE_BRICK_SLAB);
            case 1 -> GenUtils.randChoice(Material.PRISMARINE_SLAB, Material.PRISMARINE_BRICK_SLAB);
        };
    }

    @NotNull
    public Material stairs() {
        return Material.DARK_PRISMARINE_STAIRS;
    }

    public Material mat(@NotNull Random rand) {
        return GenUtils.randChoice(rand, this.tileSet);
    }

    public void spawnLargeLight(@NotNull PopulatorDataAbstract data, int x, int y, int z) {
        try {
            TerraSchematic schema = TerraSchematic.load(this.toString().toLowerCase(Locale.ENGLISH) + "-largelight", new SimpleBlock(data, ++x, ++y, ++z));
            schema.parser = new MonumentSchematicParser();
            schema.setFace(BlockFace.NORTH);
            schema.apply();
        }
        catch (Throwable e2) {
            TerraformGeneratorPlugin.logger.stackTrace(e2);
        }
    }

    public void upSpire(@NotNull SimpleBlock base, @NotNull Random rand) {
        while (base.isSolid() || base.getUp().isSolid()) {
            if ((base = base.getUp()).getY() <= TerraformGenerator.seaLevel) continue;
            return;
        }
        this.spire(new Wall(base, BlockFace.NORTH), rand);
    }

    public void spire(@NotNull Wall w, @NotNull Random rand) {
        this.spire(w, rand, 7);
    }

    public void spire(@NotNull Wall w, @NotNull Random rand, int height) {
        switch (this.ordinal()) {
            case 2: {
                for (int i = 0; i < height; ++i) {
                    if (i == 0) {
                        w.setType(Material.DARK_PRISMARINE);
                    } else if (i > height - 3) {
                        w.setType(Material.PRISMARINE_WALL);
                    } else {
                        w.setType(GenUtils.randChoice(Material.DARK_PRISMARINE, Material.PRISMARINE_WALL));
                        if (rand.nextBoolean()) {
                            Stairs stairs = (Stairs)Bukkit.createBlockData((Material)Material.DARK_PRISMARINE_STAIRS);
                            stairs.setFacing(BlockUtils.getDirectBlockFace(rand));
                            stairs.setHalf(rand.nextBoolean() ? Bisected.Half.TOP : Bisected.Half.BOTTOM);
                            w.setBlockData((BlockData)stairs);
                        }
                    }
                    w = w.getUp();
                }
                break;
            }
            case 0: {
                for (int i = 0; i < height; ++i) {
                    if (i == 0) {
                        w.setType(Material.DARK_PRISMARINE);
                    } else if (i == 3) {
                        w.setType(Material.SEA_LANTERN);
                    } else {
                        w.setType(GenUtils.randChoice(Material.DARK_PRISMARINE, Material.PRISMARINE_WALL));
                        if (rand.nextBoolean()) {
                            Stairs stairs = (Stairs)Bukkit.createBlockData((Material)Material.DARK_PRISMARINE_STAIRS);
                            stairs.setFacing(BlockUtils.getDirectBlockFace(rand));
                            stairs.setHalf(rand.nextBoolean() ? Bisected.Half.TOP : Bisected.Half.BOTTOM);
                        }
                    }
                    w = w.getUp();
                }
                break;
            }
            case 1: {
                for (int i = 0; i < height; ++i) {
                    if (i == 0) {
                        w.setType(Material.PRISMARINE_BRICKS);
                    } else if (i > height - 2) {
                        w.setType(Material.PRISMARINE_WALL);
                    } else if (i == height - 2) {
                        w.setType(Material.PRISMARINE_BRICKS);
                    } else {
                        w.setType(Material.PRISMARINE_WALL);
                        if (i == 3) {
                            w.setType(Material.SEA_LANTERN);
                        }
                    }
                    w = w.getUp();
                }
                break;
            }
        }
    }
}

