/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.warmoceanruins;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfig;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.warmoceanruins.WarmOceanBaseRoom;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.ChestBuilder;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class WarmOceanLargeArcRoom
extends WarmOceanBaseRoom {
    public WarmOceanLargeArcRoom(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void populate(@NotNull PopulatorDataAbstract data, @NotNull CubeRoom room) {
        int i;
        super.populate(data, room);
        BlockFace facing = BlockUtils.getDirectBlockFace(this.rand);
        Wall chestTarget = new Wall(room.getCenterSimpleBlock(data), facing).getLeft(GenUtils.getSign(this.rand) * this.rand.nextInt(2)).getFront(GenUtils.getSign(this.rand) * this.rand.nextInt(6)).getGround().getUp();
        new ChestBuilder(Material.CHEST).setFacing(BlockUtils.getDirectBlockFace(this.rand)).setLootTable(TerraLootTable.UNDERWATER_RUIN_BIG).setWaterlogged(chestTarget.getY() <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(chestTarget);
        Material[] centrePattern = new Material[]{GenUtils.randChoice(Material.POLISHED_DIORITE, Material.POLISHED_GRANITE, Material.POLISHED_ANDESITE), GenUtils.randChoice(Material.POLISHED_DIORITE, Material.POLISHED_GRANITE, Material.POLISHED_ANDESITE), GenUtils.randChoice(Material.POLISHED_DIORITE, Material.POLISHED_GRANITE, Material.POLISHED_ANDESITE)};
        Material[] sidePattern = new Material[]{GenUtils.randChoice(Material.POLISHED_DIORITE, Material.POLISHED_GRANITE, Material.POLISHED_ANDESITE), GenUtils.randChoice(Material.POLISHED_DIORITE, Material.POLISHED_GRANITE, Material.POLISHED_ANDESITE), GenUtils.randChoice(Material.POLISHED_DIORITE, Material.POLISHED_GRANITE, Material.POLISHED_ANDESITE)};
        BlockData[] centreSlabs = new BlockData[3];
        BlockData[] sideSlabs = new BlockData[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            centreSlabs[i2] = Bukkit.createBlockData((Material)Material.CUT_SANDSTONE_SLAB);
            if (this.rand.nextBoolean()) {
                ((Slab)centreSlabs[i2]).setType(Slab.Type.TOP);
            }
            if (GenUtils.chance(this.rand, 1, 4)) {
                centreSlabs[i2] = Bukkit.createBlockData((Material)Material.CHISELED_SANDSTONE);
            }
            sideSlabs[i2] = Bukkit.createBlockData((Material)Material.CUT_SANDSTONE_SLAB);
            if (!this.rand.nextBoolean()) continue;
            ((Slab)sideSlabs[i2]).setType(Slab.Type.TOP);
        }
        for (BlockFace pillarDir : BlockUtils.getAdjacentFaces(facing)) {
            SimpleBlock pillarCore = room.getCenterSimpleBlock(data).getRelative(pillarDir, 5);
            pillarCore.LPillar(8, Material.CUT_SANDSTONE);
            for (BlockFace face : BlockUtils.getAdjacentFaces(pillarDir)) {
                new StairBuilder(Material.SANDSTONE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(pillarDir).setWaterlogged(pillarCore.getY() + 6 <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(pillarCore.getUp(6).getRelative(face, 2).getRelative(pillarDir.getOppositeFace(), 3)).setWaterlogged(pillarCore.getY() + 7 <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(pillarCore.getUp(7).getRelative(face, 2).getRelative(pillarDir.getOppositeFace(), 4));
                pillarCore.getUp(7).getRelative(face, 2).getRelative(pillarDir.getOppositeFace(), 3).setType(Material.SMOOTH_SANDSTONE);
            }
            for (BlockFace face : BlockUtils.xzDiagonalPlaneBlockFaces) {
                pillarCore.getRelative(face, 3).setType(Material.CUT_SANDSTONE_SLAB);
                pillarCore.getRelative(face, 2).Pillar(8, Material.CUT_SANDSTONE);
                pillarCore.getUp(4).getRelative(face, 2).setType(Material.CHISELED_SANDSTONE);
            }
            for (BlockFace ny : (BlockFace[])new int[]{0, 4}) {
                for (int nx = -2; nx <= 2; ++nx) {
                    for (int nz = -2; nz <= 2; ++nz) {
                        pillarCore.getRelative(nx, (int)ny, nz).setType(Material.CHISELED_SANDSTONE);
                        if (ny != false) continue;
                        pillarCore.getDown().downLPillar(new Random(), 10 + this.rand.nextInt(5), Material.SANDSTONE);
                    }
                }
            }
            for (BlockFace face : BlockUtils.directBlockFaces) {
                for (BlockFace dir : BlockUtils.getAdjacentFaces(face)) {
                    pillarCore.getRelative(face, 3).getRelative(dir).setType(Material.CUT_SANDSTONE_SLAB);
                    new StairBuilder(Material.SANDSTONE_STAIRS).setFacing(dir).setWaterlogged(pillarCore.getY() <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(pillarCore.getRelative(face, 3).getRelative(dir, 2));
                }
                new StairBuilder(Material.SANDSTONE_STAIRS).setFacing(face.getOppositeFace()).setWaterlogged(pillarCore.getY() <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(pillarCore.getRelative(face, 3));
                for (BlockFace up : (BlockFace[])new int[]{1, 5}) {
                    Wall patternCore = new Wall(pillarCore.getUp((int)up).getRelative(face, 1), face);
                    for (int i3 = 0; i3 < 3; ++i3) {
                        patternCore.getUp(i3).setType(centrePattern[i3]);
                        patternCore.getUp(i3).getLeft().setType(sidePattern[i3]);
                        patternCore.getUp(i3).getRight().setType(sidePattern[i3]);
                        patternCore.getUp(i3).getFront().setBlockData(centreSlabs[i3]);
                        patternCore.getUp(i3).getFront().getLeft().setBlockData(sideSlabs[i3]);
                        patternCore.getUp(i3).getFront().getRight().setBlockData(sideSlabs[i3]);
                    }
                }
            }
        }
        Wall core = new Wall(new SimpleBlock(data, room.getX(), room.getY() + 8, room.getZ()), facing);
        for (int lr = -9; lr <= 9; ++lr) {
            for (int fb = -4; fb <= 4; ++fb) {
                if (Math.abs(lr) < 9 && Math.abs(fb) < 4) {
                    core.getLeft(lr).getFront(fb).setType(Material.CUT_SANDSTONE);
                    if (Math.abs(lr) < 7 && Math.abs(fb) < 2) {
                        core.getLeft(lr).getFront(fb).getUp(4).setType(Material.CUT_SANDSTONE_SLAB);
                        continue;
                    }
                    if (Math.abs(lr) == 7 || Math.abs(fb) == 2) {
                        core.getLeft(lr).getFront(fb).getUp(4).setType(Material.CUT_SANDSTONE);
                        continue;
                    }
                    new SlabBuilder(Material.CUT_SANDSTONE_SLAB).setType(Slab.Type.TOP).setWaterlogged(core.getY() + 4 <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(core.getLeft(lr).getFront(fb).getUp(4));
                    continue;
                }
                new SlabBuilder(Material.CUT_SANDSTONE_SLAB).setType(Slab.Type.TOP).setWaterlogged(core.getY() <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(core.getLeft(lr).getFront(fb));
            }
        }
        CubeRoom topCoreRoom = new CubeRoom(facing.getModX() == 0 ? 15 : 5, facing.getModZ() == 0 ? 15 : 5, 15, room.getX(), room.getY() + 8, room.getZ());
        for (Map.Entry<Wall, Integer> entry : topCoreRoom.getFourWalls(data, 0).entrySet()) {
            Wall w = entry.getKey();
            for (int i4 = 0; i4 < entry.getValue(); ++i4) {
                if (i4 != 0 && i4 != entry.getValue() - 1) {
                    if (i4 == 2 || i4 == 7 || i4 == 12) {
                        for (j = 0; j < 3; ++j) {
                            w.getFront().getUp(j).setType(centrePattern[j]);
                        }
                    } else {
                        for (j = 0; j < 3; ++j) {
                            w.getFront().getUp(j).setType(sidePattern[j]);
                        }
                    }
                }
                if (i4 == 0) {
                    w.Pillar(3, Material.CHISELED_SANDSTONE);
                    new StairBuilder(Material.SANDSTONE_STAIRS).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getLeft()).setHalf(Bisected.Half.TOP).setWaterlogged(w.getY() + 2 <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(w.getLeft().getUp(2));
                } else if (i4 == entry.getValue() - 1) {
                    w.Pillar(3, Material.CHISELED_SANDSTONE);
                    new StairBuilder(Material.SANDSTONE_STAIRS).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getRight()).setHalf(Bisected.Half.TOP).setWaterlogged(w.getY() + 2 <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(w.getRight().getUp(2));
                } else if (i4 == 4 || i4 == 10) {
                    w.Pillar(3, Material.CHISELED_SANDSTONE);
                    new StairBuilder(Material.SANDSTONE_STAIRS).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getRight()).setHalf(Bisected.Half.TOP).setWaterlogged(w.getY() + 2 <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(w.getRight().getUp(2));
                    new StairBuilder(Material.SANDSTONE_STAIRS).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getLeft()).setHalf(Bisected.Half.TOP).setWaterlogged(w.getY() + 2 <= TConfig.c.HEIGHT_MAP_SEA_LEVEL).apply(w.getLeft().getUp(2));
                }
                w = w.getLeft();
            }
        }
        Wall centre = new Wall(room.getCenterSimpleBlock(data), facing);
        for (i = 0; i < 1 + this.rand.nextInt(3); ++i) {
            BlockUtils.replaceWaterSphere(i * room.getX() * room.getZ(), GenUtils.randInt(3, 4), centre.getUp(6).getLeft(GenUtils.getSign(this.rand) * this.rand.nextInt(7)).getFront(GenUtils.getSign(this.rand) * this.rand.nextInt(3)));
        }
        for (i = 0; i < 1 + this.rand.nextInt(3); ++i) {
            centre.getUp().addEntity(EntityType.DROWNED);
        }
    }

    @Override
    public boolean canPopulate(@NotNull CubeRoom room) {
        return room.getWidthX() == 25;
    }
}

