/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.blockdata.StairBuilder;

public class StairwayBuilder {
    private final Material[] stairTypes;
    private boolean carveAirSpace = true;
    private BlockFace stairDirection = BlockFace.DOWN;
    private Material[] downTypes;
    private boolean stopAtWater = false;
    private int stopAtY = Short.MIN_VALUE;
    private boolean angled = false;
    private int maxExtensionForward = 10;
    private boolean upwardsCarveUntilNotSolid = true;
    private boolean upwardsCarveUntilSolid = false;

    public StairwayBuilder(Material ... stairTypes) {
        this.stairTypes = stairTypes;
        ArrayList<Material> downTypes = new ArrayList<Material>();
        for (Material mat : stairTypes) {
            Material toAdd = Material.matchMaterial((String)mat.toString().replace("_STAIRS", ""));
            if (toAdd == null) continue;
            downTypes.add(toAdd);
        }
        this.downTypes = new Material[downTypes.size()];
        for (int i = 0; i < downTypes.size(); ++i) {
            this.downTypes[i] = (Material)downTypes.get(i);
        }
    }

    @NotNull
    public StairwayBuilder setStopAtY(int y) {
        this.stopAtY = y;
        return this;
    }

    @NotNull
    public StairwayBuilder setCarveAirSpace(boolean carveAirSpace) {
        this.carveAirSpace = carveAirSpace;
        return this;
    }

    @NotNull
    public StairwayBuilder setUpwardsCarveUntilSolid(boolean carve) {
        this.upwardsCarveUntilSolid = carve;
        return this;
    }

    @NotNull
    public StairwayBuilder setUpwardsCarveUntilNotSolid(boolean carve) {
        this.upwardsCarveUntilNotSolid = carve;
        return this;
    }

    @NotNull
    public StairwayBuilder setDownTypes(Material ... mat) {
        this.downTypes = mat;
        return this;
    }

    @NotNull
    public StairwayBuilder build(@NotNull Wall start) {
        if (this.stairDirection == BlockFace.DOWN) {
            int threshold = 5;
            BlockFace extensionDir = start.getDirection();
            while (this.continueCondition(start)) {
                Material stairType;
                if (threshold == 0) {
                    start.setType(this.downTypes);
                    start.getDown().downUntilSolid(new Random(), this.downTypes);
                    extensionDir = BlockUtils.getTurnBlockFace(new Random(), extensionDir);
                    start = start.getRelative(extensionDir);
                }
                if ((stairType = this.stairTypes[new Random().nextInt(this.stairTypes.length)]).toString().endsWith("STAIRS")) {
                    new StairBuilder(stairType).setFacing(extensionDir.getOppositeFace()).apply(start);
                } else {
                    start.setType(stairType);
                }
                start.getDown().downUntilSolid(new Random(), this.downTypes);
                if (this.angled) {
                    --threshold;
                }
                start = start.getRelative(extensionDir).getDown();
            }
            if (this.stopAtWater && start.get().getType() != Material.OAK_SLAB && BlockUtils.isWet(start.get())) {
                for (int i = 0; i < this.maxExtensionForward && !start.isSolid(); ++i) {
                    start.downUntilSolid(new Random(), this.downTypes);
                    start = start.getFront();
                }
            }
        } else if (this.stairDirection == BlockFace.UP) {
            int threshold = 5;
            BlockFace extensionDir = start.getDirection();
            while (this.continueCondition(start)) {
                Material stairType;
                if (threshold == 0) {
                    start = start.getDown();
                    if (this.carveAirSpace) {
                        start.getUp().Pillar(3, new Random(), Material.AIR);
                    }
                    start.setType(this.downTypes);
                    start.getDown().downUntilSolid(new Random(), this.downTypes);
                    extensionDir = BlockUtils.getTurnBlockFace(new Random(), extensionDir);
                    start = start.getRelative(extensionDir).getUp();
                }
                if ((stairType = this.stairTypes[new Random().nextInt(this.stairTypes.length)]).toString().endsWith("STAIRS")) {
                    new StairBuilder(this.stairTypes).setFacing(extensionDir).apply(start);
                } else {
                    start.setType(stairType);
                }
                start.getDown().downUntilSolid(new Random(), this.downTypes);
                if (this.carveAirSpace) {
                    start.getUp().Pillar(3, new Random(), Material.AIR);
                    start.getUp(2).getRelative(extensionDir).setType(Material.AIR);
                }
                if (this.angled) {
                    --threshold;
                }
                start = start.getRelative(extensionDir).getUp();
            }
        } else {
            TerraformGeneratorPlugin.logger.error("StairwayBuilder was told to spawn stairway with non up/down stair direction!");
        }
        return this;
    }

    private boolean continueCondition(@NotNull Wall target) {
        if (this.stairDirection == BlockFace.DOWN) {
            if (this.stopAtY != Short.MIN_VALUE && target.getY() == this.stopAtY) {
                return false;
            }
            if (this.stopAtWater && BlockUtils.isWet(target.get())) {
                return false;
            }
            return !target.isSolid();
        }
        if (this.stopAtY != Short.MIN_VALUE && target.getY() == this.stopAtY + 1) {
            return false;
        }
        if (this.upwardsCarveUntilNotSolid) {
            return target.isSolid();
        }
        if (this.upwardsCarveUntilSolid) {
            return !target.isSolid();
        }
        return true;
    }

    @NotNull
    public StairwayBuilder setMaxExtensionForward(int extension) {
        this.maxExtensionForward = extension;
        return this;
    }

    @NotNull
    public StairwayBuilder setStairwayDirection(BlockFace stairDirection) {
        this.stairDirection = stairDirection;
        return this;
    }

    @NotNull
    public StairwayBuilder setStopAtWater(boolean stopAtWater) {
        this.stopAtWater = stopAtWater;
        return this;
    }

    @NotNull
    public StairwayBuilder setAngled(boolean angled) {
        this.angled = angled;
        return this;
    }
}

