/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.version;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.terraform.coregen.NMSInjectorAbstract;
import org.terraform.main.TerraformGeneratorPlugin;

public class Version {
    public static final String VERSION = Bukkit.getServer().getBukkitVersion().split("-")[0];
    public static final double DOUBLE = Version.toVersionDouble(VERSION);
    private static final Map<Double, String> availableVersions = new HashMap<Double, String>();

    public static boolean isAtLeast(double version) {
        return DOUBLE >= version;
    }

    public static String getVersionPackage() {
        return VERSION;
    }

    public static double toVersionDouble(@NotNull String version) {
        return Double.parseDouble(version.substring(2));
    }

    @Nullable
    public static NMSInjectorAbstract getInjector() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String spigotAppend;
        if (!availableVersions.containsKey(DOUBLE)) {
            return null;
        }
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
            spigotAppend = "";
        }
        catch (ClassNotFoundException ignored) {
            TerraformGeneratorPlugin.logger.info("Spigot detected");
            spigotAppend = "spigot.";
            try {
                Class.forName("org.terraform." + spigotAppend + availableVersions.get(DOUBLE) + ".NMSInjector").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException ignoreAgain) {
                TerraformGeneratorPlugin.logger.stdout("There was no spigot package for this version. This is fine if you are BELOW 1.21.9.");
                spigotAppend = "";
            }
        }
        return (NMSInjectorAbstract)Class.forName("org.terraform." + spigotAppend + availableVersions.get(DOUBLE) + ".NMSInjector").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    static {
        availableVersions.put(18.2, "v1_18_R2");
        availableVersions.put(19.4, "v1_19_R3");
        availableVersions.put(20.0, "v1_20_R1");
        availableVersions.put(20.1, "v1_20_R1");
        availableVersions.put(20.2, "v1_20_R2");
        availableVersions.put(20.3, "v1_20_R3");
        availableVersions.put(20.4, "v1_20_R3");
        availableVersions.put(20.5, "v1_20_R4");
        availableVersions.put(20.6, "v1_20_R4");
        availableVersions.put(21.0, "v1_21_R1");
        availableVersions.put(21.1, "v1_21_R1");
        availableVersions.put(21.2, "v1_21_R2");
        availableVersions.put(21.3, "v1_21_R2");
        availableVersions.put(21.4, "v1_21_R3");
        availableVersions.put(21.5, "v1_21_R4");
        availableVersions.put(21.6, "v1_21_R5");
        availableVersions.put(21.7, "v1_21_R5");
        availableVersions.put(21.8, "v1_21_R5");
        availableVersions.put(21.9, "v1_21_R6");
    }
}

