/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R2;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.WorldGenMonumentPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.NaturalSpawnType;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_18_R2.CustomBiomeHandler;

public class PopulatorDataICA
extends PopulatorDataICABiomeWriterAbstract {
    private final PopulatorDataAbstract parent;
    private final IChunkAccess ica;
    private final int chunkX;
    private final int chunkZ;
    private final WorldServer ws;
    private final TerraformWorld tw;

    public PopulatorDataICA(PopulatorDataAbstract parent, TerraformWorld tw, WorldServer ws, IChunkAccess ica, int chunkX, int chunkZ) {
        this.ica = ica;
        this.parent = parent;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.ws = ws;
        this.tw = tw;
    }

    @Override
    @NotNull
    public Material getType(int x, int y, int z) {
        IBlockData ibd = this.ica.a_(new BlockPosition(x, y, z));
        return CraftBlockData.fromData((IBlockData)ibd).getMaterial();
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        IBlockData ibd = this.ica.a_(new BlockPosition(x, y, z));
        return CraftBlockData.fromData((IBlockData)ibd);
    }

    @Override
    public void setBiome(int rawX, int rawY, int rawZ, CustomBiomeType cbt, Biome fallback) {
        Holder targetBiome;
        DedicatedServer dedicatedserver = ((CraftServer)Bukkit.getServer()).getServer();
        IRegistry biomeRegistry = dedicatedserver.aU().b(IRegistry.aP);
        if (cbt == CustomBiomeType.NONE) {
            targetBiome = CraftBlock.biomeToBiomeBase((IRegistry)this.ica.biomeRegistry, (Biome)fallback);
        } else {
            ResourceKey<BiomeBase> rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)cbt);
            targetBiome = biomeRegistry.g(rkey);
            if (targetBiome == null) {
                TerraformGeneratorPlugin.logger.error("Custom biome was not found in the vanilla registry!");
                targetBiome = CraftBlock.biomeToBiomeBase((IRegistry)this.ica.biomeRegistry, (Biome)fallback);
            }
        }
        this.ica.setBiome(rawX >> 2, rawY >> 2, rawZ >> 2, targetBiome);
    }

    @Override
    public void setBiome(int rawX, int rawY, int rawZ, Biome biome) {
        this.ica.setBiome(rawX >> 2, rawY >> 2, rawZ >> 2, CraftBlock.biomeToBiomeBase((IRegistry)this.ica.biomeRegistry, (Biome)biome));
    }

    @Override
    public void setType(int x, int y, int z, @NotNull Material type) {
        this.ica.a(new BlockPosition(x, y, z), ((CraftBlockData)Bukkit.createBlockData((Material)type)).getState(), false);
    }

    @Override
    public void setBlockData(int x, int y, int z, @NotNull BlockData data) {
        this.ica.a(new BlockPosition(x, y, z), ((CraftBlockData)data).getState(), false);
    }

    @Override
    public Biome getBiome(int rawX, int rawZ) {
        return this.parent.getBiome(rawX, rawZ);
    }

    @Override
    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public void addEntity(int rawX, int rawY, int rawZ, EntityType type) {
        this.parent.addEntity(rawX, rawY, rawZ, type);
    }

    @Override
    public void setSpawner(int rawX, int rawY, int rawZ, EntityType type) {
        this.parent.setSpawner(rawX, rawY, rawZ, type);
    }

    @Override
    public void lootTableChest(int x, int y, int z, @NotNull TerraLootTable table) {
        BlockPosition pos = new BlockPosition(x, y, z);
        TileEntityLootable.a((IBlockAccess)this.ica, (Random)this.tw.getHashedRand(x, y, z), (BlockPosition)pos, (MinecraftKey)this.getLootTable(table));
    }

    @Override
    public void registerNaturalSpawns(@NotNull NaturalSpawnType type, int x0, int y0, int z0, int x1, int y1, int z1) {
        ResourceKey structureKey = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NaturalSpawnType.GUARDIAN -> BuiltinStructures.l;
            case NaturalSpawnType.PILLAGER -> BuiltinStructures.a;
            case NaturalSpawnType.WITCH -> BuiltinStructures.j;
        };
        CraftServer craftserver = (CraftServer)Bukkit.getServer();
        DedicatedServer dedicatedserver = craftserver.getServer();
        IRegistry featureRegistry = dedicatedserver.aU().b(IRegistry.aL);
        StructureFeature structureFeature = (StructureFeature)featureRegistry.a(structureKey);
        WorldGenMonumentPieces.WorldGenMonumentPiece1 customBoundPiece = new WorldGenMonumentPieces.WorldGenMonumentPiece1(new Random(), x0, z0, EnumDirection.a);
        PiecesContainer container = new PiecesContainer((List)new ArrayList<StructurePiece>((StructurePiece)customBoundPiece){
            final /* synthetic */ StructurePiece val$customBoundPiece;
            {
                this.val$customBoundPiece = structurePiece;
                this.add(this.val$customBoundPiece);
            }
        });
        StructureStart start = new StructureStart(structureFeature, new ChunkCoordIntPair(this.chunkX, this.chunkZ), 0, container);
        try {
            Field i = StructureStart.class.getDeclaredField("g");
            i.setAccessible(true);
            i.set(start, new StructureBoundingBox(x0, y0, z0, x1, y1, z1));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            TerraformGeneratorPlugin.logger.stackTrace(e);
        }
        IChunkAccess sa = this.ica;
        sa.a(structureFeature, start);
        sa.a(structureFeature, new ChunkCoordIntPair(this.chunkX, this.chunkZ).a());
    }

    @Override
    public void spawnMinecartWithChest(int x, int y, int z, @NotNull TerraLootTable table, @NotNull Random random) {
        EntityMinecartChest entityminecartchest = new EntityMinecartChest((World)this.ws.getMinecraftWorld(), (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
        entityminecartchest.a(this.getLootTable(table), random.nextLong());
        this.ws.addFreshEntity((Entity)entityminecartchest, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
    }

    @Nullable
    private MinecraftKey getLootTable(@NotNull TerraLootTable table) {
        return switch (table) {
            case TerraLootTable.EMPTY -> LootTables.a;
            case TerraLootTable.SPAWN_BONUS_CHEST -> LootTables.b;
            case TerraLootTable.END_CITY_TREASURE -> LootTables.c;
            case TerraLootTable.SIMPLE_DUNGEON -> LootTables.d;
            case TerraLootTable.VILLAGE_WEAPONSMITH -> LootTables.e;
            case TerraLootTable.VILLAGE_TOOLSMITH -> LootTables.f;
            case TerraLootTable.VILLAGE_ARMORER -> LootTables.g;
            case TerraLootTable.VILLAGE_CARTOGRAPHER -> LootTables.h;
            case TerraLootTable.VILLAGE_MASON -> LootTables.i;
            case TerraLootTable.VILLAGE_SHEPHERD -> LootTables.j;
            case TerraLootTable.VILLAGE_BUTCHER -> LootTables.k;
            case TerraLootTable.VILLAGE_FLETCHER -> LootTables.l;
            case TerraLootTable.VILLAGE_FISHER -> LootTables.m;
            case TerraLootTable.VILLAGE_TANNERY -> LootTables.n;
            case TerraLootTable.VILLAGE_TEMPLE -> LootTables.o;
            case TerraLootTable.VILLAGE_DESERT_HOUSE -> LootTables.p;
            case TerraLootTable.VILLAGE_PLAINS_HOUSE -> LootTables.q;
            case TerraLootTable.VILLAGE_TAIGA_HOUSE -> LootTables.r;
            case TerraLootTable.VILLAGE_SNOWY_HOUSE -> LootTables.s;
            case TerraLootTable.VILLAGE_SAVANNA_HOUSE -> LootTables.t;
            case TerraLootTable.ABANDONED_MINESHAFT -> LootTables.u;
            case TerraLootTable.NETHER_BRIDGE -> LootTables.v;
            case TerraLootTable.STRONGHOLD_LIBRARY -> LootTables.w;
            case TerraLootTable.STRONGHOLD_CROSSING -> LootTables.x;
            case TerraLootTable.STRONGHOLD_CORRIDOR -> LootTables.y;
            case TerraLootTable.DESERT_PYRAMID -> LootTables.z;
            case TerraLootTable.JUNGLE_TEMPLE -> LootTables.A;
            case TerraLootTable.JUNGLE_TEMPLE_DISPENSER -> LootTables.B;
            case TerraLootTable.IGLOO_CHEST -> LootTables.C;
            case TerraLootTable.WOODLAND_MANSION -> LootTables.D;
            case TerraLootTable.UNDERWATER_RUIN_SMALL -> LootTables.E;
            case TerraLootTable.UNDERWATER_RUIN_BIG -> LootTables.F;
            case TerraLootTable.BURIED_TREASURE -> LootTables.G;
            case TerraLootTable.SHIPWRECK_MAP -> LootTables.H;
            case TerraLootTable.SHIPWRECK_SUPPLY -> LootTables.I;
            case TerraLootTable.SHIPWRECK_TREASURE -> LootTables.J;
            case TerraLootTable.PILLAGER_OUTPOST -> LootTables.K;
            case TerraLootTable.RUINED_PORTAL -> LootTables.P;
            default -> null;
        };
    }

    @Override
    @NotNull
    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }
}

