/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_19_R3;

import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_19_R3.util.RandomSourceWrapper;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.bukkit.NativeGeneratorPatcherPopulator;
import org.terraform.coregen.populatordata.IPopulatorDataBaseHeightAccess;
import org.terraform.coregen.populatordata.IPopulatorDataBeehiveEditor;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfig;
import org.terraform.v1_19_R3.NMSChunkGenerator;

public class PopulatorData
extends PopulatorDataAbstract
implements IPopulatorDataBaseHeightAccess,
IPopulatorDataBeehiveEditor {
    private static final HashMap<EntityType, EntityTypes<?>> entityTypesDict = new HashMap();
    final GeneratorAccessSeed rlwa;
    final IChunkAccess ica;
    private final int chunkX;
    private final int chunkZ;
    private final NMSChunkGenerator gen;
    private int radius = 1;

    public PopulatorData(GeneratorAccessSeed rlwa, IChunkAccess ica, NMSChunkGenerator gen, int chunkX, int chunkZ) {
        this.rlwa = rlwa;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.gen = gen;
        this.ica = ica;
        if (entityTypesDict.isEmpty()) {
            for (EntityType type : EntityType.values()) {
                if (type == EntityType.ENDER_SIGNAL || type == EntityType.UNKNOWN) continue;
                try {
                    Optional et = EntityTypes.a((String)("minecraft:" + type.toString().toLowerCase(Locale.ENGLISH)));
                    et.ifPresent(entityTypes -> entityTypesDict.put(type, (EntityTypes<?>)entityTypes));
                }
                catch (IllegalArgumentException e) {
                    TerraformGeneratorPlugin.logger.stackTrace(e);
                }
            }
        }
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    @NotNull
    public Material getType(int x, int y, int z) {
        try {
            return CraftMagicNumbers.getMaterial((Block)this.rlwa.a_(new BlockPosition(x, y, z)).b());
        }
        catch (Exception e) {
            Bukkit.getLogger().info("Error chunk: " + this.chunkX + "," + this.chunkZ + "--- Block Coords: " + 16 * this.chunkX + "," + 16 * this.chunkZ + " for coords " + x + "," + y + "," + z);
            TerraformGeneratorPlugin.logger.stackTrace(e);
            return null;
        }
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData((IBlockData)this.rlwa.a_(new BlockPosition(x, y, z)));
    }

    @Override
    public void setType(int x, int y, int z, @NotNull Material type) {
        if (Math.abs((x >> 4) - this.chunkX) > this.radius || Math.abs((z >> 4) - this.chunkZ) > this.radius) {
            if (this.radius > 0) {
                NativeGeneratorPatcherPopulator.pushChange(this.rlwa.getMinecraftWorld().getWorld().getName(), x, y, z, Bukkit.createBlockData((Material)type));
            } else {
                TerraformGeneratorPlugin.logger.stackTrace(new Exception("Tried to call adjacent chunk with populator radius 0: (" + x + "," + y + "," + z + ") for chunk (" + this.chunkX + "," + this.chunkZ + ")"));
            }
        } else {
            this.rlwa.a(new BlockPosition(x, y, z), ((CraftBlockData)Bukkit.createBlockData((Material)type)).getState(), 0);
        }
    }

    @Override
    public void setBlockData(int x, int y, int z, @NotNull BlockData data) {
        if (Math.abs((x >> 4) - this.chunkX) > this.radius || Math.abs((z >> 4) - this.chunkZ) > this.radius) {
            if (this.radius > 0) {
                NativeGeneratorPatcherPopulator.pushChange(this.rlwa.getMinecraftWorld().getWorld().getName(), x, y, z, data);
            } else {
                TerraformGeneratorPlugin.logger.stackTrace(new Exception("Tried to call adjacent chunk with populator radius 0: (" + x + "," + y + "," + z + ") for chunk (" + this.chunkX + "," + this.chunkZ + ")"));
            }
        } else {
            this.rlwa.a(new BlockPosition(x, y, z), ((CraftBlockData)data).getState(), 0);
        }
    }

    @Override
    public Biome getBiome(int rawX, int rawZ) {
        TerraformWorld tw = this.gen.getTerraformWorld();
        return tw.getBiomeBank(rawX, rawZ).getHandler().getBiome();
    }

    @Override
    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public void addEntity(int rawX, int rawY, int rawZ, @NotNull EntityType type) {
        if (Math.abs((rawX >> 4) - this.chunkX) > 1 || Math.abs((rawZ >> 4) - this.chunkZ) > 1) {
            TerraformGeneratorPlugin.logger.info("Failed to spawn " + String.valueOf(type) + " as it was out of bounds.");
            return;
        }
        CraftLimitedRegion clr = new CraftLimitedRegion(this.rlwa, this.ica.f());
        Entity e = clr.createEntity(new Location(this.gen.getTerraformWorld().getWorld(), (double)rawX, (double)rawY, (double)rawZ), type.getEntityClass());
        this.rlwa.b(e);
    }

    @Override
    public void setSpawner(int rawX, int rawY, int rawZ, EntityType type) {
        if (!TConfig.c.FEATURE_SPAWNERS_ENABLED) {
            return;
        }
        BlockPosition pos = new BlockPosition(rawX, rawY, rawZ);
        this.setType(rawX, rawY, rawZ, Material.SPAWNER);
        TileEntity tileentity = this.rlwa.c_(pos);
        if (tileentity instanceof TileEntityMobSpawner) {
            try {
                EntityTypes<?> nmsEntity = entityTypesDict.get(type);
                if (nmsEntity == null) {
                    TerraformGeneratorPlugin.logger.error(String.valueOf(type) + " was not present in the entityTypesDict.");
                }
                ((TileEntityMobSpawner)tileentity).a(nmsEntity, (RandomSource)new RandomSourceWrapper(new Random()));
            }
            catch (IllegalArgumentException | SecurityException e) {
                TerraformGeneratorPlugin.logger.stackTrace(e);
            }
        } else {
            TerraformGeneratorPlugin.logger.error("Failed to fetch mob spawner entity at (," + rawX + "," + rawY + "," + rawZ + ")");
        }
    }

    @Override
    public void lootTableChest(int x, int y, int z, @NotNull TerraLootTable table) {
        BlockPosition pos = new BlockPosition(x, y, z);
        TileEntityLootable.a((IBlockAccess)this.rlwa, (RandomSource)RandomSource.a((long)this.gen.getTerraformWorld().getHashedRand(x, y, z).nextLong()), (BlockPosition)pos, (MinecraftKey)this.getLootTable(table));
    }

    @Nullable
    private MinecraftKey getLootTable(@NotNull TerraLootTable table) {
        return switch (table) {
            case TerraLootTable.EMPTY -> LootTables.a;
            case TerraLootTable.SPAWN_BONUS_CHEST -> LootTables.b;
            case TerraLootTable.END_CITY_TREASURE -> LootTables.c;
            case TerraLootTable.SIMPLE_DUNGEON -> LootTables.d;
            case TerraLootTable.VILLAGE_WEAPONSMITH -> LootTables.e;
            case TerraLootTable.VILLAGE_TOOLSMITH -> LootTables.f;
            case TerraLootTable.VILLAGE_ARMORER -> LootTables.g;
            case TerraLootTable.VILLAGE_CARTOGRAPHER -> LootTables.h;
            case TerraLootTable.VILLAGE_MASON -> LootTables.i;
            case TerraLootTable.VILLAGE_SHEPHERD -> LootTables.j;
            case TerraLootTable.VILLAGE_BUTCHER -> LootTables.k;
            case TerraLootTable.VILLAGE_FLETCHER -> LootTables.l;
            case TerraLootTable.VILLAGE_FISHER -> LootTables.m;
            case TerraLootTable.VILLAGE_TANNERY -> LootTables.n;
            case TerraLootTable.VILLAGE_TEMPLE -> LootTables.o;
            case TerraLootTable.VILLAGE_DESERT_HOUSE -> LootTables.p;
            case TerraLootTable.VILLAGE_PLAINS_HOUSE -> LootTables.q;
            case TerraLootTable.VILLAGE_TAIGA_HOUSE -> LootTables.r;
            case TerraLootTable.VILLAGE_SNOWY_HOUSE -> LootTables.s;
            case TerraLootTable.VILLAGE_SAVANNA_HOUSE -> LootTables.t;
            case TerraLootTable.ABANDONED_MINESHAFT -> LootTables.u;
            case TerraLootTable.NETHER_BRIDGE -> LootTables.v;
            case TerraLootTable.STRONGHOLD_LIBRARY -> LootTables.w;
            case TerraLootTable.STRONGHOLD_CROSSING -> LootTables.x;
            case TerraLootTable.STRONGHOLD_CORRIDOR -> LootTables.y;
            case TerraLootTable.DESERT_PYRAMID -> LootTables.z;
            case TerraLootTable.JUNGLE_TEMPLE -> LootTables.A;
            case TerraLootTable.JUNGLE_TEMPLE_DISPENSER -> LootTables.B;
            case TerraLootTable.IGLOO_CHEST -> LootTables.C;
            case TerraLootTable.WOODLAND_MANSION -> LootTables.D;
            case TerraLootTable.UNDERWATER_RUIN_SMALL -> LootTables.E;
            case TerraLootTable.UNDERWATER_RUIN_BIG -> LootTables.F;
            case TerraLootTable.BURIED_TREASURE -> LootTables.G;
            case TerraLootTable.SHIPWRECK_MAP -> LootTables.H;
            case TerraLootTable.SHIPWRECK_SUPPLY -> LootTables.I;
            case TerraLootTable.SHIPWRECK_TREASURE -> LootTables.J;
            case TerraLootTable.PILLAGER_OUTPOST -> LootTables.K;
            case TerraLootTable.ANCIENT_CITY -> LootTables.P;
            case TerraLootTable.ANCIENT_CITY_ICE_BOX -> LootTables.Q;
            case TerraLootTable.RUINED_PORTAL -> LootTables.R;
            default -> null;
        };
    }

    @Override
    @NotNull
    public TerraformWorld getTerraformWorld() {
        return this.gen.getTerraformWorld();
    }

    @Override
    public int getBaseHeight(int rawX, int rawZ) {
        return 100;
    }

    @Override
    public void setBeehiveWithBee(int rawX, int rawY, int rawZ) {
        BlockPosition pos = new BlockPosition(rawX, rawY, rawZ);
        this.setType(rawX, rawY, rawZ, Material.BEE_NEST);
        try {
            TileEntityBeehive tileentity = (TileEntityBeehive)this.rlwa.c_(pos);
            if (tileentity == null) {
                this.setType(rawX, rawY, rawZ, Material.BEE_NEST);
                tileentity = (TileEntityBeehive)this.rlwa.c_(pos);
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.a("id", "minecraft:bee");
            tileentity.a(nbttagcompound, 0, false);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException e) {
            TerraformGeneratorPlugin.logger.stackTrace(e);
        }
    }
}

